/* LocaleInformation_am.java --
   Copyright (C) 2004  Free Software Foundation, Inc.

This file is part of GNU Classpath.

GNU Classpath is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

GNU Classpath is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Classpath; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
02111-1307 USA.

Linking this library statically or dynamically with other modules is
making a combined work based on this library.  Thus, the terms and
conditions of the GNU General Public License cover the whole
combination.

As a special exception, the copyright holders of this library give you
permission to link this library with independent modules to produce an
executable, regardless of the license terms of these independent
modules, and to copy and distribute the resulting executable under
terms of your choice, provided that you also meet, for each linked
independent module, the terms and conditions of the license of that
module.  An independent module is a module which is not derived from
or based on this library.  If you modify this library, you may extend
this exception to your version of the library, but you are not
obligated to do so.  If you do not wish to do so, delete this
exception statement from your version. */


// This file was automatically generated by gnu.localegen from LDML

package gnu.java.locale;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.ListResourceBundle;

public class LocaleInformation_am extends ListResourceBundle
{
  private static final String[] shortMonths = {
    "\u1303\u1295\u12e9",
    "\u134c\u1265\u1229",
    "\u121b\u122d\u127d",
    "\u12a4\u1355\u1228",
    "\u121c\u12ed",
    "\u1301\u1295",
    "\u1301\u120b\u12ed",
    "\u12a6\u1308\u1235",
    "\u1234\u1355\u1274",
    "\u12a6\u12ad\u1270",
    "\u1296\u126c\u121d",
    "\u12f2\u1234\u121d",
    null,
  };

  private static final String[] months = {
    "\u1303\u1295\u12e9\u12c8\u122a",
    "\u134c\u1265\u1229\u12c8\u122a",
    "\u121b\u122d\u127d",
    "\u12a4\u1355\u1228\u120d",
    "\u121c\u12ed",
    "\u1301\u1295",
    "\u1301\u120b\u12ed",
    "\u12a6\u1308\u1235\u1275",
    "\u1234\u1355\u1274\u121d\u1260\u122d",
    "\u12a6\u12ad\u1270\u12cd\u1260\u122d",
    "\u1296\u126c\u121d\u1260\u122d",
    "\u12f2\u1234\u121d\u1260\u122d",
    null,
  };

  private static final String[] shortWeekdays = {
    null,
    "\u12a5\u1211\u12f5",
    "\u1230\u129e",
    "\u121b\u12ad\u1230",
    "\u1228\u1261\u12d5",
    "\u1210\u1219\u1235",
    "\u12d3\u122d\u1265",
    "\u1245\u12f3\u121c",
  };

  private static final String[] weekdays = {
    null,
    "\u12a5\u1211\u12f5",
    "\u1230\u129e",
    "\u121b\u12ad\u1230\u129e",
    "\u1228\u1261\u12d5",
    "\u1210\u1219\u1235",
    "\u12d3\u122d\u1265",
    "\u1245\u12f3\u121c",
  };

  private static final String[] eras = {
    "\u12d3/\u12d3",
    "\u12d3/\u121d",
  };

  private static final String territoriesKeys = "AU|TD|GY|AT|GW|AR|MY|MX|AN|GR|AM|ZA|GQ|AL|MU|SY|MT|GN|MR|GM|MO|AE|MN|AD|YU|SP|MK|GF|SO|GE|SN|GB|SK|SI|MD|SG|MA|SE|SD|SA|YE|LY|LV|LT|FM|RU|FJ|FI|RO|LB|ET|ES|KW|ER|KR|KP|KM|EH|EG|EE|KH|EC|DZ|DO|DM|JP|DK|JO|PR|JM|DE|PL|PG|PF|PE|CZ|VI|CY|VG|CV|VE|IT|CO|IS|CN|CM|IQ|CL|UZ|IN|CH|IL|CF|US|CD|IE|ID|BZ|BY|UG|BT|BR|NZ|HU|HT|BO|HR|BM|TZ|BH|BG|NP|HK|TT|NO|BE|TR|NL|BB|BA|TN|TL|NG|TJ|AZ|ZM|TH|NC|TF|NA";

  private static final String territoriesValues = "\u12a0\u12cd\u1235\u1275\u122c\u120a\u12eb|\u127b\u12f5|\u1309\u12eb\u1293|\u12a6\u1235\u1275\u122a\u12eb|\u1262\u1233\u12ce|\u12a0\u122d\u1300\u1295\u1272\u1293|\u121b\u120c\u12e2\u12eb|\u121c\u12ad\u1232\u12ae|\u1294\u12d8\u122d\u120b\u1295\u12f5\u1235 \u12a0\u1295\u1272\u120d\u1235|\u130d\u122a\u12ad|\u12a0\u122d\u121c\u1292\u12eb|\u12f0\u1261\u1265 \u12a0\u134d\u122a\u12ab|\u12a2\u12b3\u1276\u122a\u12eb\u120d \u130a\u1292|\u12a0\u120d\u1263\u1292\u12eb|\u121b\u1229\u1238\u1235|\u1232\u122a\u12eb|\u121b\u120d\u1273|\u130a\u1292|\u121e\u122a\u1274\u1292\u12eb|\u130b\u121d\u1262\u12eb|\u121b\u12ab\u12ce|\u12e8\u1270\u1263\u1260\u1229\u1275 \u12a0\u1228\u1265 \u12a4\u121d\u122c\u1275\u1235|\u121e\u1295\u130e\u120a\u12eb|\u12a0\u1295\u12f6\u122b|\u12e9\u130e\u12dd\u120b\u126a\u12eb|\u1230\u122d\u1262\u12eb|\u121b\u12a8\u12f6\u1292\u12eb|\u12e8\u1348\u1228\u1295\u1233\u12ed \u1309\u12ca\u12a0\u1293|\u1231\u121b\u120c|\u1306\u122d\u1302\u12eb|\u1234\u1294\u130b\u120d|\u12a5\u1295\u130d\u120a\u12dd|\u1235\u120e\u126b\u12aa\u12eb|\u1235\u120e\u126c\u1292\u12eb|\u121e\u120d\u12f6\u126b|\u1232\u1295\u130b\u1356\u122d|\u121e\u122e\u12ae|\u1235\u12ca\u12f5\u1295|\u1231\u12f3\u1295|\u1233\u12cd\u12f5\u12a0\u1228\u1262\u12eb|\u12e8\u1218\u1295|\u120a\u1262\u12eb|\u120b\u1275\u126a\u12eb|\u120a\u1271\u12cc\u1292\u12eb|\u121a\u12ad\u122e\u1294\u12e2\u12eb|\u122b\u123a\u12eb|\u134a\u1302|\u134a\u1295\u120b\u1295\u12f5|\u122e\u121c\u1292\u12eb|\u120a\u1263\u1296\u1235|\u12a2\u1275\u12ee\u1335\u12eb|\u1235\u1354\u1295|\u12ad\u12cc\u1275|\u12a4\u122d\u1275\u122b|\u1230\u121c\u1295 \u12ae\u122a\u12eb|\u12f0\u1261\u1265 \u12ae\u122a\u12eb|\u12ae\u121e\u122e\u1235|\u121d\u12d5\u122b\u1263\u12ca \u1233\u1205\u122b|\u130d\u1265\u133d|\u12a4\u1235\u1276\u1292\u12eb|\u12ab\u121d\u1266\u12f2\u12eb|\u12a2\u12b3\u12f6\u122d|\u12a0\u120d\u1304\u122a\u12eb|\u12f6\u121a\u1292\u12ad \u122a\u1351\u1265\u120a\u12ad|\u12f6\u121a\u1292\u12ab|\u1303\u1353\u1295|\u12f4\u1295\u121b\u122d\u12ad|\u1306\u122d\u12f3\u1295|\u1356\u122d\u1273 \u122a\u12ae|\u1303\u121b\u12ed\u12ab|\u1300\u122d\u1218\u1295|\u1356\u120b\u1295\u12f5|\u1353\u1351\u12cb \u1292\u12cd \u130a\u1292|\u12e8\u1348\u1228\u1295\u1233\u12ed \u1356\u120a\u1294\u12e2\u12eb|\u1354\u1229|\u127c\u12ad \u122a\u1351\u1265\u120a\u12ad|\u12e8\u12a0\u121c\u122a\u12ab \u1268\u122d\u1302\u1295 \u12f0\u1234\u1276\u127d|\u1233\u12ed\u1355\u1228\u1235|\u12e8\u12a5\u1295\u130d\u120a\u12dd \u12f5\u1295\u130d\u120d \u12f0\u1234\u1276\u127d|\u12ac\u1355 \u126c\u122d\u12f4|\u126c\u1295\u12d9\u12cc\u120b|\u1323\u120a\u12eb\u1295|\u12ae\u120e\u121d\u1262\u12eb|\u12a0\u12ed\u1235\u120b\u1295\u12f5|\u127b\u12ed\u1293|\u12ab\u121c\u1229\u1295|\u12a2\u122b\u1245|\u127a\u120a|\u12e9\u12dd\u1260\u12aa\u1235\u1273\u1295|\u1205\u1295\u12f5|\u1235\u12ca\u12d8\u122d\u120b\u1295\u12f5|\u12a5\u1235\u122b\u12a4\u120d|\u12e8\u1218\u12ab\u12a8\u1208\u129b\u12cd \u12a0\u134d\u122a\u12ab \u122a\u1350\u1265\u120a\u12ad|\u12a0\u121c\u122a\u12ab|\u12ae\u1295\u130e|\u12a0\u12e8\u122d\u120b\u1295\u12f5|\u12a2\u1295\u12f6\u1294\u12e2\u12eb|\u1264\u120a\u12d8|\u1264\u120b\u1229\u1235|\u12e9\u130b\u1295\u12f3|\u1261\u1205\u1273\u1295|\u1265\u122b\u12da\u120d|\u1292\u12cd \u12da\u120b\u1295\u12f5|\u1200\u1295\u130b\u122a|\u1200\u12ed\u1272|\u1266\u120a\u126a\u12eb|\u12ad\u122e\u12a4\u123d\u12eb|\u1264\u122d\u1219\u12f3|\u1273\u1295\u12db\u1292\u12eb|\u1263\u1205\u122c\u1295|\u1261\u120d\u130c\u122a\u12eb|\u1294\u1353\u120d|\u1206\u1295\u130d \u12ae\u1295\u130d|\u1275\u122a\u1292\u12f3\u12f5 \u12a5\u1293 \u1276\u1263\u130e|\u1296\u122d\u12cc|\u1264\u120d\u1304\u121d|\u1271\u122d\u12ad|\u1294\u12d8\u122d\u120b\u1295\u12f5|\u1263\u122d\u1264\u12f6\u1235|\u1266\u1235\u1292\u12eb \u12a5\u1293 \u1204\u122d\u12de\u130e\u126a\u1292\u12eb|\u1271\u1292\u12da\u12eb|\u121d\u1235\u122b\u1245 \u1272\u121e\u122d|\u1293\u12ed\u1304\u122a\u12eb|\u1273\u1303\u12aa\u1235\u1273\u1295|\u12a0\u12d8\u122d\u1263\u1303\u1295|\u12db\u121d\u1262\u12eb|\u1273\u12ed\u120b\u1295\u12f5|\u1292\u12cd \u12ab\u120c\u12f6\u1292\u12eb|\u12e8\u1348\u1228\u1295\u1233\u12ed \u12f0\u1261\u1263\u12ca \u130d\u12db\u1276\u127d|\u1293\u121a\u1262\u12eb";

  private static final Hashtable territories;
  static
  {
    territories = new Hashtable();
    Enumeration keys = new StringTokenizer(territoriesKeys, "|");
    Enumeration values = new StringTokenizer(territoriesValues, "|");
    while (keys.hasMoreElements())
      {
         String key = (String) keys.nextElement();
         String value = (String) values.nextElement();
         territories.put(key, value);
      }
  }

  private static final String languagesKeys = "es|ku|eo|ks|en|el|qu|ko|kn|km|kl|kk|wo|ka|dz|jv|pt|ps|de|pl|da|vo|ja|vi|cy|pa|cs|iu|it|co|is|uz|or|ik|ur|om|ca|ie|id|uk|ia|oc|ug|hy|br|hu|bo|bn|hr|bi|tw|bh|bg|tt|no|be|ts|hi|tr|nl|zu|ba|to|he|tn|tl|tk|ha|ne|az|ti|ay|th|tg|na|te|zh|as|ar|ta|gu|my|am|za|mt|ms|byn|gn|sw|mr|sv|gl|su|af|st|mo|ss|mn|gez|sr|sq|ml|ab|mk|aa|so|sn|mi|gd|sm|sl|mg|tig|sk|ga|yo|si|sg|yi|sd|fy|sid|sa|fr|lv|lt|fo|rw|ru|lo|fj|ln|fi|ro|rn|rm|fa|la|xh|eu|ky|et";

  private static final String languagesValues = "\u1235\u1353\u1292\u123d|\u12a9\u122d\u12f5\u123d\u129b|\u12a4\u1235\u1350\u122b\u1295\u1276|\u12ab\u123d\u121a\u122d\u129b|\u12a5\u1295\u130d\u120a\u12dd\u129b|\u130d\u122a\u12ad\u129b|\u12b5\u127f\u129b|\u12ae\u122a\u12eb\u129b|\u12ab\u1293\u12f3\u129b|\u12ad\u1218\u122d\u129b|\u12ab\u120b\u120a\u1231\u1275\u129b|\u12ab\u12db\u12ad\u129b|\u12ce\u120e\u134d\u129b|\u130a\u12ee\u122d\u130a\u12eb\u1295|\u12f5\u12de\u1295\u130d\u12bb\u129b|\u1303\u126b\u1295\u129b|\u1356\u122d\u1271\u130b\u120a\u129b|\u1351\u123d\u1276\u129b|\u1300\u122d\u1218\u1295|\u1356\u120a\u123d|\u12f4\u1292\u123d|\u126e\u120b\u1351\u12ad\u129b|\u1303\u1353\u1295\u129b|\u126a\u1275\u1293\u121d\u129b|\u12c8\u120d\u123d|\u1353\u1295\u1303\u1262\u129b|\u127c\u12ad\u129b|\u12a5\u1291\u12ad\u1272\u1271\u1275\u129b|\u1323\u120a\u12eb\u1295\u129b|\u12ae\u122d\u1232\u12ab\u129b|\u12a0\u12ed\u1235\u120b\u1295\u12f5\u129b|\u12a1\u12dd\u1260\u12ad\u129b|\u12a6\u122a\u12eb\u129b|\u12a5\u1291\u1352\u12eb\u1245\u129b|\u12a1\u122d\u12f1\u129b|\u12a6\u122e\u121d\u129b|\u12ab\u1273\u120b\u1295\u129b|\u12a5\u1295\u1270\u122d\u120a\u1295\u130d\u12c8|\u12a5\u1295\u12f6\u1292\u1232\u129b|\u12e9\u12ad\u1228\u1292\u129b|\u12a2\u1295\u1274\u122d\u120a\u1295\u1313|\u12a6\u12aa\u1273\u1295\u129b|\u12a1\u12ca\u130d\u1201\u122d\u129b|\u12a0\u122d\u1218\u1293\u12ca|\u1265\u122c\u1276\u1295\u129b|\u1200\u1295\u130b\u122a\u129b|\u1275\u1260\u1275\u1295\u129b|\u1260\u1295\u130b\u120a\u129b|\u12ad\u122e\u123d\u12eb\u1295\u129b|\u1262\u1235\u120b\u121d\u129b|\u1275\u12ca\u129b|\u1262\u1203\u122a|\u1261\u120d\u130b\u122a\u129b|\u1273\u1273\u122d\u129b|\u1296\u122d\u12cc\u1302\u12eb\u1295|\u1264\u120b\u122b\u123b\u129b|\u133e\u1295\u130b\u129b|\u1210\u1295\u12f5\u129b|\u1271\u122d\u12ad\u129b|\u12f0\u127d|\u12d9\u1209\u129b|\u1263\u1235\u12aa\u122d\u129b|\u1276\u1295\u130b|\u12d5\u1265\u122b\u1235\u1325|\u133d\u12cb\u1293\u12ca\u129b|\u1273\u130b\u120e\u1308\u129b|\u1271\u122d\u12ad\u1218\u1295\u129b|\u1203\u12cd\u1233\u129b|\u1294\u1353\u120a\u129b|\u12a0\u12dc\u122d\u1263\u12ed\u1303\u1295\u129b|\u1275\u130d\u122d\u129b|\u12a0\u12eb\u121b\u122d\u129b|\u1273\u12ed\u129b|\u1273\u1302\u12aa\u129b|\u1293\u12a1\u1229|\u1270\u1209\u1309\u129b|\u127b\u12ed\u1295\u129b|\u12a0\u1233\u121c\u12db\u12ca|\u12d0\u122d\u1262\u129b|\u1273\u121a\u120d\u129b|\u1309\u1303\u122d\u1272\u129b|\u1261\u122d\u121b\u129b|\u12a0\u121b\u122d\u129b|\u12e1\u12cb\u1295\u130d\u129b|\u121b\u120d\u1272\u1235\u129b|\u121b\u120b\u12ed\u129b|\u1265\u120a\u1295|\u1313\u122b\u1292\u129b|\u1235\u12cb\u1202\u120a\u129b|\u121b\u122b\u12da\u129b|\u1235\u12ca\u12f5\u1295\u129b|\u130b\u1208\u130b\u129b|\u1231\u12f3\u1295\u129b|\u12a0\u134d\u122a\u1243\u1295\u1235\u129b|\u1236\u12de\u129b|\u121e\u120d\u12f3\u126b\u12ca\u1293|\u1235\u12cb\u1272\u129b|\u121e\u1295\u130e\u120b\u12ca\u129b|\u130d\u12d5\u12dd\u129b|\u1230\u122d\u1262\u129b|\u120d\u1264\u1292\u129b|\u121b\u120b\u12eb\u120b\u121d\u129b|\u12a0\u1265\u1210\u12da\u129b|\u121b\u12a8\u12f6\u1292\u129b|\u12a0\u134b\u122d\u129b|\u1231\u121b\u120d\u129b|\u123e\u1293\u129b|\u121b\u12ee\u122a\u129b|\u12a5\u1235\u12ae\u1275\u1235 \u130c\u120d\u12ad\u129b|\u1233\u121e\u12a0\u129b|\u1235\u120e\u126a\u129b|\u121b\u120b\u130b\u1235\u129b|\u1275\u130d\u1228|\u1235\u120e\u126b\u12ad\u129b|\u12a0\u12ed\u122a\u123d|\u12ee\u1229\u1263\u12ca\u129b|\u1235\u1295\u1203\u120d\u129b|\u1233\u1295\u130e\u129b|\u12ed\u12f2\u123b\u12ca\u129b|\u1232\u1295\u12f5\u1202\u129b|\u134d\u122a\u1235\u129b|\u1232\u12f3\u121d\u129b|\u1233\u1295\u1235\u12ad\u122a\u1275\u129b|\u1348\u1228\u1295\u1233\u12ed\u129b|\u120b\u1275\u126a\u12eb\u1295|\u120a\u1271\u12a0\u1292\u12eb\u1295|\u134b\u122e\u129b|\u12aa\u1295\u12eb\u122d\u12cb\u1295\u12f5\u129b|\u122b\u123d\u129b|\u120b\u12cd\u1235\u129b|\u134a\u1302\u129b|\u120a\u1295\u130b\u120b\u129b|\u134a\u1292\u123d|\u122e\u121b\u1292\u12eb\u1295|\u1229\u1295\u12f2\u129b|\u122e\u121b\u1295\u1235|\u1350\u122d\u1232\u12eb\u129b|\u120b\u1272\u1295\u129b|\u12de\u1233\u129b|\u1263\u1235\u12ad\u129b|\u12aa\u122d\u130a\u12dd\u129b|\u12a4\u1235\u1276\u1292\u12a0\u1295";

  private static final Hashtable languages;
  static
  {
    languages = new Hashtable();
    Enumeration keys = new StringTokenizer(languagesKeys, "|");
    Enumeration values = new StringTokenizer(languagesValues, "|");
    while (keys.hasMoreElements())
      {
         String key = (String) keys.nextElement();
         String value = (String) values.nextElement();
         languages.put(key, value);
      }
  }

  private static final Object[][] contents =
  {
    { "shortMonths", shortMonths },
    { "months", months },
    { "shortWeekdays", shortWeekdays },
    { "weekdays", weekdays },
    { "eras", eras },
    { "territories", territories },
    { "languages", languages },
  };

  public Object[][] getContents() { return contents; }
}
