#include "EXTERN.h"
#include "perl.h"
#include "XSUB.h"

MODULE = Symtab::Hash PACKAGE = Symtab::Hash

unsigned long
hash (salt, key)
    unsigned long salt
    char *key
  CODE:
    unsigned long hash;

    hash = salt * 0x9E3779B9;
    do
      hash = (*key ^ hash) + ((hash << 26) + (hash >> 6));
    while (*(++key));

    RETVAL = hash;
  OUTPUT:
    RETVAL

unsigned short
log2 (val)
    unsigned short val
  CODE:
    register unsigned short i;

    for (i = 0; (1<<i) < val; i++)
      ;
    RETVAL = i;
  OUTPUT:
    RETVAL

unsigned short
permute (x, nbits)
    unsigned short x
    unsigned short nbits
  CODE:
    unsigned short mask = (1 << nbits) - 1;
    unsigned short const2 = 1 + nbits / 2;
    unsigned short const3 = 1 + nbits / 3;
    unsigned short const4 = 1 + nbits / 4;
    unsigned short const5 = 1 + nbits / 5;
    int i;

    for (i = 0; i < 20; i++)
      {
	x = (x + (x << const2)) & mask;
	x = (x ^ (x >> const3));
	x = (x + (x << const4)) & mask;
	x = (x ^ (x >> const5));
      }
    RETVAL = x;
  OUTPUT:
    RETVAL

