/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.utils.ast;

import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.TypeDeclaration;

public class BodyDeclarationTarget {
    private final TypeDeclaration m_type;
    private final BodyDeclaration m_declaration;
    private final boolean m_before;

    public BodyDeclarationTarget(TypeDeclaration type, boolean before) {
        this(type, null, before);
    }

    public BodyDeclarationTarget(BodyDeclaration declaration, boolean before) {
        this(null, declaration, before);
    }

    public BodyDeclarationTarget(TypeDeclaration type, BodyDeclaration declaration, boolean before) {
        this.m_type = type;
        this.m_declaration = declaration;
        this.m_before = before;
    }

    public String toString() {
        return String.valueOf(this.m_before ? "before " : "after ") + (this.m_declaration != null ? this.m_declaration : this.m_type);
    }

    public ASTNode getNode() {
        return this.m_type != null ? this.m_type : this.m_declaration;
    }

    public TypeDeclaration getType() {
        return this.m_type;
    }

    public BodyDeclaration getDeclaration() {
        return this.m_declaration;
    }

    public boolean isBefore() {
        return this.m_before;
    }

    public boolean isAfter() {
        return !this.m_before;
    }
}

