/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.xwt.editor;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.wb.internal.core.utils.IOUtils2;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.core.utils.execution.RunnableObjectEx;
import org.eclipse.wb.internal.core.utils.xml.AbstractDocumentHandler;
import org.eclipse.wb.internal.core.utils.xml.DocumentEditContext;
import org.eclipse.wb.internal.core.xml.editor.actions.IPairResourceProvider;

public final class XwtPairResourceProvider
implements IPairResourceProvider {
    public static final IPairResourceProvider INSTANCE = new XwtPairResourceProvider();

    private XwtPairResourceProvider() {
    }

    public IFile getPair(final IFile file) {
        return (IFile)ExecutionUtils.runObjectIgnore((RunnableObjectEx)new RunnableObjectEx<IFile>(){

            public IFile runObject() throws Exception {
                if (file.getFileExtension().equalsIgnoreCase("XWT")) {
                    return XwtPairResourceProvider.this.getJavaFile(file);
                }
                if (file.getFileExtension().equalsIgnoreCase("JAVA")) {
                    return XwtPairResourceProvider.this.getXWTFile(file);
                }
                return null;
            }
        }, null);
    }

    private IFile getJavaFile(IFile xwtFile) throws Exception {
        IType type;
        String className;
        IProject project = xwtFile.getProject();
        IJavaProject javaProject = JavaCore.create((IProject)project);
        String content = IOUtils2.readString((IFile)xwtFile);
        if (content.contains("Class") && (className = XwtPairResourceProvider.getClassAttribute(content)) != null && (type = javaProject.findType(className)) != null) {
            return (IFile)type.getCompilationUnit().getUnderlyingResource();
        }
        IFolder folder = (IFolder)xwtFile.getParent();
        IPackageFragment packageFragment = (IPackageFragment)JavaCore.create((IFolder)folder);
        String formName = xwtFile.getFullPath().removeFileExtension().lastSegment();
        String typeName = String.valueOf(packageFragment.getElementName()) + "." + formName;
        IType type2 = javaProject.findType(typeName);
        if (type2 != null) {
            return (IFile)type2.getCompilationUnit().getUnderlyingResource();
        }
        return null;
    }

    private static String getClassAttribute(String content) throws Exception {
        Document document = new Document(content);
        DocumentEditContext context = new DocumentEditContext((IDocument)document){

            protected AbstractDocumentHandler createDocumentHandler() {
                return new AbstractDocumentHandler();
            }
        };
        try {
            String string = context.getRoot().getAttribute("x:Class");
            return string;
        }
        finally {
            context.disconnect();
        }
    }

    private IFile getXWTFile(IFile javaFile) throws Exception {
        IFolder folder = (IFolder)javaFile.getParent();
        IPackageFragment packageFragment = (IPackageFragment)JavaCore.create((IFolder)folder);
        Object[] objectArray = packageFragment.getNonJavaResources();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IFile xwtFile;
            IFile sameJavaFile;
            Object object = objectArray[n2];
            if (object instanceof IFile && javaFile.equals((Object)(sameJavaFile = this.getJavaFile(xwtFile = (IFile)object)))) {
                return xwtFile;
            }
            ++n2;
        }
        return null;
    }
}

