/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.draw2d;

import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wb.draw2d.Figure;
import org.eclipse.wb.internal.core.EnvironmentUtils;
import org.eclipse.wb.internal.core.utils.ui.GridLayoutFactory;
import org.eclipse.wb.internal.draw2d.EventManager;
import org.eclipse.wb.internal.draw2d.FigureCanvas;
import org.eclipse.wb.internal.draw2d.ICustomTooltipProvider;
import org.eclipse.wb.internal.draw2d.ICustomTooltipSite;

public final class CustomTooltipManager
implements ICustomTooltipSite {
    private final FigureCanvas m_canvas;
    private final EventManager m_eventManager;
    private Shell m_tooltipShell;
    private Figure m_tooltipFigure;
    private final Listener m_hideListener = new Listener(){

        public void handleEvent(Event event) {
            Control tooltipControl = (Control)event.widget;
            switch (event.type) {
                case 3: {
                    Point p = tooltipControl.toDisplay(event.x, event.y);
                    p = CustomTooltipManager.this.m_canvas.toControl(p);
                    Event newEvent = new Event();
                    newEvent.x = p.x;
                    newEvent.y = p.y;
                    CustomTooltipManager.this.m_canvas.notifyListeners(3, newEvent);
                    CustomTooltipManager.this.hideTooltip();
                    break;
                }
                case 7: {
                    CustomTooltipManager.this.hideTooltip();
                }
            }
        }
    };

    public CustomTooltipManager(FigureCanvas canvas, EventManager eventManager) {
        this.m_canvas = canvas;
        this.m_eventManager = eventManager;
        this.m_canvas.addMouseTrackListener(new MouseTrackListener(){

            public void mouseHover(MouseEvent event) {
                if (event.stateMask == 0 && (CustomTooltipManager.this.m_tooltipFigure == null || CustomTooltipManager.this.m_tooltipFigure != CustomTooltipManager.this.m_eventManager.getCursorFigure())) {
                    CustomTooltipManager.this.handleShowCustomTooltip(event.x, event.y);
                }
            }

            public void mouseExit(MouseEvent event) {
                Control cursorControl = Display.getCurrent().getCursorControl();
                if (cursorControl == null || cursorControl.getShell() != CustomTooltipManager.this.m_tooltipShell) {
                    CustomTooltipManager.this.hideTooltip();
                }
            }

            public void mouseEnter(MouseEvent event) {
            }
        });
        ScrollBar verticalBar = this.m_canvas.getVerticalBar();
        if (verticalBar != null) {
            verticalBar.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    CustomTooltipManager.this.hideTooltip();
                }
            });
        }
        this.m_canvas.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                CustomTooltipManager.this.hideTooltip();
            }
        });
    }

    @Override
    public void hideTooltip() {
        if (this.m_tooltipShell != null && !this.m_tooltipShell.isDisposed()) {
            this.m_tooltipShell.close();
            this.m_tooltipShell.dispose();
        }
        this.m_tooltipShell = null;
        this.m_tooltipFigure = null;
    }

    @Override
    public Listener getHideListener() {
        return this.m_hideListener;
    }

    protected final void handleShowCustomTooltip(int mouseX, int mouseY) {
        ICustomTooltipProvider tooltipProvider;
        this.hideTooltip();
        Figure cursorFigure = this.m_eventManager.getCursorFigure();
        if (cursorFigure != null && (tooltipProvider = cursorFigure.getCustomTooltipProvider()) != null) {
            this.m_tooltipFigure = cursorFigure;
            this.m_tooltipShell = new Shell(this.m_canvas.getShell(), 540676);
            GridLayoutFactory.create((Composite)this.m_tooltipShell).noMargins();
            this.m_tooltipShell.setForeground(Display.getCurrent().getSystemColor(28));
            this.m_tooltipShell.setBackground(Display.getCurrent().getSystemColor(29));
            Control tooltipControl = tooltipProvider.createTooltipControl((Composite)this.m_tooltipShell, this, cursorFigure);
            if (tooltipControl == null) {
                this.hideTooltip();
            } else {
                if (!EnvironmentUtils.IS_WINDOWS) {
                    this.m_tooltipShell.setSize(1000, 1000);
                }
                Point tooltipSize = this.m_tooltipShell.computeSize(-1, -1);
                Point tooltipLocation = this.m_canvas.toDisplay(mouseX - 5, mouseY + 10);
                Rectangle clientArea = Display.getCurrent().getClientArea();
                if (tooltipLocation.x + tooltipSize.x >= clientArea.width) {
                    tooltipLocation.x = clientArea.width - tooltipSize.x - 1;
                }
                if (tooltipLocation.y + tooltipSize.y >= clientArea.height) {
                    tooltipLocation.y = clientArea.height - tooltipSize.y - 1;
                }
                this.m_tooltipShell.setBounds(tooltipLocation.x, tooltipLocation.y, tooltipSize.x, tooltipSize.y);
                tooltipProvider.show(this.m_tooltipShell);
            }
        }
    }
}

