/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.gef.core.tools;

import org.eclipse.swt.events.KeyEvent;
import org.eclipse.wb.draw2d.geometry.Point;
import org.eclipse.wb.draw2d.geometry.Rectangle;
import org.eclipse.wb.gef.core.IEditPartViewer;
import org.eclipse.wb.gef.core.requests.AbstractCreateRequest;
import org.eclipse.wb.gef.core.requests.Request;
import org.eclipse.wb.gef.core.tools.TargetingTool;
import org.eclipse.wb.internal.gef.core.ISharedCursors;

public abstract class AbstractCreationTool
extends TargetingTool {
    public AbstractCreationTool() {
        this.setDefaultCursor(ISharedCursors.CURSOR_ADD);
        this.setDisabledCursor(ISharedCursors.CURSOR_NO);
    }

    @Override
    protected void handleButtonDown(int button) {
        if (button == 1) {
            if (this.m_state == 1) {
                this.m_state = 2;
                ((AbstractCreateRequest)this.getTargetRequest()).setLocation(this.getLocation());
                this.lockTargetEditPart(this.getTargetEditPart());
            }
        } else {
            this.m_state = 4;
            this.handleInvalidInput();
        }
    }

    @Override
    protected void handleButtonUp(int button) {
        if (this.m_state == 2 || this.m_state == 3) {
            this.eraseTargetFeedback();
            this.unlockTargetEditPart();
            this.executeCommand();
            this.selectAddedObjects();
        }
        this.m_state = 0;
        this.handleFinished();
    }

    @Override
    protected void handleMove() {
        this.updateTargetRequest();
        this.updateTargetUnderMouse();
        this.showTargetFeedback();
        this.updateCommand();
    }

    @Override
    protected void handleDragStarted() {
        if (this.m_state == 2) {
            this.m_state = 3;
        }
    }

    @Override
    protected void handleDragInProgress() {
        if (this.m_state == 3) {
            this.updateTargetRequest();
            this.showTargetFeedback();
            this.updateCommand();
        }
    }

    @Override
    protected abstract Request createTargetRequest();

    @Override
    protected void updateTargetRequest() {
        super.updateTargetRequest();
        AbstractCreateRequest request = (AbstractCreateRequest)this.getTargetRequest();
        if (this.m_state == 3) {
            Point start = this.getStartLocation();
            Rectangle bounds = new Rectangle(start, this.getDragMoveDelta());
            request.setLocation(bounds.getLocation());
            request.setSize(bounds.getSize());
        } else {
            request.setSize(null);
            request.setLocation(this.getLocation());
        }
    }

    protected abstract void selectAddedObjects();

    @Override
    public void keyPressed(KeyEvent event, IEditPartViewer viewer) {
        if (event.keyCode == 27) {
            viewer.getEditDomain().loadDefaultTool();
        }
    }
}

