"use strict";
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Red Hat, Inc. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
Object.defineProperty(exports, "__esModule", { value: true });
exports.indexOf = exports.isMapContainsEmptyPair = exports.getParent = void 0;
const yaml_1 = require("yaml");
function getParent(doc, nodeToFind) {
    let parentNode;
    yaml_1.visit(doc, (_, node, path) => {
        if (node === nodeToFind) {
            parentNode = path[path.length - 1];
            return yaml_1.visit.BREAK;
        }
    });
    if (yaml_1.isDocument(parentNode)) {
        return undefined;
    }
    return parentNode;
}
exports.getParent = getParent;
function isMapContainsEmptyPair(map) {
    if (map.items.length > 1) {
        return false;
    }
    const pair = map.items[0];
    if (yaml_1.isScalar(pair.key) && yaml_1.isScalar(pair.value) && pair.key.value === '' && !pair.value.value) {
        return true;
    }
    return false;
}
exports.isMapContainsEmptyPair = isMapContainsEmptyPair;
function indexOf(seq, item) {
    for (const [i, obj] of seq.items.entries()) {
        if (item === obj) {
            return i;
        }
    }
    return undefined;
}
exports.indexOf = indexOf;
//# sourceMappingURL=astUtils.js.map