/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl.base;

import com.hazelcast.impl.DefaultProxyFactory;
import com.hazelcast.impl.Node;
import com.hazelcast.impl.ProxyFactory;
import com.hazelcast.impl.base.NodeInitializer;
import com.hazelcast.impl.concurrentmap.DefaultRecordFactory;
import com.hazelcast.impl.concurrentmap.RecordFactory;
import com.hazelcast.logging.ILogger;
import com.hazelcast.security.SecurityContext;
import java.io.InputStream;
import java.util.Properties;
import java.util.logging.Level;

public class DefaultNodeInitializer
implements NodeInitializer {
    protected ILogger logger;
    protected ILogger systemLogger;
    protected Node node;
    protected String version;
    protected String build;
    private int buildNumber;
    protected boolean simpleRecord = false;

    public void beforeInitialize(Node node) {
        this.node = node;
        this.systemLogger = node.getLogger("com.hazelcast.system");
        this.logger = node.getLogger("com.hazelcast.initializer");
        this.parseSystemProps();
        this.simpleRecord = node.groupProperties.CONCURRENT_MAP_SIMPLE_RECORD.getBoolean();
    }

    public void printNodeInfo(Node node) {
        this.systemLogger.log(Level.INFO, "Hazelcast Community Edition " + this.version + " (" + this.build + ") starting at " + node.getThisAddress());
        this.systemLogger.log(Level.INFO, "Copyright (C) 2008-2013 Hazelcast.com");
    }

    public void afterInitialize(Node node) {
    }

    protected void parseSystemProps() {
        this.version = System.getProperty("hazelcast.version", "unknown");
        this.build = System.getProperty("hazelcast.build", "unknown");
        if ("unknown".equals(this.version) || "unknown".equals(this.build)) {
            try {
                InputStream inRuntimeProperties = NodeInitializer.class.getClassLoader().getResourceAsStream("hazelcast-runtime.properties");
                if (inRuntimeProperties != null) {
                    Properties runtimeProperties = new Properties();
                    runtimeProperties.load(inRuntimeProperties);
                    inRuntimeProperties.close();
                    this.version = runtimeProperties.getProperty("hazelcast.version");
                    this.build = runtimeProperties.getProperty("hazelcast.build");
                }
            }
            catch (Exception ignored) {
                // empty catch block
            }
        }
        try {
            this.buildNumber = Integer.getInteger("hazelcast.build", -1);
            if (this.buildNumber == -1) {
                this.buildNumber = Integer.parseInt(this.build);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public RecordFactory getRecordFactory() {
        return new DefaultRecordFactory(this.simpleRecord);
    }

    public int getBuildNumber() {
        return this.buildNumber;
    }

    public String getVersion() {
        return this.version;
    }

    public String getBuild() {
        return this.build;
    }

    public ProxyFactory getProxyFactory() {
        return new DefaultProxyFactory(this.node.factory);
    }

    public SecurityContext getSecurityContext() {
        this.logger.log(Level.WARNING, "Security features are only available on Hazelcast Enterprise Edition!");
        return null;
    }

    public void destroy() {
        this.logger.log(Level.INFO, "Destroying node initializer.");
    }
}

