/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.core.math;

import java.util.Random;
import org.apache.commons.math.MathException;
import org.apache.commons.math.distribution.BinomialDistributionImpl;
import org.eclipse.stem.core.CorePlugin;

public class BinomialDistributionUtil {
    public static int MAX_N = 1000000000;
    protected Random rand = new Random();

    public BinomialDistributionUtil(long seed) {
        this.rand.setSeed(seed);
    }

    public void setSeed(long seed) {
        this.rand.setSeed(seed);
    }

    public int fastPickFromBinomialDist(double p, int n) {
        int result = 0;
        double rndVal = this.rand.nextDouble();
        boolean success = false;
        try {
            if (n < MAX_N) {
                BinomialDistributionImpl bdist = new BinomialDistributionImpl(n, p);
                result = bdist.inverseCumulativeProbability(rndVal);
                success = true;
            }
        }
        catch (MathException e) {
            CorePlugin.logInformation("BinomialDistributionUtil.fastPickFromBinomialDist() problem with BinomialDistributionImpl for n=" + n + ", p=" + p + "  " + e.getMessage(), e);
        }
        if (!success) {
            result = (int)Math.round((double)n * p);
        }
        return result;
    }
}

