/**
 * <copyright>
 * 
 * Copyright (c) 2014 itemis and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     itemis - Initial API and implementation
 * 
 * </copyright>
 */
package org.eclipse.sphinx.examples.workflows.lib;

import com.google.common.base.Objects;
import java.util.List;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.AdapterFactoryItemDelegator;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.mwe.core.WorkflowContext;
import org.eclipse.sphinx.emf.mwe.dynamic.IWorkflowSlots;
import org.eclipse.xtext.xbase.lib.InputOutput;

@SuppressWarnings("all")
public class ModelWorkflowExtensions {
  public static List<EObject> getModelSlot(final WorkflowContext ctx) throws OperationCanceledException {
    Object _get = ctx.get(IWorkflowSlots.MODEL_SLOT_NAME);
    final List<EObject> modelSlot = ((List<EObject>) _get);
    boolean _or = false;
    boolean _equals = Objects.equal(modelSlot, null);
    if (_equals) {
      _or = true;
    } else {
      boolean _isEmpty = modelSlot.isEmpty();
      _or = _isEmpty;
    }
    if (_or) {
      InputOutput.<String>println("Model slot is empty, nothing to do!");
      throw new OperationCanceledException();
    }
    return modelSlot;
  }
  
  public static String getLabel(final EObject modelObject) {
    final ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
    final AdapterFactoryItemDelegator delegator = new AdapterFactoryItemDelegator(adapterFactory);
    final String label = delegator.getText(modelObject);
    boolean _and = false;
    boolean _notEquals = (!Objects.equal(label, null));
    if (!_notEquals) {
      _and = false;
    } else {
      boolean _isEmpty = label.isEmpty();
      boolean _not = (!_isEmpty);
      _and = _not;
    }
    if (_and) {
      return label;
    } else {
      EClass _eClass = modelObject.eClass();
      String _name = _eClass.getName();
      return (_name + " <Unnamed>");
    }
  }
}
