/**
 * <copyright>
 *  
 * Copyright (c) 2014 itemis and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *  
 * Contributors: 
 *     itemis - Initial API and implementation
 *  
 * </copyright>
 */
package org.eclipse.sphinx.emf.ui.util;

import java.util.ArrayList;
import java.util.Iterator;

import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.provider.FeatureMapEntryWrapperItemProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;

public class BasicUnwrapHelper implements IUnwrapHelper {

	/*
	 * @see org.eclipse.sphinx.emf.ui.util.IUnwrapHelper#unwrapElement(java.lang.Object)
	 */
	@Override
	public Object unwrapElement(Object element) {
		if (element instanceof FeatureMapEntryWrapperItemProvider) {
			return element;
		}
		return AdapterFactoryEditingDomain.unwrap(element);
	}

	/*
	 * @see org.eclipse.sphinx.emf.ui.util.IUnwrapHelper#unwrapSelection(org.eclipse.jface.viewers.ISelection)
	 */
	@Override
	public ISelection unwrapSelection(ISelection selection) {
		if (selection instanceof StructuredSelection && !selection.isEmpty()) {
			StructuredSelection structuredSelection = (StructuredSelection) selection;
			ArrayList<Object> unwrappedSelection = new ArrayList<Object>(structuredSelection.size());
			for (Iterator<?> it = structuredSelection.iterator(); it.hasNext();) {
				Object unwrapped = unwrapElement(it.next());
				if (unwrapped != null) {
					unwrappedSelection.add(unwrapped);
				}
			}
			selection = new StructuredSelection(unwrappedSelection);
		}
		return selection;
	}
}
