/**
 * <copyright>
 *  
 * Copyright (c) 2014 itemis and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *  
 * Contributors: 
 *     itemis - Initial API and implementation
 *  
 * </copyright>
 */
package org.eclipse.sphinx.emf.ui.properties.actions;

import java.util.Iterator;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.sphinx.emf.ui.internal.Activator;
import org.eclipse.sphinx.emf.ui.internal.messages.Messages;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.actions.BaseSelectionListenerAction;
import org.eclipse.ui.views.properties.IPropertySheetEntry;

public class BasicResetValueAction extends BaseSelectionListenerAction {

	protected Composite viewerComposite;

	public BasicResetValueAction(Viewer viewer) {
		super(Messages.action_resetValue_label);
		setToolTipText(Messages.action_resetValue_toolTip);
		setImageDescriptor(Activator.getPlugin().getImageDescriptor("full/elcl16/resval_ps")); //$NON-NLS-1$
		setDisabledImageDescriptor(Activator.getPlugin().getImageDescriptor("full/dlcl16/resval_ps")); //$NON-NLS-1$

		Assert.isNotNull(viewer);
		Control control = viewer.getControl();
		viewerComposite = control instanceof Composite ? (Composite) control : null;
	}

	@Override
	protected boolean updateSelection(IStructuredSelection selection) {
		if (viewerComposite == null || selection == null || selection.isEmpty()) {
			return false;
		}

		for (Iterator<?> it = selection.iterator(); it.hasNext();) {
			Object next = it.next();
			if (next instanceof IPropertySheetEntry) {
				IPropertySheetEntry entry = (IPropertySheetEntry) next;
				if (entry.getEditor(viewerComposite) == null) {
					return false;
				}
			}
		}

		return true;
	}

	@Override
	public void run() {
		// TODO Auto-generated method stub
		super.run();
	}
}
