/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.workspace.loading;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.MultiRule;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.RunnableWithResult;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sphinx.emf.internal.ecore.proxymanagement.ProxyHelper;
import org.eclipse.sphinx.emf.internal.ecore.proxymanagement.ProxyHelperAdapterFactory;
import org.eclipse.sphinx.emf.internal.ecore.proxymanagement.blacklist.ModelIndex;
import org.eclipse.sphinx.emf.internal.ecore.proxymanagement.lookupresolver.EcoreIndex;
import org.eclipse.sphinx.emf.internal.resource.ResourceProblemMarkerService;
import org.eclipse.sphinx.emf.metamodel.IMetaModelDescriptor;
import org.eclipse.sphinx.emf.metamodel.MetaModelDescriptorRegistry;
import org.eclipse.sphinx.emf.model.IModelDescriptor;
import org.eclipse.sphinx.emf.model.ModelDescriptorRegistry;
import org.eclipse.sphinx.emf.scoping.IResourceScope;
import org.eclipse.sphinx.emf.scoping.IResourceScopeProvider;
import org.eclipse.sphinx.emf.scoping.ProjectResourceScope;
import org.eclipse.sphinx.emf.scoping.ResourceScopeProviderRegistry;
import org.eclipse.sphinx.emf.util.EObjectUtil;
import org.eclipse.sphinx.emf.util.EcorePlatformUtil;
import org.eclipse.sphinx.emf.util.WorkspaceEditingDomainUtil;
import org.eclipse.sphinx.emf.util.WorkspaceTransactionUtil;
import org.eclipse.sphinx.emf.workspace.Activator;
import org.eclipse.sphinx.emf.workspace.internal.loading.FileLoadJob;
import org.eclipse.sphinx.emf.workspace.internal.loading.LoadJob;
import org.eclipse.sphinx.emf.workspace.internal.loading.ModelLoadJob;
import org.eclipse.sphinx.emf.workspace.internal.loading.ModelLoadingPerformanceStats;
import org.eclipse.sphinx.emf.workspace.internal.messages.Messages;
import org.eclipse.sphinx.platform.IExtendedPlatformConstants;
import org.eclipse.sphinx.platform.util.ExtendedPlatform;
import org.eclipse.sphinx.platform.util.PlatformLogUtil;
import org.eclipse.sphinx.platform.util.StatusUtil;

public final class ModelLoadManager {
    public static final ModelLoadManager INSTANCE = new ModelLoadManager();

    private ModelLoadManager() {
    }

    private Map<TransactionalEditingDomain, Collection<IFile>> detectFilesToLoad(Collection<IFile> files, IMetaModelDescriptor mmFilter, boolean ignoreIfAlreadyLoaded, IProgressMonitor monitor) throws OperationCanceledException {
        Assert.isNotNull(files);
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)files.size());
        if (progress.isCanceled()) {
            throw new OperationCanceledException();
        }
        HashMap<TransactionalEditingDomain, Collection<IFile>> filesToLoad = new HashMap<TransactionalEditingDomain, Collection<IFile>>();
        for (IFile file : files) {
            try {
                if (file.isAccessible() && !ResourceScopeProviderRegistry.INSTANCE.isNotInAnyScope(file)) {
                    TransactionalEditingDomain editingDomain;
                    IResourceScope resourceScope;
                    IResourceScopeProvider resourceScopeProvider;
                    progress.subTask(NLS.bind((String)Messages.subtask_analyzingFile, (Object)file.getFullPath()));
                    IMetaModelDescriptor effectiveMMDescriptor = MetaModelDescriptorRegistry.INSTANCE.getEffectiveDescriptor(file);
                    if (!(mmFilter != null && !mmFilter.getClass().isInstance(effectiveMMDescriptor) || ignoreIfAlreadyLoaded && EcorePlatformUtil.isFileLoaded((IFile)file) || (resourceScopeProvider = ResourceScopeProviderRegistry.INSTANCE.getResourceScopeProvider(effectiveMMDescriptor)) == null || (resourceScope = resourceScopeProvider.getScope((IResource)file)) == null || (editingDomain = WorkspaceEditingDomainUtil.getMappedEditingDomain((IFile)file)) == null)) {
                        HashSet<IFile> filesToLoadInEditingDomain = (HashSet<IFile>)filesToLoad.get(editingDomain);
                        if (filesToLoadInEditingDomain == null) {
                            filesToLoadInEditingDomain = new HashSet<IFile>();
                            filesToLoad.put(editingDomain, filesToLoadInEditingDomain);
                        }
                        filesToLoadInEditingDomain.add(file);
                    }
                }
            }
            catch (Exception ex) {
                PlatformLogUtil.logAsWarning((Plugin)Activator.getPlugin(), (Object)ex);
            }
            progress.worked(1);
            if (!progress.isCanceled()) continue;
            throw new OperationCanceledException();
        }
        return filesToLoad;
    }

    private Map<TransactionalEditingDomain, Map<IFile, IPath>> detectFilesToUpdateResourceURIFor(Map<IFile, IPath> files, IProgressMonitor monitor) {
        Assert.isNotNull(files);
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)files.size());
        if (progress.isCanceled()) {
            throw new OperationCanceledException();
        }
        HashMap<TransactionalEditingDomain, Map<IFile, IPath>> filesToUpdateResourceURIFor = new HashMap<TransactionalEditingDomain, Map<IFile, IPath>>();
        for (IFile oldFile : files.keySet()) {
            try {
                if (!ResourceScopeProviderRegistry.INSTANCE.isNotInAnyScope(oldFile)) {
                    progress.subTask(NLS.bind((String)Messages.subtask_analyzingFile, (Object)oldFile.getFullPath()));
                    TransactionalEditingDomain editingDomain = WorkspaceEditingDomainUtil.getCurrentEditingDomain((IFile)oldFile);
                    if (editingDomain != null) {
                        HashMap<IFile, IPath> filesToUpdateResourceURIForInEditingDomain = (HashMap<IFile, IPath>)filesToUpdateResourceURIFor.get(editingDomain);
                        if (filesToUpdateResourceURIForInEditingDomain == null) {
                            filesToUpdateResourceURIForInEditingDomain = new HashMap<IFile, IPath>();
                            filesToUpdateResourceURIFor.put(editingDomain, filesToUpdateResourceURIForInEditingDomain);
                        }
                        filesToUpdateResourceURIForInEditingDomain.put(oldFile, files.get(oldFile));
                    }
                }
            }
            catch (Exception ex) {
                PlatformLogUtil.logAsWarning((Plugin)Activator.getPlugin(), (Object)ex);
            }
            progress.worked(1);
            if (!progress.isCanceled()) continue;
            throw new OperationCanceledException();
        }
        return filesToUpdateResourceURIFor;
    }

    private Map<TransactionalEditingDomain, Collection<IFile>> detectFilesToUnload(Collection<IFile> files, IMetaModelDescriptor mmFilter, IProgressMonitor monitor) throws OperationCanceledException {
        Assert.isNotNull(files);
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)files.size());
        if (progress.isCanceled()) {
            throw new OperationCanceledException();
        }
        HashMap<TransactionalEditingDomain, Collection<IFile>> filesToUnload = new HashMap<TransactionalEditingDomain, Collection<IFile>>();
        for (IFile file : files) {
            try {
                if (ResourceScopeProviderRegistry.INSTANCE.hasApplicableFileExtension(file)) {
                    progress.subTask(NLS.bind((String)Messages.subtask_analyzingFile, (Object)file.getFullPath()));
                    IMetaModelDescriptor effectiveMMDescriptor = MetaModelDescriptorRegistry.INSTANCE.getEffectiveDescriptor(file);
                    if (mmFilter == null || mmFilter.getClass().isInstance(effectiveMMDescriptor)) {
                        for (TransactionalEditingDomain editingDomain : WorkspaceEditingDomainUtil.getAllEditingDomains()) {
                            if (!EcorePlatformUtil.isFileLoaded((TransactionalEditingDomain)editingDomain, (IFile)file)) continue;
                            HashSet<IFile> filesToUnloadInEditingDomain = (HashSet<IFile>)filesToUnload.get(editingDomain);
                            if (filesToUnloadInEditingDomain == null) {
                                filesToUnloadInEditingDomain = new HashSet<IFile>();
                                filesToUnload.put(editingDomain, filesToUnloadInEditingDomain);
                            }
                            filesToUnloadInEditingDomain.add(file);
                        }
                    }
                }
            }
            catch (Exception ex) {
                PlatformLogUtil.logAsWarning((Plugin)Activator.getPlugin(), (Object)ex);
            }
            progress.worked(1);
            if (!progress.isCanceled()) continue;
            throw new OperationCanceledException();
        }
        return filesToUnload;
    }

    private Map<TransactionalEditingDomain, Collection<Resource>> detectResourcesToUnload(final IProject project, final boolean includeReferencedScopes, final IMetaModelDescriptor mmFilter, IProgressMonitor monitor) throws OperationCanceledException {
        Assert.isNotNull((Object)project);
        Collection editingDomains = WorkspaceEditingDomainUtil.getAllEditingDomains();
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)editingDomains.size());
        if (progress.isCanceled()) {
            throw new OperationCanceledException();
        }
        HashMap<TransactionalEditingDomain, Collection<Resource>> resourcesToUnload = new HashMap<TransactionalEditingDomain, Collection<Resource>>();
        for (final TransactionalEditingDomain editingDomain : editingDomains) {
            try {
                List resourcesToUnloadInEditingDomain = (List)TransactionUtil.runExclusive((TransactionalEditingDomain)editingDomain, (RunnableWithResult)new RunnableWithResult.Impl<List<Resource>>(){

                    public void run() {
                        ArrayList<Resource> resources = new ArrayList<Resource>();
                        ProjectResourceScope projectResourceScope = new ProjectResourceScope((IResource)project);
                        for (Resource resource : editingDomain.getResourceSet().getResources()) {
                            if (!projectResourceScope.belongsTo(resource, includeReferencedScopes)) continue;
                            if (mmFilter != null) {
                                IMetaModelDescriptor mmDescriptor = MetaModelDescriptorRegistry.INSTANCE.getDescriptor(resource);
                                if (mmDescriptor == null) {
                                    mmDescriptor = MetaModelDescriptorRegistry.INSTANCE.getOldDescriptor(resource);
                                }
                                if (!mmFilter.equals(mmDescriptor)) continue;
                                resources.add(resource);
                                continue;
                            }
                            resources.add(resource);
                        }
                        this.setResult(resources);
                    }
                });
                if (resourcesToUnloadInEditingDomain.size() > 0) {
                    resourcesToUnload.put(editingDomain, resourcesToUnloadInEditingDomain);
                }
            }
            catch (Exception ex) {
                PlatformLogUtil.logAsError((Plugin)Activator.getPlugin(), (Object)ex);
            }
            progress.worked(1);
            if (!progress.isCanceled()) continue;
            throw new OperationCanceledException();
        }
        return resourcesToUnload;
    }

    private int getFilesToLoadCount(Map<TransactionalEditingDomain, Collection<IFile>> filesToLoad) {
        Assert.isNotNull(filesToLoad);
        int count = 0;
        for (TransactionalEditingDomain editingDomain : filesToLoad.keySet()) {
            Collection<IFile> filesToLoadInEditingDomain = filesToLoad.get(editingDomain);
            count += filesToLoadInEditingDomain.size();
        }
        return count;
    }

    private int getFilesToUnloadCount(Map<TransactionalEditingDomain, Collection<IFile>> filesToUnload) {
        Assert.isNotNull(filesToUnload);
        int count = 0;
        for (TransactionalEditingDomain editingDomain : filesToUnload.keySet()) {
            count += filesToUnload.get(editingDomain).size();
        }
        return count;
    }

    private int getResourcesToUnloadCount(Map<TransactionalEditingDomain, Collection<Resource>> resourcesToUnload) {
        Assert.isNotNull(resourcesToUnload);
        int count = 0;
        for (TransactionalEditingDomain editingDomain : resourcesToUnload.keySet()) {
            count += resourcesToUnload.get(editingDomain).size();
        }
        return count;
    }

    private ISchedulingRule createLoadSchedulingRule(Collection<IProject> projects, boolean includeReferencedProjects) {
        Assert.isNotNull(projects);
        if (projects.size() < 500) {
            HashSet<IProject> rules = new HashSet<IProject>();
            for (IProject project : projects) {
                if (!includeReferencedProjects) {
                    rules.add(project);
                    continue;
                }
                rules.addAll(ExtendedPlatform.getProjectGroup((IProject)project, (boolean)false));
            }
            return MultiRule.combine((ISchedulingRule[])rules.toArray(new ISchedulingRule[rules.size()]));
        }
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    private ISchedulingRule createLoadSchedulingRule(Collection<IFile> files) {
        if (files.size() < 500) {
            Assert.isNotNull(files);
            HashSet<ISchedulingRule> rules1 = new HashSet<ISchedulingRule>();
            for (IFile file : files) {
                ISchedulingRule rule = this.createLoadSchedulingRule(file);
                if (rule == null) continue;
                rules1.add(rule);
            }
            HashSet<ISchedulingRule> rules = rules1;
            return MultiRule.combine((ISchedulingRule[])rules.toArray(new ISchedulingRule[rules.size()]));
        }
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    private ISchedulingRule createLoadSchedulingRule(IFile file) {
        Assert.isNotNull((Object)file);
        return file.getParent();
    }

    private ISchedulingRule createLoadSchedulingRule(Map<TransactionalEditingDomain, Collection<Resource>> resources) {
        Assert.isNotNull(resources);
        HashSet<Resource> allResources = new HashSet<Resource>();
        for (Collection<Resource> resourcesInEditingDomain : resources.values()) {
            allResources.addAll(resourcesInEditingDomain);
        }
        if (allResources.size() < 500) {
            HashSet<ISchedulingRule> rules = new HashSet<ISchedulingRule>();
            for (Resource resource : allResources) {
                IFile file = EcorePlatformUtil.getFile((Resource)resource);
                if (file == null) continue;
                rules.add(this.createLoadSchedulingRule(file));
            }
            return MultiRule.combine((ISchedulingRule[])rules.toArray(new ISchedulingRule[rules.size()]));
        }
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    public void loadWorkspace(boolean async, IProgressMonitor monitor) {
        this.loadAllProjects(null, async, monitor);
    }

    public void loadAllProjects(IMetaModelDescriptor mmDescriptor, boolean async, IProgressMonitor monitor) {
        Collection projects = ExtendedPlatform.getRootProjects();
        if (projects.size() == 0) {
            return;
        }
        this.loadProjects(projects, true, mmDescriptor, async, monitor);
    }

    public void loadProject(IProject project, boolean includeReferencedProjects, boolean async, IProgressMonitor monitor) {
        this.loadProjects(Collections.singleton(project), includeReferencedProjects, null, async, monitor);
    }

    public void loadProject(IProject project, boolean includeReferencedProjects, IMetaModelDescriptor mmDescriptor, boolean async, IProgressMonitor monitor) {
        this.loadProjects(Collections.singleton(project), includeReferencedProjects, mmDescriptor, async, monitor);
    }

    public void loadProjects(Collection<IProject> projects, boolean includeReferencedProjects, boolean async, IProgressMonitor monitor) {
        this.loadProjects(projects, includeReferencedProjects, null, async, monitor);
    }

    public void loadProjects(final Collection<IProject> projects, final boolean includeReferencedProjects, final IMetaModelDescriptor mmDescriptor, boolean async, IProgressMonitor monitor) {
        Assert.isNotNull(projects);
        if (async && projects.size() > 0) {
            if (!LoadJob.shouldCreateJob(projects, includeReferencedProjects, mmDescriptor)) {
                return;
            }
            ModelLoadJob job = new ModelLoadJob(projects, includeReferencedProjects, mmDescriptor){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        ModelLoadManager.this.runLoadProjects(projects, includeReferencedProjects, mmDescriptor, monitor);
                        return Status.OK_STATUS;
                    }
                    catch (OperationCanceledException operationCanceledException) {
                        return Status.CANCEL_STATUS;
                    }
                    catch (Exception ex) {
                        return StatusUtil.createErrorStatus((Plugin)Activator.getPlugin(), (Object)ex);
                    }
                }

                public boolean belongsTo(Object family) {
                    return IExtendedPlatformConstants.FAMILY_MODEL_LOADING.equals(family) || IExtendedPlatformConstants.FAMILY_LONG_RUNNING.equals(family);
                }
            };
            job.setPriority(40);
            job.setRule(this.createLoadSchedulingRule(projects, includeReferencedProjects));
            job.schedule();
        } else {
            try {
                this.runLoadProjects(projects, includeReferencedProjects, mmDescriptor, monitor);
            }
            catch (OperationCanceledException operationCanceledException) {}
        }
    }

    private void runLoadProjects(Collection<IProject> projects, boolean includeReferencedProjects, IMetaModelDescriptor mmDescriptor, IProgressMonitor monitor) throws OperationCanceledException {
        Assert.isNotNull(projects);
        for (IProject project : projects) {
            String taskName = mmDescriptor != null ? NLS.bind((String)Messages.task_loadingModelInProject, (Object)mmDescriptor.getName(), (Object)project.getName()) : NLS.bind((String)Messages.task_loadingModelsInProject, (Object)project.getName());
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)taskName, (int)100);
            if (progress.isCanceled()) {
                throw new OperationCanceledException();
            }
            Collection files = ExtendedPlatform.getAllFiles((IProject)project, (boolean)includeReferencedProjects);
            progress.worked(1);
            if (files.size() == 0) {
                progress.done();
                continue;
            }
            String context = String.valueOf(ModelLoadingPerformanceStats.ModelContext.CONTEXT_LOAD_PROJECT.getName()) + " " + project.getName();
            ModelLoadingPerformanceStats.INSTANCE.openContext(context);
            this.runDetectAndLoadModelFiles(files, mmDescriptor, (IProgressMonitor)progress.newChild(99));
            ModelLoadingPerformanceStats.INSTANCE.closeAndLogCurrentContext();
        }
    }

    public void loadFile(IFile file, boolean async, IProgressMonitor monitor) {
        this.loadFiles(Collections.singleton(file), null, async, monitor);
    }

    public void loadFile(IFile file, IMetaModelDescriptor mmDescriptor, boolean async, IProgressMonitor monitor) {
        this.loadFiles(Collections.singleton(file), mmDescriptor, async, monitor);
    }

    public void loadFiles(Collection<IFile> files, boolean async, IProgressMonitor monitor) {
        this.loadFiles(files, null, async, monitor);
    }

    public void loadFiles(final Collection<IFile> files, final IMetaModelDescriptor mmDescriptor, boolean async, IProgressMonitor monitor) {
        Assert.isNotNull(files);
        if (async && files.size() > 0) {
            if (!LoadJob.shouldCreateJob(files, mmDescriptor)) {
                return;
            }
            FileLoadJob job = new FileLoadJob(files, mmDescriptor){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        ModelLoadManager.this.runDetectAndLoadModelFiles(files, mmDescriptor, monitor);
                        return Status.OK_STATUS;
                    }
                    catch (OperationCanceledException operationCanceledException) {
                        return Status.CANCEL_STATUS;
                    }
                    catch (Exception ex) {
                        return StatusUtil.createErrorStatus((Plugin)Activator.getPlugin(), (Object)ex);
                    }
                }

                public boolean belongsTo(Object family) {
                    return IExtendedPlatformConstants.FAMILY_MODEL_LOADING.equals(family) || IExtendedPlatformConstants.FAMILY_LONG_RUNNING.equals(family);
                }
            };
            job.setPriority(40);
            job.setRule(this.createLoadSchedulingRule(files));
            job.schedule();
        } else {
            try {
                this.runDetectAndLoadModelFiles(files, mmDescriptor, monitor);
            }
            catch (OperationCanceledException operationCanceledException) {}
        }
    }

    private void runDetectAndLoadModelFiles(Collection<IFile> files, IMetaModelDescriptor mmDescriptor, IProgressMonitor monitor) throws OperationCanceledException {
        Assert.isNotNull(files);
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.task_loadingModelFiles, (int)100);
        if (progress.isCanceled()) {
            throw new OperationCanceledException();
        }
        String contextLoadFiles = ModelLoadingPerformanceStats.ModelContext.CONTEXT_LOAD_FILES.getName();
        ModelLoadingPerformanceStats.INSTANCE.openContextIfFirstOne(contextLoadFiles);
        ModelLoadingPerformanceStats.ModelEvent eventDetectFilesToLoad = ModelLoadingPerformanceStats.ModelEvent.EVENT_DETECT_FILES_TO_LOAD;
        ModelLoadingPerformanceStats.INSTANCE.startNewEvent(eventDetectFilesToLoad, files);
        Map<TransactionalEditingDomain, Collection<IFile>> filesToLoad = this.detectFilesToLoad(files, mmDescriptor, true, (IProgressMonitor)progress.newChild(10));
        ModelLoadingPerformanceStats.INSTANCE.endEvent(eventDetectFilesToLoad, files);
        if (filesToLoad.size() == 0) {
            ModelLoadingPerformanceStats.INSTANCE.closeAndLogCurrentContext();
            progress.done();
            return;
        }
        ModelLoadingPerformanceStats.INSTANCE.closeContext(contextLoadFiles);
        this.runLoadModelFiles(filesToLoad, (IProgressMonitor)progress.newChild(90));
    }

    private void runLoadModelFiles(Map<TransactionalEditingDomain, Collection<IFile>> filesToLoad, IProgressMonitor monitor) throws OperationCanceledException {
        Assert.isNotNull(filesToLoad);
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)filesToLoad.keySet().size());
        if (progress.isCanceled()) {
            throw new OperationCanceledException();
        }
        String contextLoadFiles = ModelLoadingPerformanceStats.ModelContext.CONTEXT_LOAD_FILES.getName();
        boolean openedContext = ModelLoadingPerformanceStats.INSTANCE.openContextIfFirstOne(contextLoadFiles);
        for (TransactionalEditingDomain editingDomain : filesToLoad.keySet()) {
            this.loadModelFilesInEditingDomain(editingDomain, filesToLoad.get(editingDomain), (IProgressMonitor)progress.newChild(1));
        }
        ExtendedPlatform.performGarbageCollection();
        if (openedContext) {
            ModelLoadingPerformanceStats.INSTANCE.closeAndLogCurrentContext();
        }
    }

    private void loadModelFilesInEditingDomain(final TransactionalEditingDomain editingDomain, final Collection<IFile> filesToLoadInEditingDomain, final IProgressMonitor monitor) throws OperationCanceledException {
        Assert.isNotNull((Object)editingDomain);
        Assert.isNotNull(filesToLoadInEditingDomain);
        try {
            editingDomain.runExclusive(new Runnable(){

                @Override
                public void run() {
                    SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                    if (progress.isCanceled()) {
                        throw new OperationCanceledException();
                    }
                    ProxyHelper proxyHelper = ProxyHelperAdapterFactory.INSTANCE.adapt((Notifier)editingDomain.getResourceSet());
                    if (proxyHelper != null) {
                        proxyHelper.setIgnoreFragmentBasedProxies(true);
                    }
                    SubMonitor loadProgress = progress.newChild(80).setWorkRemaining(filesToLoadInEditingDomain.size());
                    HashSet<IFile> loadedFiles = new HashSet<IFile>();
                    for (IFile file : filesToLoadInEditingDomain) {
                        loadProgress.subTask(NLS.bind((String)Messages.subtask_loadingFile, (Object)file.getFullPath().toString()));
                        try {
                            ModelLoadingPerformanceStats.INSTANCE.startNewEvent(ModelLoadingPerformanceStats.ModelEvent.EVENT_LOAD_FILE, file.getFullPath().toString());
                            try {
                                Map<String, SubMonitor> loadOptions = Collections.singletonMap("PROGRESS_MONITOR", loadProgress.newChild(1));
                                EcorePlatformUtil.loadResource((TransactionalEditingDomain)editingDomain, (IFile)file, loadOptions);
                                loadedFiles.add(file);
                            }
                            catch (Exception exception) {}
                            ModelLoadingPerformanceStats.INSTANCE.endEvent(ModelLoadingPerformanceStats.ModelEvent.EVENT_LOAD_FILE, file.getFullPath().toString());
                        }
                        catch (Exception ex) {
                            PlatformLogUtil.logAsError((Plugin)Activator.getPlugin(), (Object)ex);
                        }
                        if (loadProgress.isCanceled()) {
                            throw new OperationCanceledException();
                        }
                        editingDomain.yield();
                    }
                    if (proxyHelper != null) {
                        ModelLoadManager.this.updateUnresolvedProxyBlackList(loadedFiles, proxyHelper.getBlackList());
                        ModelLoadManager.this.forceProxyResolution(loadedFiles, proxyHelper.getLookupResolver(), (IProgressMonitor)progress.newChild(10));
                        proxyHelper.setIgnoreFragmentBasedProxies(false);
                    }
                }
            });
        }
        catch (InterruptedException ex) {
            PlatformLogUtil.logAsWarning((Plugin)Activator.getDefault(), (Object)ex);
        }
    }

    private void updateUnresolvedProxyBlackList(Collection<IFile> files, ModelIndex blackList) {
        Assert.isNotNull(files);
        Assert.isNotNull((Object)blackList);
        for (IFile file : files) {
            Resource resource = EcorePlatformUtil.getResource((IFile)file);
            blackList.updateIndexOnResourceLoaded(resource);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void forceProxyResolution(Collection<IFile> files, EcoreIndex lookupResolver, IProgressMonitor monitor) {
        Assert.isNotNull(files);
        Assert.isNotNull((Object)lookupResolver);
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        if (progress.isCanceled()) {
            throw new OperationCanceledException();
        }
        ModelLoadingPerformanceStats.INSTANCE.startNewEvent(ModelLoadingPerformanceStats.ModelEvent.EVENT_RESOLVE_PROXY, files);
        progress.subTask(Messages.subtask_initializingProxyResolution);
        HashSet resources = new HashSet();
        for (IFile file : files) {
            Resource resource = EcorePlatformUtil.getResource((IFile)file);
            if (resource == null || resources.contains(resource)) continue;
            resources.addAll(EcorePlatformUtil.getResourcesInModel((Resource)resource, (boolean)true));
        }
        EcoreIndex ecoreIndex = lookupResolver;
        synchronized (ecoreIndex) {
            lookupResolver.init(resources);
            progress.worked(10);
            SubMonitor resolveProxiesProgress = progress.newChild(80).setWorkRemaining(files.size());
            for (Resource resource : resources) {
                resolveProxiesProgress.subTask(NLS.bind((String)Messages.subtask_resolvingProxiesInResource, (Object)resource.getURI()));
                EObjectUtil.resolveAll((Resource)resource);
                resolveProxiesProgress.worked(1);
                if (!resolveProxiesProgress.isCanceled()) continue;
                throw new OperationCanceledException();
            }
            lookupResolver.clear();
        }
        ResourceProblemMarkerService.INSTANCE.updateProblemMarkers(resources, (IProgressMonitor)progress.newChild(10));
        ExtendedPlatform.performGarbageCollection();
        ModelLoadingPerformanceStats.INSTANCE.endEvent(ModelLoadingPerformanceStats.ModelEvent.EVENT_RESOLVE_PROXY, files);
    }

    public void unloadProject(IProject project, boolean includeReferencedProjects, boolean async, IProgressMonitor monitor) {
        this.unloadProjects(Collections.singleton(project), includeReferencedProjects, null, async, monitor);
    }

    public void unloadProject(IProject project, boolean includeReferencedProjects, IMetaModelDescriptor mmDescriptor, boolean async, IProgressMonitor monitor) {
        this.unloadProjects(Collections.singleton(project), includeReferencedProjects, mmDescriptor, async, monitor);
    }

    public void unloadProjects(Collection<IProject> projects, boolean includeReferencedProjects, boolean async, IProgressMonitor monitor) {
        this.unloadProjects(projects, includeReferencedProjects, null, async, monitor);
    }

    public void unloadAllProjects(IMetaModelDescriptor mmDescriptor, boolean async, IProgressMonitor monitor) {
        Collection projects = ExtendedPlatform.getRootProjects();
        if (projects.size() == 0) {
            return;
        }
        this.unloadProjects(projects, true, mmDescriptor, async, monitor);
    }

    public void unloadWorkspace(boolean async, IProgressMonitor monitor) {
        this.unloadAllProjects(null, async, monitor);
    }

    public void unloadProjects(Collection<IProject> projects, boolean includeReferencedProjects, IMetaModelDescriptor mmDescriptor, boolean async, IProgressMonitor monitor) {
        Assert.isNotNull(projects);
        try {
            for (IProject project : projects) {
                String taskName = mmDescriptor != null ? NLS.bind((String)Messages.task_unloadingModelInProject, (Object)mmDescriptor.getName(), (Object)project.getName()) : NLS.bind((String)Messages.task_unloadingModelsInProject, (Object)project.getName());
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)taskName, (int)100);
                if (progress.isCanceled()) {
                    throw new OperationCanceledException();
                }
                Map<TransactionalEditingDomain, Collection<Resource>> resourcesToUnload = this.detectResourcesToUnload(project, includeReferencedProjects, mmDescriptor, (IProgressMonitor)progress.newChild(1));
                if (resourcesToUnload.size() == 0) {
                    progress.done();
                    continue;
                }
                this.internalUnloadResources(resourcesToUnload, ExtendedPlatform.isRootProject((IProject)project), async, (IProgressMonitor)progress.newChild(99));
            }
        }
        catch (OperationCanceledException operationCanceledException) {}
    }

    private void internalUnloadResources(final Map<TransactionalEditingDomain, Collection<Resource>> resourcesToUnload, final boolean memoryOptimized, boolean async, IProgressMonitor monitor) throws OperationCanceledException {
        Assert.isNotNull(resourcesToUnload);
        if (async && resourcesToUnload.size() > 0) {
            Job job = new Job(Messages.job_unloadingModelResources){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        ModelLoadManager.this.runUnloadModelResources(resourcesToUnload, memoryOptimized, monitor);
                        return Status.OK_STATUS;
                    }
                    catch (OperationCanceledException operationCanceledException) {
                        return Status.CANCEL_STATUS;
                    }
                    catch (Exception ex) {
                        return StatusUtil.createErrorStatus((Plugin)Activator.getPlugin(), (Object)ex);
                    }
                }

                public boolean belongsTo(Object family) {
                    return IExtendedPlatformConstants.FAMILY_MODEL_LOADING.equals(family) || IExtendedPlatformConstants.FAMILY_LONG_RUNNING.equals(family);
                }
            };
            job.setPriority(40);
            job.setRule(this.createLoadSchedulingRule(resourcesToUnload));
            job.schedule();
        } else {
            this.runUnloadModelResources(resourcesToUnload, memoryOptimized, monitor);
        }
    }

    private void runUnloadModelResources(Map<TransactionalEditingDomain, Collection<Resource>> resourcesToUnload, boolean memoryOptimized, IProgressMonitor monitor) throws OperationCanceledException {
        Assert.isNotNull(resourcesToUnload);
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)this.getResourcesToUnloadCount(resourcesToUnload));
        if (progress.isCanceled()) {
            throw new OperationCanceledException();
        }
        for (TransactionalEditingDomain editingDomain : resourcesToUnload.keySet()) {
            Collection<Resource> resourcesToUnloadInEditingDomain = resourcesToUnload.get(editingDomain);
            EcorePlatformUtil.unloadResources((TransactionalEditingDomain)editingDomain, resourcesToUnloadInEditingDomain, (boolean)memoryOptimized, (IProgressMonitor)progress.newChild(resourcesToUnloadInEditingDomain.size()));
            if (!progress.isCanceled()) continue;
            throw new OperationCanceledException();
        }
        ExtendedPlatform.performGarbageCollection();
    }

    public void unloadFile(IFile file, boolean async, IProgressMonitor monitor) {
        this.unloadFiles(Collections.singleton(file), null, false, async, monitor);
    }

    public void unloadFile(IFile file, IMetaModelDescriptor mmDescriptor, boolean async, IProgressMonitor monitor) {
        this.unloadFiles(Collections.singleton(file), mmDescriptor, false, async, monitor);
    }

    public void unloadFiles(Collection<IFile> files, boolean memoryOptimized, boolean async, IProgressMonitor monitor) {
        this.unloadFiles(files, null, memoryOptimized, async, monitor);
    }

    public void unloadFiles(final Collection<IFile> files, final IMetaModelDescriptor mmDescriptor, final boolean memoryOptimized, boolean async, IProgressMonitor monitor) {
        Assert.isNotNull(files);
        if (async && files.size() > 0) {
            Job job = new Job(Messages.job_unloadingModelResources){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        ModelLoadManager.this.runDetectAndUnloadModelFiles(files, mmDescriptor, memoryOptimized, monitor);
                        return Status.OK_STATUS;
                    }
                    catch (OperationCanceledException operationCanceledException) {
                        return Status.CANCEL_STATUS;
                    }
                    catch (Exception ex) {
                        return StatusUtil.createErrorStatus((Plugin)Activator.getPlugin(), (Object)ex);
                    }
                }

                public boolean belongsTo(Object family) {
                    return IExtendedPlatformConstants.FAMILY_MODEL_LOADING.equals(family) || IExtendedPlatformConstants.FAMILY_LONG_RUNNING.equals(family);
                }
            };
            job.setPriority(40);
            job.setRule(this.createLoadSchedulingRule(files));
            job.schedule();
        } else {
            try {
                this.runDetectAndUnloadModelFiles(files, mmDescriptor, memoryOptimized, monitor);
            }
            catch (OperationCanceledException operationCanceledException) {}
        }
    }

    private void runDetectAndUnloadModelFiles(Collection<IFile> files, IMetaModelDescriptor mmDescriptor, boolean memoryOptimized, IProgressMonitor monitor) throws OperationCanceledException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.task_unloadingModelFiles, (int)100);
        if (progress.isCanceled()) {
            throw new OperationCanceledException();
        }
        Map<TransactionalEditingDomain, Collection<IFile>> filesToUnload = this.detectFilesToUnload(files, mmDescriptor, (IProgressMonitor)progress.newChild(10));
        if (filesToUnload.size() == 0) {
            progress.done();
            return;
        }
        this.runUnloadModelFiles(filesToUnload, memoryOptimized, (IProgressMonitor)progress.newChild(90));
    }

    private void runUnloadModelFiles(Map<TransactionalEditingDomain, Collection<IFile>> filesToUnload, boolean memoryOptimized, IProgressMonitor monitor) throws OperationCanceledException {
        Assert.isNotNull(filesToUnload);
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)this.getFilesToUnloadCount(filesToUnload));
        if (progress.isCanceled()) {
            throw new OperationCanceledException();
        }
        for (TransactionalEditingDomain editingDomain : filesToUnload.keySet()) {
            Collection<IFile> filesToUnloadInEditingDomain = filesToUnload.get(editingDomain);
            int totalWork = filesToUnloadInEditingDomain.size();
            EcorePlatformUtil.unloadFiles((TransactionalEditingDomain)editingDomain, filesToUnloadInEditingDomain, (boolean)memoryOptimized, (IProgressMonitor)progress.newChild(totalWork));
        }
        ExtendedPlatform.performGarbageCollection();
    }

    public void reloadProject(IProject project, boolean includeReferencedProjects, boolean async, IProgressMonitor monitor) {
        this.reloadProjects(Collections.singleton(project), includeReferencedProjects, null, async, monitor);
    }

    public void reloadProject(IProject project, boolean includeReferencedProjects, IMetaModelDescriptor mmDescriptor, boolean async, IProgressMonitor monitor) {
        this.reloadProjects(Collections.singleton(project), includeReferencedProjects, mmDescriptor, async, monitor);
    }

    public void reloadProjects(Collection<IProject> projects, boolean includeReferencedProjects, boolean async, IProgressMonitor monitor) {
        this.reloadProjects(projects, includeReferencedProjects, null, async, monitor);
    }

    public void reloadProjects(final Collection<IProject> projects, final boolean includeReferencedProjects, final IMetaModelDescriptor mmDescriptor, boolean async, IProgressMonitor monitor) {
        Assert.isNotNull(projects);
        if (async && projects.size() > 0) {
            Job job = new Job(mmDescriptor != null ? Messages.job_reloadingModel : Messages.job_reloadingModels){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        ModelLoadManager.this.runReloadProjects(projects, includeReferencedProjects, mmDescriptor, monitor);
                        return Status.OK_STATUS;
                    }
                    catch (OperationCanceledException operationCanceledException) {
                        return Status.CANCEL_STATUS;
                    }
                    catch (Exception ex) {
                        return StatusUtil.createErrorStatus((Plugin)Activator.getPlugin(), (Object)ex);
                    }
                }

                public boolean belongsTo(Object family) {
                    return IExtendedPlatformConstants.FAMILY_MODEL_LOADING.equals(family) || IExtendedPlatformConstants.FAMILY_LONG_RUNNING.equals(family);
                }
            };
            job.setPriority(40);
            job.setRule(this.createLoadSchedulingRule(projects, includeReferencedProjects));
            job.schedule();
        } else {
            try {
                this.runReloadProjects(projects, includeReferencedProjects, mmDescriptor, monitor);
            }
            catch (OperationCanceledException operationCanceledException) {}
        }
    }

    private void runReloadProjects(Collection<IProject> projects, boolean includeReferencedProjects, IMetaModelDescriptor mmDescriptor, IProgressMonitor monitor) throws OperationCanceledException {
        Assert.isNotNull(projects);
        for (IProject project : projects) {
            String taskName = mmDescriptor != null ? NLS.bind((String)Messages.task_reloadingModelInProject, (Object)mmDescriptor.getName(), (Object)project.getName()) : NLS.bind((String)Messages.task_reloadingModelsInProject, (Object)project.getName());
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)taskName, (int)100);
            if (progress.isCanceled()) {
                throw new OperationCanceledException();
            }
            Collection files = ExtendedPlatform.getAllFiles((IProject)project, (boolean)includeReferencedProjects);
            progress.worked(1);
            if (files.size() == 0) {
                progress.done();
                return;
            }
            this.runDetectAndReloadModelFiles(files, mmDescriptor, ExtendedPlatform.isRootProject((IProject)project), (IProgressMonitor)progress.newChild(99));
        }
    }

    public void reloadFile(IFile file, boolean async, IProgressMonitor monitor) {
        this.reloadFiles(Collections.singleton(file), null, false, async, monitor);
    }

    public void reloadFile(IFile file, IMetaModelDescriptor mmDescriptor, boolean async, IProgressMonitor monitor) {
        this.reloadFiles(Collections.singleton(file), mmDescriptor, false, async, monitor);
    }

    public void reloadFiles(Collection<IFile> files, boolean memoryOptimized, boolean async, IProgressMonitor monitor) {
        this.reloadFiles(files, null, memoryOptimized, async, monitor);
    }

    public void reloadFiles(final Collection<IFile> files, final IMetaModelDescriptor mmDescriptor, final boolean memoryOptimized, boolean async, IProgressMonitor monitor) {
        Assert.isNotNull(files);
        if (async && files.size() > 0) {
            Job job = new Job(Messages.job_reloadingModelResources){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        ModelLoadManager.this.runDetectAndReloadModelFiles(files, mmDescriptor, memoryOptimized, monitor);
                        return Status.OK_STATUS;
                    }
                    catch (OperationCanceledException operationCanceledException) {
                        return Status.CANCEL_STATUS;
                    }
                    catch (Exception ex) {
                        return StatusUtil.createErrorStatus((Plugin)Activator.getPlugin(), (Object)ex);
                    }
                }

                public boolean belongsTo(Object family) {
                    return IExtendedPlatformConstants.FAMILY_MODEL_LOADING.equals(family) || IExtendedPlatformConstants.FAMILY_LONG_RUNNING.equals(family);
                }
            };
            job.setPriority(40);
            job.setRule(this.createLoadSchedulingRule(files));
            job.schedule();
        } else {
            try {
                this.runDetectAndReloadModelFiles(files, mmDescriptor, memoryOptimized, monitor);
            }
            catch (OperationCanceledException operationCanceledException) {}
        }
    }

    private void runDetectAndReloadModelFiles(Collection<IFile> files, IMetaModelDescriptor mmDescriptor, boolean memoryOptimized, IProgressMonitor monitor) throws OperationCanceledException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.task_reloadingModelFiles, (int)100);
        if (progress.isCanceled()) {
            throw new OperationCanceledException();
        }
        Map<TransactionalEditingDomain, Collection<IFile>> filesToUnload = this.detectFilesToUnload(files, mmDescriptor, (IProgressMonitor)progress.newChild(5));
        Map<TransactionalEditingDomain, Collection<IFile>> filesToLoad = this.detectFilesToLoad(files, mmDescriptor, false, (IProgressMonitor)progress.newChild(10));
        if (filesToUnload.size() == 0 && filesToLoad.size() == 0) {
            progress.done();
            return;
        }
        this.runReloadModelFiles(filesToUnload, filesToLoad, memoryOptimized, (IProgressMonitor)progress.newChild(85));
    }

    private void runReloadModelFiles(final Map<TransactionalEditingDomain, Collection<IFile>> filesToUnload, final Map<TransactionalEditingDomain, Collection<IFile>> filesToLoad, final boolean memoryOptimized, IProgressMonitor monitor) throws OperationCanceledException {
        Assert.isNotNull(filesToUnload);
        Assert.isNotNull(filesToLoad);
        final SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)(this.getFilesToUnloadCount(filesToUnload) + this.getFilesToLoadCount(filesToLoad)));
        if (progress.isCanceled()) {
            throw new OperationCanceledException();
        }
        HashMap<TransactionalEditingDomain, Collection<IFile>> filesToUnloadOnly = new HashMap<TransactionalEditingDomain, Collection<IFile>>();
        for (TransactionalEditingDomain editingDomain : new HashSet<TransactionalEditingDomain>(filesToUnload.keySet())) {
            if (filesToLoad.containsKey(editingDomain)) continue;
            filesToUnloadOnly.put(editingDomain, filesToUnload.get(editingDomain));
            filesToUnload.remove(editingDomain);
        }
        HashMap<TransactionalEditingDomain, Collection<IFile>> filesToLoadOnly = new HashMap<TransactionalEditingDomain, Collection<IFile>>();
        for (final TransactionalEditingDomain editingDomain : new HashSet<TransactionalEditingDomain>(filesToLoad.keySet())) {
            if (filesToUnload.containsKey(editingDomain)) continue;
            filesToLoadOnly.put(editingDomain, filesToLoad.get(editingDomain));
            filesToLoad.remove(editingDomain);
        }
        if (filesToUnloadOnly.size() > 0) {
            this.runUnloadModelFiles(filesToUnloadOnly, memoryOptimized, (IProgressMonitor)progress.newChild(this.getFilesToUnloadCount(filesToUnloadOnly)));
        }
        for (final TransactionalEditingDomain editingDomain : filesToUnload.keySet()) {
            try {
                editingDomain.runExclusive(new Runnable(){

                    @Override
                    public void run() {
                        Collection filesToUnloadInEditingDomain = (Collection)filesToUnload.get(editingDomain);
                        int totalWork = filesToUnloadInEditingDomain.size();
                        EcorePlatformUtil.unloadFiles((TransactionalEditingDomain)editingDomain, (Collection)filesToUnloadInEditingDomain, (boolean)memoryOptimized, (IProgressMonitor)progress.newChild(totalWork));
                        Collection filesToLoadInEditingDomain = (Collection)filesToLoad.get(editingDomain);
                        totalWork = filesToLoadInEditingDomain.size();
                        ModelLoadManager.this.loadModelFilesInEditingDomain(editingDomain, filesToLoadInEditingDomain, (IProgressMonitor)progress.newChild(totalWork));
                    }
                });
            }
            catch (InterruptedException ex) {
                PlatformLogUtil.logAsWarning((Plugin)Activator.getDefault(), (Object)ex);
            }
        }
        if (filesToLoadOnly.size() > 0) {
            this.runLoadModelFiles(filesToLoadOnly, (IProgressMonitor)progress.newChild(this.getFilesToLoadCount(filesToLoadOnly)));
        }
        ExtendedPlatform.performGarbageCollection();
    }

    public void unresolveUnreachableCrossProjectReferences(Collection<IProject> projects, boolean async, IProgressMonitor monitor) {
        Assert.isNotNull(projects);
        final HashSet<IProject> projectsWithUnreachableCrossRefrencesToUnresolve = new HashSet<IProject>(projects);
        for (IProject project : projects) {
            Collection referencingProjects = ExtendedPlatform.getAllReferencingProjects((IProject)project);
            projectsWithUnreachableCrossRefrencesToUnresolve.addAll(referencingProjects);
        }
        if (async && projectsWithUnreachableCrossRefrencesToUnresolve.size() > 0) {
            Job job = new Job(Messages.job_unresolvingUnreachableCrossProjectReferences){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        ModelLoadManager.this.runUnresolveUnreachableCrossProjectReferences(projectsWithUnreachableCrossRefrencesToUnresolve, monitor);
                        return Status.OK_STATUS;
                    }
                    catch (OperationCanceledException operationCanceledException) {
                        return Status.CANCEL_STATUS;
                    }
                    catch (Exception ex) {
                        return StatusUtil.createErrorStatus((Plugin)Activator.getPlugin(), (Object)ex);
                    }
                }

                public boolean belongsTo(Object family) {
                    return IExtendedPlatformConstants.FAMILY_MODEL_LOADING.equals(family) || IExtendedPlatformConstants.FAMILY_LONG_RUNNING.equals(family);
                }
            };
            job.setPriority(40);
            job.setRule(this.createLoadSchedulingRule(projectsWithUnreachableCrossRefrencesToUnresolve, false));
            job.schedule();
        } else {
            try {
                this.runUnresolveUnreachableCrossProjectReferences(projectsWithUnreachableCrossRefrencesToUnresolve, monitor);
            }
            catch (OperationCanceledException operationCanceledException) {}
        }
    }

    private void runUnresolveUnreachableCrossProjectReferences(Collection<IProject> projects, IProgressMonitor monitor) throws OperationCanceledException {
        Assert.isNotNull(projects);
        for (IProject project : projects) {
            Collection modelsInProject = ModelDescriptorRegistry.INSTANCE.getModels((IContainer)project);
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)NLS.bind((String)Messages.task_unresolvingUnreachableCrossProjectReferencesInProject, (Object)project.getName()), (int)modelsInProject.size());
            if (progress.isCanceled()) {
                throw new OperationCanceledException();
            }
            for (IModelDescriptor modelDescriptor : modelsInProject) {
                this.unresolveUnreachableCrossProjectReferencesInModel(modelDescriptor, (IProgressMonitor)progress.newChild(1));
                if (!progress.isCanceled()) continue;
                throw new OperationCanceledException();
            }
        }
    }

    private void unresolveUnreachableCrossProjectReferencesInModel(final IModelDescriptor modelDescriptor, final IProgressMonitor monitor) throws OperationCanceledException {
        Assert.isNotNull((Object)modelDescriptor);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                Collection resources = modelDescriptor.getLoadedResources(true);
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)resources.size());
                if (progress.isCanceled()) {
                    throw new OperationCanceledException();
                }
                for (Resource resource : resources) {
                    progress.subTask(NLS.bind((String)Messages.subtask_unresolvingUnreachableCrossProjectReferencesInResource, (Object)resource.getURI()));
                    try {
                        TreeIterator allContents = resource.getAllContents();
                        while (allContents.hasNext()) {
                            EObject object = (EObject)allContents.next();
                            for (EReference reference : object.eClass().getEAllReferences()) {
                                if (reference.isContainment() || reference.isContainer()) continue;
                                if (reference.isMany()) {
                                    EList referencedObjects = (EList)object.eGet((EStructuralFeature)reference);
                                    if (referencedObjects instanceof BasicEList.UnmodifiableEList) continue;
                                    ArrayList safeReferencedObjects = new ArrayList(referencedObjects);
                                    for (EObject referencedObject : safeReferencedObjects) {
                                        if (referencedObject == null || referencedObject.eIsProxy() || modelDescriptor.getScope().belongsTo(referencedObject.eResource(), true)) continue;
                                        referencedObjects.remove((Object)referencedObject);
                                        referencedObjects.add((Object)EObjectUtil.createProxyFrom((EObject)referencedObject, (Resource)object.eResource()));
                                    }
                                    continue;
                                }
                                EObject referencedObject = (EObject)object.eGet((EStructuralFeature)reference);
                                if (referencedObject == null || referencedObject.eIsProxy() || modelDescriptor.getScope().belongsTo(referencedObject.eResource(), true)) continue;
                                object.eSet((EStructuralFeature)reference, (Object)EObjectUtil.createProxyFrom((EObject)referencedObject, (Resource)object.eResource()));
                            }
                            if (!progress.isCanceled()) continue;
                            throw new OperationCanceledException();
                        }
                    }
                    catch (Exception ex) {
                        PlatformLogUtil.logAsWarning((Plugin)Activator.getPlugin(), (Object)ex);
                    }
                    progress.worked(1);
                    if (progress.isCanceled()) {
                        throw new OperationCanceledException();
                    }
                    modelDescriptor.getEditingDomain().yield();
                }
            }
        };
        try {
            IOperationHistory operationHistory = WorkspaceTransactionUtil.getOperationHistory((TransactionalEditingDomain)modelDescriptor.getEditingDomain());
            Map options = WorkspaceTransactionUtil.getDefaultTransactionOptions();
            options.put("no_undo", Boolean.TRUE);
            WorkspaceTransactionUtil.executeInWriteTransaction((TransactionalEditingDomain)modelDescriptor.getEditingDomain(), (Runnable)runnable, (String)Messages.operation_unresolvingUnreachableCrossProjectReferencesInModel, (IOperationHistory)operationHistory, (Map)options, null);
        }
        catch (ExecutionException ex) {
            PlatformLogUtil.logAsError((Plugin)Activator.getPlugin(), (Object)((Object)ex));
        }
    }

    public void loadModel(IModelDescriptor modelDescriptor, boolean async, IProgressMonitor monitor) {
        this.loadModel(modelDescriptor, true, async, monitor);
    }

    public void loadModel(final IModelDescriptor modelDescriptor, boolean includeReferencedScopes, boolean async, IProgressMonitor monitor) {
        Assert.isNotNull((Object)modelDescriptor);
        final Collection persistedFiles = modelDescriptor.getPersistedFiles(includeReferencedScopes);
        IMetaModelDescriptor mmDescriptor = modelDescriptor.getMetaModelDescriptor();
        if (async && persistedFiles.size() > 0) {
            if (!LoadJob.shouldCreateJob(persistedFiles, mmDescriptor)) {
                return;
            }
            FileLoadJob job = new FileLoadJob(persistedFiles, mmDescriptor){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        ModelLoadManager.this.runCollectAndLoadModelFiles(modelDescriptor.getEditingDomain(), persistedFiles, monitor);
                        return Status.OK_STATUS;
                    }
                    catch (OperationCanceledException operationCanceledException) {
                        return Status.CANCEL_STATUS;
                    }
                    catch (Exception ex) {
                        return StatusUtil.createErrorStatus((Plugin)Activator.getPlugin(), (Object)ex);
                    }
                }

                public boolean belongsTo(Object family) {
                    return IExtendedPlatformConstants.FAMILY_MODEL_LOADING.equals(family) || IExtendedPlatformConstants.FAMILY_LONG_RUNNING.equals(family);
                }
            };
            job.setPriority(40);
            job.setRule(this.createLoadSchedulingRule(persistedFiles));
            job.schedule();
        } else {
            try {
                this.runCollectAndLoadModelFiles(modelDescriptor.getEditingDomain(), persistedFiles, monitor);
            }
            catch (OperationCanceledException operationCanceledException) {}
        }
    }

    public void loadModels(Collection<IModelDescriptor> modelDescriptors, boolean async, IProgressMonitor monitor) {
        this.loadModels(modelDescriptors, true, async, monitor);
    }

    public void loadModels(Collection<IModelDescriptor> modelDescriptors, boolean includeReferencedScopes, boolean async, IProgressMonitor monitor) {
        Assert.isNotNull(modelDescriptors);
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)modelDescriptors.size());
        for (IModelDescriptor modelDescriptor : modelDescriptors) {
            this.loadModel(modelDescriptor, includeReferencedScopes, async, (IProgressMonitor)progress.newChild(1));
            if (!progress.isCanceled()) continue;
            throw new OperationCanceledException();
        }
    }

    private void runCollectAndLoadModelFiles(TransactionalEditingDomain editingDomain, Collection<IFile> files, IProgressMonitor monitor) throws OperationCanceledException {
        Assert.isNotNull(files);
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.task_loadingModelFiles, (int)100);
        if (progress.isCanceled()) {
            throw new OperationCanceledException();
        }
        SubMonitor collectProgress = progress.newChild(1).setWorkRemaining(files.size());
        HashMap<TransactionalEditingDomain, Collection<IFile>> filesToLoad = new HashMap<TransactionalEditingDomain, Collection<IFile>>();
        for (IFile file : files) {
            try {
                if (file.isAccessible() && !EcorePlatformUtil.isFileLoaded((IFile)file)) {
                    HashSet<IFile> filesToLoadInEditingDomain = (HashSet<IFile>)filesToLoad.get(editingDomain);
                    if (filesToLoadInEditingDomain == null) {
                        filesToLoadInEditingDomain = new HashSet<IFile>();
                        filesToLoad.put(editingDomain, filesToLoadInEditingDomain);
                    }
                    filesToLoadInEditingDomain.add(file);
                }
            }
            catch (Exception ex) {
                PlatformLogUtil.logAsWarning((Plugin)Activator.getPlugin(), (Object)ex);
            }
            collectProgress.worked(1);
            if (!collectProgress.isCanceled()) continue;
            throw new OperationCanceledException();
        }
        if (filesToLoad.size() == 0) {
            progress.done();
            return;
        }
        this.runLoadModelFiles(filesToLoad, (IProgressMonitor)progress.newChild(99));
    }

    public void unloadModel(IModelDescriptor modelDescriptor, boolean async, IProgressMonitor monitor) {
        this.unloadModel(modelDescriptor, true, async, monitor);
    }

    public void unloadModel(IModelDescriptor modelDescriptor, boolean includeReferencedScopes, boolean async, IProgressMonitor monitor) {
        Assert.isNotNull((Object)modelDescriptor);
        HashMap<TransactionalEditingDomain, Collection<Resource>> resourcesToUnload = new HashMap<TransactionalEditingDomain, Collection<Resource>>();
        resourcesToUnload.put(modelDescriptor.getEditingDomain(), modelDescriptor.getLoadedResources(includeReferencedScopes));
        this.internalUnloadResources(resourcesToUnload, true, async, monitor);
    }

    public void unloadModels(Collection<IModelDescriptor> modelDescriptors, boolean async, IProgressMonitor monitor) {
        this.unloadModels(modelDescriptors, true, async, monitor);
    }

    public void unloadModels(Collection<IModelDescriptor> modelDescriptors, boolean includeReferencedScopes, boolean async, IProgressMonitor monitor) {
        Assert.isNotNull(modelDescriptors);
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)modelDescriptors.size());
        for (IModelDescriptor modelDescriptor : modelDescriptors) {
            this.unloadModel(modelDescriptor, includeReferencedScopes, async, (IProgressMonitor)progress.newChild(1));
            if (!progress.isCanceled()) continue;
            throw new OperationCanceledException();
        }
    }

    public void updateResourceURIs(final Map<IFile, IPath> filesToUpdate, boolean async, IProgressMonitor monitor) {
        Assert.isNotNull(filesToUpdate);
        if (async && filesToUpdate.size() > 0) {
            Job job = new Job(Messages.job_updatingResourceURIs){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        ModelLoadManager.this.runDetectAndUpdateResourceURIs(filesToUpdate, monitor);
                        return Status.OK_STATUS;
                    }
                    catch (OperationCanceledException operationCanceledException) {
                        return Status.CANCEL_STATUS;
                    }
                    catch (Exception ex) {
                        return StatusUtil.createErrorStatus((Plugin)Activator.getPlugin(), (Object)ex);
                    }
                }

                public boolean belongsTo(Object family) {
                    return IExtendedPlatformConstants.FAMILY_MODEL_LOADING.equals(family) || IExtendedPlatformConstants.FAMILY_LONG_RUNNING.equals(family);
                }
            };
            job.setPriority(40);
            job.setRule(this.createLoadSchedulingRule(filesToUpdate.keySet()));
            job.schedule();
        } else {
            try {
                this.runDetectAndUpdateResourceURIs(filesToUpdate, monitor);
            }
            catch (OperationCanceledException operationCanceledException) {}
        }
    }

    private void runDetectAndUpdateResourceURIs(Map<IFile, IPath> filesToUpdate, IProgressMonitor monitor) throws OperationCanceledException {
        Assert.isNotNull(filesToUpdate);
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.task_updatingResourceURIs, (int)100);
        if (progress.isCanceled()) {
            throw new OperationCanceledException();
        }
        Map<TransactionalEditingDomain, Map<IFile, IPath>> filesToUpdateResourceURIFor = this.detectFilesToUpdateResourceURIFor(filesToUpdate, (IProgressMonitor)progress.newChild(10));
        if (filesToUpdateResourceURIFor.size() == 0) {
            progress.done();
            return;
        }
        this.runUpdateResourceURIs(filesToUpdateResourceURIFor, (IProgressMonitor)progress.newChild(90));
    }

    private void runUpdateResourceURIs(Map<TransactionalEditingDomain, Map<IFile, IPath>> filesToUpdateResourceURIFor, IProgressMonitor monitor) throws OperationCanceledException {
        Assert.isNotNull(filesToUpdateResourceURIFor);
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)filesToUpdateResourceURIFor.keySet().size());
        if (progress.isCanceled()) {
            throw new OperationCanceledException();
        }
        for (TransactionalEditingDomain editingDomain : filesToUpdateResourceURIFor.keySet()) {
            this.updateResourceURIsInEditingDomain(editingDomain, filesToUpdateResourceURIFor.get(editingDomain), (IProgressMonitor)progress.newChild(1));
        }
    }

    private void updateResourceURIsInEditingDomain(final TransactionalEditingDomain editingDomain, final Map<IFile, IPath> filesToUpdateResourceURIForInEditingDomain, final IProgressMonitor monitor) throws OperationCanceledException {
        Assert.isNotNull((Object)editingDomain);
        Assert.isNotNull(filesToUpdateResourceURIForInEditingDomain);
        try {
            editingDomain.runExclusive(new Runnable(){

                @Override
                public void run() {
                    SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)filesToUpdateResourceURIForInEditingDomain.size());
                    if (progress.isCanceled()) {
                        throw new OperationCanceledException();
                    }
                    for (IFile oldFile : filesToUpdateResourceURIForInEditingDomain.keySet()) {
                        progress.subTask(NLS.bind((String)Messages.subtask_updatingResourceURI, (Object)oldFile.getFullPath().toString()));
                        URI oldURI = EcorePlatformUtil.createURI((IPath)oldFile.getFullPath());
                        Resource resource = editingDomain.getResourceSet().getResource(oldURI, false);
                        if (resource != null) {
                            IPath newPath = (IPath)filesToUpdateResourceURIForInEditingDomain.get(oldFile);
                            URI newURI = EcorePlatformUtil.createURI((IPath)newPath);
                            resource.setURI(newURI);
                        }
                        progress.worked(1);
                        if (progress.isCanceled()) {
                            throw new OperationCanceledException();
                        }
                        editingDomain.yield();
                    }
                }
            });
        }
        catch (InterruptedException ex) {
            PlatformLogUtil.logAsWarning((Plugin)Activator.getDefault(), (Object)ex);
        }
    }
}

