/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.resource;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.XMIException;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sphinx.emf.resource.BasicResourceProblemMarkerFactory;
import org.eclipse.sphinx.emf.resource.ProxyURIIntegrityException;
import org.eclipse.sphinx.emf.resource.XMLIntegrityException;
import org.eclipse.sphinx.emf.resource.XMLValidityException;
import org.eclipse.sphinx.emf.resource.XMLWellformednessException;
import org.eclipse.sphinx.platform.resources.MarkerDescriptor;
import org.xml.sax.SAXParseException;

public class XMLResourceProblemMarkerFactory
extends BasicResourceProblemMarkerFactory {
    @Override
    protected MarkerDescriptor createProblemMarkerDescriptor(Resource.Diagnostic diagnostic, int severity, Map<Object, Object> problemHandlingOptions) {
        MarkerDescriptor markerDescriptor = super.createProblemMarkerDescriptor(diagnostic, severity, problemHandlingOptions);
        if (diagnostic instanceof XMIException) {
            XMIException xmiException = (XMIException)diagnostic;
            if (xmiException.getCause() instanceof XMLWellformednessException) {
                String format = problemHandlingOptions != null ? (String)problemHandlingOptions.get("XML_WELLFORMEDNESS_PROBLEM_FORMAT_STRING") : null;
                markerDescriptor.getAttributes().put("message", this.createProblemMarkerMessage(format, (Exception)xmiException));
                markerDescriptor.setType("org.eclipse.sphinx.emf.xmlwellformednessproblemmarker");
            } else if (xmiException.getCause() instanceof XMLValidityException || xmiException.getCause() instanceof SAXParseException && xmiException.getMessage().contains("cvc-")) {
                Integer resourceDefinedSeverity;
                Integer n = resourceDefinedSeverity = problemHandlingOptions != null ? (Integer)problemHandlingOptions.get("XML_VALIDITY_PROBLEM_SEVERITY") : null;
                if (resourceDefinedSeverity != null) {
                    markerDescriptor.getAttributes().put("severity", resourceDefinedSeverity);
                }
                String format = problemHandlingOptions != null ? (String)problemHandlingOptions.get("XML_VALIDITY_PROBLEM_FORMAT_STRING") : null;
                markerDescriptor.getAttributes().put("message", this.createProblemMarkerMessage(format, (Exception)xmiException));
                markerDescriptor.setType("org.eclipse.sphinx.emf.xmlvalidityproblemmarker");
            } else if (xmiException instanceof XMLIntegrityException) {
                markerDescriptor.getAttributes().put("message", this.createProblemMarkerMessage((Exception)xmiException));
                markerDescriptor.setType("org.eclipse.sphinx.emf.xmlintegrityproblemmarker");
            } else if (xmiException instanceof ProxyURIIntegrityException) {
                markerDescriptor.getAttributes().put("message", this.createProblemMarkerMessage((Exception)xmiException));
                markerDescriptor.setType("org.eclipse.sphinx.emf.proxyuriintegrityproblemmarker");
            } else {
                markerDescriptor.getAttributes().put("message", this.createProblemMarkerMessage((Exception)xmiException));
            }
        }
        return markerDescriptor;
    }

    protected String createProblemMarkerMessage(String format, Exception exception) {
        Assert.isNotNull((Object)exception);
        String msg = this.createProblemMarkerMessage(exception);
        if (format == null) {
            return msg;
        }
        if (format.contains("{0}")) {
            return NLS.bind((String)format, (Object)msg);
        }
        if (!format.endsWith(" ")) {
            format.concat(" ");
        }
        return format.concat(msg);
    }

    @Override
    protected List<String> getProblemMarkerTypesToDelete() {
        return Arrays.asList("org.eclipse.core.resources.problemmarker", "org.eclipse.sphinx.emf.xmlwellformednessproblemmarker", "org.eclipse.sphinx.emf.xmlvalidityproblemmarker", "org.eclipse.sphinx.emf.xmlintegrityproblemmarker");
    }
}

