/**
 * <copyright>
 * 
 * Copyright (c) 2008-2011 See4sys and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 *     See4sys - Initial API and implementation
 * 
 * </copyright>
 */
package org.eclipse.sphinx.examples.hummingbird20.instancemodel.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;

import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.EObjectContainmentWithInverseEList;
import org.eclipse.emf.ecore.util.InternalEList;

import org.eclipse.sphinx.examples.hummingbird20.common.impl.IdentifiableImpl;

import org.eclipse.sphinx.examples.hummingbird20.instancemodel.Component;
import org.eclipse.sphinx.examples.hummingbird20.instancemodel.Connection;
import org.eclipse.sphinx.examples.hummingbird20.instancemodel.InstanceModel20Package;
import org.eclipse.sphinx.examples.hummingbird20.instancemodel.ParameterExpresssion;
import org.eclipse.sphinx.examples.hummingbird20.instancemodel.ParameterValue;

import org.eclipse.sphinx.examples.hummingbird20.typemodel.ComponentType;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Component</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.sphinx.examples.hummingbird20.instancemodel.impl.ComponentImpl#getType <em>Type</em>}</li>
 *   <li>{@link org.eclipse.sphinx.examples.hummingbird20.instancemodel.impl.ComponentImpl#getOutgoingConnections <em>Outgoing Connections</em>}</li>
 *   <li>{@link org.eclipse.sphinx.examples.hummingbird20.instancemodel.impl.ComponentImpl#getIncomingConnections <em>Incoming Connections</em>}</li>
 *   <li>{@link org.eclipse.sphinx.examples.hummingbird20.instancemodel.impl.ComponentImpl#getParameterValues <em>Parameter Values</em>}</li>
 *   <li>{@link org.eclipse.sphinx.examples.hummingbird20.instancemodel.impl.ComponentImpl#getParameterExpressions <em>Parameter Expressions</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class ComponentImpl extends IdentifiableImpl implements Component
{
	/**
	 * The cached value of the '{@link #getType() <em>Type</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getType()
	 * @generated
	 * @ordered
	 */
	protected ComponentType type;

	/**
	 * The cached value of the '{@link #getOutgoingConnections() <em>Outgoing Connections</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getOutgoingConnections()
	 * @generated
	 * @ordered
	 */
	protected EList<Connection> outgoingConnections;

	/**
	 * The cached value of the '{@link #getIncomingConnections() <em>Incoming Connections</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getIncomingConnections()
	 * @generated
	 * @ordered
	 */
	protected Connection incomingConnections;

	/**
	 * The cached value of the '{@link #getParameterValues() <em>Parameter Values</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getParameterValues()
	 * @generated
	 * @ordered
	 */
	protected EList<ParameterValue> parameterValues;

	/**
	 * The cached value of the '{@link #getParameterExpressions() <em>Parameter Expressions</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getParameterExpressions()
	 * @generated
	 * @ordered
	 */
	protected EList<ParameterExpresssion> parameterExpressions;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ComponentImpl()
	{
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass()
	{
		return InstanceModel20Package.Literals.COMPONENT;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ComponentType getType()
	{
		if (type != null && type.eIsProxy()) {
			InternalEObject oldType = (InternalEObject)type;
			type = (ComponentType)eResolveProxy(oldType);
			if (type != oldType) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, InstanceModel20Package.COMPONENT__TYPE, oldType, type));
			}
		}
		return type;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ComponentType basicGetType()
	{
		return type;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setType(ComponentType newType)
	{
		ComponentType oldType = type;
		type = newType;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, InstanceModel20Package.COMPONENT__TYPE, oldType, type));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<Connection> getOutgoingConnections()
	{
		if (outgoingConnections == null) {
			outgoingConnections = new EObjectContainmentWithInverseEList<Connection>(Connection.class, this, InstanceModel20Package.COMPONENT__OUTGOING_CONNECTIONS, InstanceModel20Package.CONNECTION__SOURCE_COMPONENT);
		}
		return outgoingConnections;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Connection getIncomingConnections()
	{
		if (incomingConnections != null && incomingConnections.eIsProxy()) {
			InternalEObject oldIncomingConnections = (InternalEObject)incomingConnections;
			incomingConnections = (Connection)eResolveProxy(oldIncomingConnections);
			if (incomingConnections != oldIncomingConnections) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, InstanceModel20Package.COMPONENT__INCOMING_CONNECTIONS, oldIncomingConnections, incomingConnections));
			}
		}
		return incomingConnections;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Connection basicGetIncomingConnections()
	{
		return incomingConnections;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetIncomingConnections(Connection newIncomingConnections, NotificationChain msgs)
	{
		Connection oldIncomingConnections = incomingConnections;
		incomingConnections = newIncomingConnections;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, InstanceModel20Package.COMPONENT__INCOMING_CONNECTIONS, oldIncomingConnections, newIncomingConnections);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setIncomingConnections(Connection newIncomingConnections)
	{
		if (newIncomingConnections != incomingConnections) {
			NotificationChain msgs = null;
			if (incomingConnections != null)
				msgs = ((InternalEObject)incomingConnections).eInverseRemove(this, InstanceModel20Package.CONNECTION__TARGET_COMPONENT, Connection.class, msgs);
			if (newIncomingConnections != null)
				msgs = ((InternalEObject)newIncomingConnections).eInverseAdd(this, InstanceModel20Package.CONNECTION__TARGET_COMPONENT, Connection.class, msgs);
			msgs = basicSetIncomingConnections(newIncomingConnections, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, InstanceModel20Package.COMPONENT__INCOMING_CONNECTIONS, newIncomingConnections, newIncomingConnections));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<ParameterValue> getParameterValues()
	{
		if (parameterValues == null) {
			parameterValues = new EObjectContainmentEList<ParameterValue>(ParameterValue.class, this, InstanceModel20Package.COMPONENT__PARAMETER_VALUES);
		}
		return parameterValues;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<ParameterExpresssion> getParameterExpressions() {
		if (parameterExpressions == null) {
			parameterExpressions = new EObjectContainmentEList<ParameterExpresssion>(ParameterExpresssion.class, this, InstanceModel20Package.COMPONENT__PARAMETER_EXPRESSIONS);
		}
		return parameterExpressions;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs)
	{
		switch (featureID) {
			case InstanceModel20Package.COMPONENT__OUTGOING_CONNECTIONS:
				return ((InternalEList<InternalEObject>)(InternalEList<?>)getOutgoingConnections()).basicAdd(otherEnd, msgs);
			case InstanceModel20Package.COMPONENT__INCOMING_CONNECTIONS:
				if (incomingConnections != null)
					msgs = ((InternalEObject)incomingConnections).eInverseRemove(this, InstanceModel20Package.CONNECTION__TARGET_COMPONENT, Connection.class, msgs);
				return basicSetIncomingConnections((Connection)otherEnd, msgs);
		}
		return super.eInverseAdd(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs)
	{
		switch (featureID) {
			case InstanceModel20Package.COMPONENT__OUTGOING_CONNECTIONS:
				return ((InternalEList<?>)getOutgoingConnections()).basicRemove(otherEnd, msgs);
			case InstanceModel20Package.COMPONENT__INCOMING_CONNECTIONS:
				return basicSetIncomingConnections(null, msgs);
			case InstanceModel20Package.COMPONENT__PARAMETER_VALUES:
				return ((InternalEList<?>)getParameterValues()).basicRemove(otherEnd, msgs);
			case InstanceModel20Package.COMPONENT__PARAMETER_EXPRESSIONS:
				return ((InternalEList<?>)getParameterExpressions()).basicRemove(otherEnd, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType)
	{
		switch (featureID) {
			case InstanceModel20Package.COMPONENT__TYPE:
				if (resolve) return getType();
				return basicGetType();
			case InstanceModel20Package.COMPONENT__OUTGOING_CONNECTIONS:
				return getOutgoingConnections();
			case InstanceModel20Package.COMPONENT__INCOMING_CONNECTIONS:
				if (resolve) return getIncomingConnections();
				return basicGetIncomingConnections();
			case InstanceModel20Package.COMPONENT__PARAMETER_VALUES:
				return getParameterValues();
			case InstanceModel20Package.COMPONENT__PARAMETER_EXPRESSIONS:
				return getParameterExpressions();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue)
	{
		switch (featureID) {
			case InstanceModel20Package.COMPONENT__TYPE:
				setType((ComponentType)newValue);
				return;
			case InstanceModel20Package.COMPONENT__OUTGOING_CONNECTIONS:
				getOutgoingConnections().clear();
				getOutgoingConnections().addAll((Collection<? extends Connection>)newValue);
				return;
			case InstanceModel20Package.COMPONENT__INCOMING_CONNECTIONS:
				setIncomingConnections((Connection)newValue);
				return;
			case InstanceModel20Package.COMPONENT__PARAMETER_VALUES:
				getParameterValues().clear();
				getParameterValues().addAll((Collection<? extends ParameterValue>)newValue);
				return;
			case InstanceModel20Package.COMPONENT__PARAMETER_EXPRESSIONS:
				getParameterExpressions().clear();
				getParameterExpressions().addAll((Collection<? extends ParameterExpresssion>)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID)
	{
		switch (featureID) {
			case InstanceModel20Package.COMPONENT__TYPE:
				setType((ComponentType)null);
				return;
			case InstanceModel20Package.COMPONENT__OUTGOING_CONNECTIONS:
				getOutgoingConnections().clear();
				return;
			case InstanceModel20Package.COMPONENT__INCOMING_CONNECTIONS:
				setIncomingConnections((Connection)null);
				return;
			case InstanceModel20Package.COMPONENT__PARAMETER_VALUES:
				getParameterValues().clear();
				return;
			case InstanceModel20Package.COMPONENT__PARAMETER_EXPRESSIONS:
				getParameterExpressions().clear();
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID)
	{
		switch (featureID) {
			case InstanceModel20Package.COMPONENT__TYPE:
				return type != null;
			case InstanceModel20Package.COMPONENT__OUTGOING_CONNECTIONS:
				return outgoingConnections != null && !outgoingConnections.isEmpty();
			case InstanceModel20Package.COMPONENT__INCOMING_CONNECTIONS:
				return incomingConnections != null;
			case InstanceModel20Package.COMPONENT__PARAMETER_VALUES:
				return parameterValues != null && !parameterValues.isEmpty();
			case InstanceModel20Package.COMPONENT__PARAMETER_EXPRESSIONS:
				return parameterExpressions != null && !parameterExpressions.isEmpty();
		}
		return super.eIsSet(featureID);
	}

} //ComponentImpl
