/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.compare.ui.editor;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.commands.operations.IOperationHistoryListener;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.commands.operations.OperationHistoryEvent;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.ui.action.EditingDomainActionBarContributor;
import org.eclipse.emf.edit.ui.action.RedoAction;
import org.eclipse.emf.edit.ui.action.UndoAction;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.workspace.IWorkspaceCommandStack;
import org.eclipse.emf.workspace.ResourceUndoContext;
import org.eclipse.emf.workspace.ui.actions.RedoActionWrapper;
import org.eclipse.emf.workspace.ui.actions.UndoActionWrapper;
import org.eclipse.jface.action.IAction;
import org.eclipse.sphinx.emf.compare.ui.editor.ModelCompareEditor;
import org.eclipse.sphinx.emf.compare.ui.internal.Activator;
import org.eclipse.sphinx.emf.util.WorkspaceEditingDomainUtil;
import org.eclipse.sphinx.emf.workspace.domain.WorkspaceEditingDomainManager;
import org.eclipse.sphinx.platform.util.PlatformLogUtil;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelCompareActionBarContributor
extends EditingDomainActionBarContributor {
    protected IOperationHistoryListener historyListener;

    public ModelCompareActionBarContributor() {
        super(1);
    }

    protected IOperationHistoryListener createOperationHistoryListener() {
        return new IOperationHistoryListener(){

            public void historyNotification(OperationHistoryEvent event) {
                if (event.getEventType() == 4 || event.getEventType() == 10 || event.getEventType() == 9) {
                    IUndoContext[] contexts;
                    IUndoContext[] iUndoContextArray = contexts = event.getOperation().getContexts();
                    int n = contexts.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IUndoContext context = iUndoContextArray[n2];
                        if (ModelCompareEditor.ID.equals(context.getLabel())) {
                            Set affectedResources = ResourceUndoContext.getAffectedResources((IUndoableOperation)event.getOperation());
                            TransactionalEditingDomain editingDomain = null;
                            for (Resource resource : affectedResources) {
                                TransactionalEditingDomain domain = WorkspaceEditingDomainUtil.getEditingDomain((Object)resource);
                                if (editingDomain != null && editingDomain != domain) {
                                    UnsupportedOperationException ex = new UnsupportedOperationException("Several editing domains");
                                    PlatformLogUtil.logAsWarning((Plugin)Activator.getPlugin(), (Object)ex);
                                    editingDomain = null;
                                    break;
                                }
                                editingDomain = domain;
                            }
                            if (editingDomain == null) break;
                            if (ModelCompareActionBarContributor.this.undoAction != null) {
                                ModelCompareActionBarContributor.this.undoAction.setEditingDomain(editingDomain);
                            }
                            if (ModelCompareActionBarContributor.this.redoAction == null) break;
                            ModelCompareActionBarContributor.this.redoAction.setEditingDomain((EditingDomain)editingDomain);
                            break;
                        }
                        ++n2;
                    }
                }
            }
        };
    }

    public void init(IActionBars actionBars) {
        super.init(actionBars);
        this.historyListener = this.createOperationHistoryListener();
        ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
        this.undoAction = this.createUndoAction();
        this.undoAction.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_UNDO"));
        actionBars.setGlobalActionHandler(ActionFactory.UNDO.getId(), (IAction)this.undoAction);
        this.redoAction = this.createRedoAction();
        this.redoAction.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_REDO"));
        actionBars.setGlobalActionHandler(ActionFactory.REDO.getId(), (IAction)this.redoAction);
    }

    protected RedoAction createRedoAction() {
        return new RedoActionWrapper();
    }

    protected UndoAction createUndoAction() {
        return new UndoActionWrapper();
    }

    public void setActiveEditor(IEditorPart part) {
        if (part != this.activeEditor) {
            if (this.activeEditor != null) {
                this.deactivate();
            }
            if (part instanceof ModelCompareEditor) {
                this.activeEditor = part;
                this.activate();
            }
        }
    }

    public void dispose() {
        super.dispose();
        if (this.historyListener != null) {
            List editingDomains = WorkspaceEditingDomainManager.INSTANCE.getEditingDomainMapping().getEditingDomains();
            for (TransactionalEditingDomain editingDomain : editingDomains) {
                ((IWorkspaceCommandStack)editingDomain.getCommandStack()).getOperationHistory().removeOperationHistoryListener(this.historyListener);
            }
        }
        this.historyListener = null;
    }

    public void deactivate() {
        this.activeEditor.removePropertyListener((IPropertyListener)this);
        this.undoAction.setActiveWorkbenchPart(null);
        this.redoAction.setActiveWorkbenchPart(null);
    }

    protected Set<TransactionalEditingDomain> getEditingDomainsFromCompareEditor() {
        HashSet<TransactionalEditingDomain> editingDomains = new HashSet<TransactionalEditingDomain>();
        TransactionalEditingDomain[] transactionalEditingDomainArray = ((ModelCompareEditor)this.activeEditor).getEditingDomains();
        int n = transactionalEditingDomainArray.length;
        int n2 = 0;
        while (n2 < n) {
            TransactionalEditingDomain editingDomain = transactionalEditingDomainArray[n2];
            if (editingDomain != null) {
                editingDomains.add(editingDomain);
            }
            ++n2;
        }
        return editingDomains;
    }

    public void activate() {
        if (this.historyListener != null) {
            for (TransactionalEditingDomain editingDomain : this.getEditingDomainsFromCompareEditor()) {
                ((IWorkspaceCommandStack)editingDomain.getCommandStack()).getOperationHistory().addOperationHistoryListener(this.historyListener);
            }
        }
        this.activeEditor.addPropertyListener((IPropertyListener)this);
        this.undoAction.setActiveWorkbenchPart((IWorkbenchPart)this.activeEditor);
        this.redoAction.setActiveWorkbenchPart((IWorkbenchPart)this.activeEditor);
        this.update();
    }

    public void update() {
        this.undoAction.update();
        this.redoAction.update();
    }
}

