/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.platform.ui.fields;

import org.eclipse.sphinx.platform.ui.fields.ComboField;
import org.eclipse.sphinx.platform.ui.fields.IComboButtonField;
import org.eclipse.sphinx.platform.ui.fields.adapters.IButtonAdapter;
import org.eclipse.sphinx.platform.ui.internal.util.LayoutUtil;
import org.eclipse.sphinx.platform.ui.widgets.IWidgetFactory;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class ComboButtonField
extends ComboField
implements IComboButtonField {
    private Button fBrowseButton;
    private String fBrowseButtonLabel = "!Browse...!";
    private IButtonAdapter fStringButtonAdapter;
    private boolean fButtonEnabled = true;

    public ComboButtonField(IButtonAdapter adapter) {
        this(false, adapter);
    }

    public ComboButtonField(boolean isEditable, IButtonAdapter adapter) {
        this(null, isEditable, adapter);
    }

    public ComboButtonField(IWidgetFactory widgetFactory, boolean isEditable, IButtonAdapter adapter) {
        super(widgetFactory, isEditable);
        this.fStringButtonAdapter = adapter;
    }

    public ComboButtonField(IWidgetFactory widgetFactory, int style, IButtonAdapter adapter) {
        super(widgetFactory, style);
        this.fStringButtonAdapter = adapter;
    }

    public void setButtonLabel(String label) {
        this.fBrowseButtonLabel = label;
    }

    private void changeControlPressed() {
        this.fStringButtonAdapter.changeControlPressed(this);
    }

    protected Control[] doFillIntoGrid(Composite parent, int nColumns) {
        Control label = this.getLabelControl(parent, 1);
        Combo combo = this.getComboControl(parent, nColumns - 2);
        Button button = this.getChangeControl(parent, 1);
        return new Control[]{label, combo, button};
    }

    protected int getNumberOfControls() {
        return 3;
    }

    protected final Button getChangeControl(Composite parent, int hspan) {
        Button button = this.fBrowseButton;
        if (button == null && (button = this.createChangeControl(parent)).getLayoutData() == null) {
            if (this.fUseFormLayout) {
                button.setLayoutData((Object)LayoutUtil.tableWrapDataForButton(button, hspan));
            } else {
                button.setLayoutData((Object)LayoutUtil.gridDataForButton(button, hspan));
            }
        }
        return button;
    }

    private Button createChangeControl(Composite parent) {
        if (this.fBrowseButton == null) {
            this.assertCompositeNotNull(parent);
            int style = -1;
            style = this.fUseFormLayout ? 0x800000 : 8;
            this.fBrowseButton = new Button(parent, style);
            this.fBrowseButton.setFont(parent.getFont());
            this.fBrowseButton.setText(this.fBrowseButtonLabel);
            this.fBrowseButton.setEnabled(this.isEnabled() && this.fButtonEnabled);
            this.fBrowseButton.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                    ComboButtonField.this.changeControlPressed();
                }

                public void widgetSelected(SelectionEvent e) {
                    ComboButtonField.this.changeControlPressed();
                }
            });
        }
        return this.fBrowseButton;
    }

    public Control getButtonControl() {
        Button control = null;
        if (this.isOkToUse((Control)this.fBrowseButton)) {
            control = this.fBrowseButton;
        }
        return control;
    }

    public void enableButton(boolean enable) {
        if (this.isOkToUse((Control)this.fBrowseButton)) {
            this.fBrowseButton.setEnabled(this.isEnabled() && enable);
        }
        this.fButtonEnabled = enable;
    }

    protected void updateEnableState() {
        super.updateEnableState();
        if (this.isOkToUse((Control)this.fBrowseButton)) {
            this.fBrowseButton.setEnabled(this.isEnabled() && this.fButtonEnabled);
        }
    }

    public void dispose() {
        super.dispose();
        if (this.isOkToUse((Control)this.fBrowseButton)) {
            this.fBrowseButton.dispose();
        }
    }
}

