/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.workspace.ui.viewers.state.providers;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.sphinx.emf.workspace.ui.viewers.state.providers.AbstractTreeElementStateProvider;
import org.eclipse.sphinx.emf.workspace.ui.viewers.state.providers.TreeElementStateProviderFactory;
import org.eclipse.ui.IMemento;

public class ProjectElementStateProvider
extends AbstractTreeElementStateProvider {
    private IProject project = null;

    public ProjectElementStateProvider(TreeViewer viewer, IMemento memento) {
        super(viewer);
        Assert.isNotNull((Object)memento);
        String name = memento.getString("name");
        if (name != null) {
            this.project = ResourcesPlugin.getWorkspace().getRoot().getProject(name);
        }
    }

    public ProjectElementStateProvider(TreeViewer viewer, IProject project) {
        super(viewer);
        this.project = project;
    }

    @Override
    public boolean hasUnderlyingModel() {
        return false;
    }

    @Override
    public boolean canUnderlyingModelBeLoaded() {
        return false;
    }

    @Override
    public boolean isUnderlyingModelLoaded() {
        return false;
    }

    @Override
    public void loadUnderlyingModel() {
    }

    @Override
    public boolean isStale() {
        if (this.project != null) {
            return !this.project.exists();
        }
        return true;
    }

    @Override
    public Object getTreeElement() {
        return this.project;
    }

    @Override
    public void appendToMemento(IMemento parentMemento) {
        if (this.project != null) {
            IMemento memento = parentMemento.createChild(TreeElementStateProviderFactory.MEMENTO_TYPE_ELEMENT_PROJECT);
            memento.putString("name", this.project.getName());
        }
    }

    public String toString() {
        return "ProjectElementProvider [project=" + this.project + "]";
    }
}

