/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.operations.semanticTokens;

import java.net.URI;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.text.IDocument;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.LanguageServerWrapper;
import org.eclipse.lsp4e.LanguageServers;
import org.eclipse.lsp4e.internal.NullSafetyHelper;
import org.eclipse.lsp4j.SemanticTokens;
import org.eclipse.lsp4j.SemanticTokensLegend;
import org.eclipse.lsp4j.SemanticTokensParams;
import org.eclipse.lsp4j.SemanticTokensWithRegistrationOptions;
import org.eclipse.lsp4j.ServerCapabilities;

public final class SemanticTokensClient {
    public static final SemanticTokensClient DEFAULT = new SemanticTokensClient();

    private SemanticTokensClient() {
    }

    public <T> CompletableFuture<Optional<T>> requestFullSemanticTokens(IDocument document, BiFunction<@Nullable SemanticTokensLegend, SemanticTokens, T> callback) {
        LanguageServers.LanguageServerDocumentExecutor executor = (LanguageServers.LanguageServerDocumentExecutor)LanguageServers.forDocument(document).withFilter(serverCapabilities -> serverCapabilities.getSemanticTokensProvider() != null && LSPEclipseUtils.hasCapability(serverCapabilities.getSemanticTokensProvider().getFull()));
        URI uri = NullSafetyHelper.castNonNull(LSPEclipseUtils.toUri(document));
        SemanticTokensParams semanticTokensParams = new SemanticTokensParams();
        semanticTokensParams.setTextDocument(LSPEclipseUtils.toTextDocumentIdentifier(uri));
        return executor.computeFirst((w, ls) -> ls.getTextDocumentService().semanticTokensFull(semanticTokensParams).thenApply(semanticTokens -> callback.apply(this.getSemanticTokensLegend((LanguageServerWrapper)w), (SemanticTokens)semanticTokens)));
    }

    public @Nullable SemanticTokensLegend getSemanticTokensLegend(LanguageServerWrapper wrapper) {
        SemanticTokensWithRegistrationOptions semanticTokensProvider;
        ServerCapabilities serverCapabilities = wrapper.getServerCapabilities();
        if (serverCapabilities != null && (semanticTokensProvider = serverCapabilities.getSemanticTokensProvider()) != null) {
            return semanticTokensProvider.getLegend();
        }
        return null;
    }
}

