/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.ui.wizards;

import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.typed.BeanProperties;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.linuxtools.internal.docker.ui.wizards.LabelVariableModel;
import org.eclipse.linuxtools.internal.docker.ui.wizards.WizardMessages;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class ContainerLabelVariableDialog
extends Dialog {
    private final LabelVariableModel model;
    private final DataBindingContext dbc = new DataBindingContext();

    public ContainerLabelVariableDialog(Shell parentShell) {
        super(parentShell);
        this.model = new LabelVariableModel();
    }

    public ContainerLabelVariableDialog(Shell parentShell, LabelVariableModel selectedVariable) {
        super(parentShell);
        this.model = new LabelVariableModel(selectedVariable);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        shell.setText(WizardMessages.getString("ContainerLabelVariableDialog.title"));
    }

    protected Point getInitialSize() {
        return new Point(400, super.getInitialSize().y);
    }

    protected Button createButton(Composite parent, int id, String label, boolean defaultButton) {
        Button button = super.createButton(parent, id, label, defaultButton);
        if (id == 0) {
            button.setEnabled(false);
        }
        return button;
    }

    protected Control createDialogArea(Composite parent) {
        int COLUMNS = 2;
        Composite container = new Composite(parent, 0);
        GridDataFactory.fillDefaults().align(4, 4).span(2, 1).grab(true, true).applyTo((Control)container);
        GridLayoutFactory.fillDefaults().numColumns(2).margins(10, 10).applyTo(container);
        Label explanationLabel = new Label(container, 0);
        explanationLabel.setText(WizardMessages.getString("ContainerLabelVariableDialog.explanationLabel"));
        GridDataFactory.fillDefaults().align(4, 0x1000000).span(2, 1).grab(false, false).applyTo((Control)explanationLabel);
        Label variableNameLabel = new Label(container, 0);
        variableNameLabel.setText(WizardMessages.getString("ContainerLabelVariableDialog.nameLabel"));
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(false, false).applyTo((Control)variableNameLabel);
        Text variableNameText = new Text(container, 2048);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)variableNameText);
        Label variableValueLabel = new Label(container, 0);
        variableValueLabel.setText(WizardMessages.getString("ContainerLabelVariableDialog.valueLabel"));
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(false, false).applyTo((Control)variableValueLabel);
        Text variableValueText = new Text(container, 2048);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)variableValueText);
        Label errorMessageLabel = new Label(container, 0);
        GridDataFactory.fillDefaults().align(4, 0x1000000).span(2, 1).grab(true, false).applyTo((Control)errorMessageLabel);
        ISWTObservableValue variableNameObservable = WidgetProperties.text((int)24).observe((Widget)variableNameText);
        this.dbc.bindValue((IObservableValue)variableNameObservable, BeanProperties.value(LabelVariableModel.class, (String)"name").observe((Object)this.model));
        ISWTObservableValue variableValueObservable = WidgetProperties.text((int)24).observe((Widget)variableValueText);
        this.dbc.bindValue((IObservableValue)variableValueObservable, BeanProperties.value(LabelVariableModel.class, (String)"value").observe((Object)this.model));
        variableNameObservable.addValueChangeListener(this.onLabelVariableSettingsChanged());
        variableValueObservable.addValueChangeListener(this.onLabelVariableSettingsChanged());
        return container;
    }

    private IValueChangeListener onLabelVariableSettingsChanged() {
        return event -> this.validateInput();
    }

    private void validateInput() {
        String variableName = this.model.getName();
        if (variableName != null && !variableName.isEmpty()) {
            this.setOkButtonEnabled(true);
        }
    }

    private void setOkButtonEnabled(boolean enabled) {
        this.getButton(0).setEnabled(enabled);
    }

    public LabelVariableModel getLabelVariable() {
        return new LabelVariableModel(this.model.getName(), this.model.getValue());
    }
}

