/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.keyple.transaction;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.keyple.seproxy.SeReader;
import org.eclipse.keyple.seproxy.event.DefaultSelectionRequest;
import org.eclipse.keyple.seproxy.event.SelectionResponse;
import org.eclipse.keyple.seproxy.exception.KeypleReaderException;
import org.eclipse.keyple.seproxy.message.ProxyReader;
import org.eclipse.keyple.seproxy.message.SeRequest;
import org.eclipse.keyple.seproxy.message.SeRequestSet;
import org.eclipse.keyple.seproxy.message.SeResponse;
import org.eclipse.keyple.seproxy.message.SeResponseSet;
import org.eclipse.keyple.transaction.MatchingSe;
import org.eclipse.keyple.transaction.SeSelectionRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SeSelection {
    private static final Logger logger = LoggerFactory.getLogger(SeSelection.class);
    private final SeReader seReader;
    private List<MatchingSe> matchingSeList = new ArrayList<MatchingSe>();
    private SeRequestSet selectionRequestSet = new SeRequestSet(new LinkedHashSet<SeRequest>());
    private MatchingSe selectedSe;

    public SeSelection(SeReader seReader) {
        this.seReader = (ProxyReader)seReader;
    }

    public MatchingSe prepareSelection(SeSelectionRequest seSelectionRequest) {
        if (logger.isTraceEnabled()) {
            logger.trace("SELECTORREQUEST = {}, EXTRAINFO = {}", (Object)seSelectionRequest.getSelectionRequest(), (Object)seSelectionRequest.getSeSelector().getExtraInfo());
        }
        this.selectionRequestSet.add(seSelectionRequest.getSelectionRequest());
        MatchingSe matchingSe = null;
        try {
            Constructor<? extends MatchingSe> constructor = seSelectionRequest.getMatchingClass().getConstructor(seSelectionRequest.getSelectionClass());
            matchingSe = constructor.newInstance(seSelectionRequest);
            this.matchingSeList.add(matchingSe);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return matchingSe;
    }

    private boolean processSelection(SelectionResponse selectionResponse) {
        boolean selectionSuccessful = false;
        if (selectionResponse == null) {
            logger.error("selectionResponse shouldn't be null in processSelection.");
            return false;
        }
        for (MatchingSe matchingSe : this.matchingSeList) {
            matchingSe.reset();
        }
        Iterator<MatchingSe> matchingSeIterator = this.matchingSeList.iterator();
        for (SeResponse seResponse : selectionResponse.getSelectionSeResponseSet().getResponses()) {
            if (seResponse != null) {
                if (seResponse.getSelectionStatus() != null && seResponse.getSelectionStatus().hasMatched()) {
                    selectionSuccessful = true;
                    if (matchingSeIterator.hasNext()) {
                        MatchingSe matchingSe = matchingSeIterator.next();
                        matchingSe.setSelectionResponse(seResponse);
                        if (!matchingSe.isSelectable()) continue;
                        this.selectedSe = matchingSe;
                        continue;
                    }
                    throw new IllegalStateException("The number of selection responses exceeds the number of prepared selectors.");
                }
                if (!matchingSeIterator.hasNext()) {
                    throw new IllegalStateException("The number of selection responses exceeds the number of prepared selectors.");
                }
                matchingSeIterator.next();
                continue;
            }
            if (matchingSeIterator.hasNext()) {
                matchingSeIterator.next();
                continue;
            }
            throw new IllegalStateException("The number of selection responses exceeds the number of prepared selectors.");
        }
        return selectionSuccessful;
    }

    public boolean processDefaultSelection(SelectionResponse selectionResponse) {
        if (logger.isTraceEnabled()) {
            logger.trace("Process default SELECTIONRESPONSE ({} response(s))", (Object)selectionResponse.getSelectionSeResponseSet().getResponses().size());
        }
        return this.processSelection(selectionResponse);
    }

    public boolean processExplicitSelection() throws KeypleReaderException {
        if (logger.isTraceEnabled()) {
            logger.trace("Transmit SELECTIONREQUEST ({} request(s))", (Object)this.selectionRequestSet.getRequests().size());
        }
        SeResponseSet seResponseSet = ((ProxyReader)this.seReader).transmitSet(this.selectionRequestSet);
        return this.processSelection(new SelectionResponse(seResponseSet));
    }

    public MatchingSe getSelectedSe() {
        return this.selectedSe;
    }

    public List<MatchingSe> getMatchingSeList() {
        return this.matchingSeList;
    }

    public DefaultSelectionRequest getSelectionOperation() {
        return new DefaultSelectionRequest(this.selectionRequestSet);
    }
}

