package org.eclipse.incquery.viewers.runtime.model.patterns.util;

import org.eclipse.incquery.runtime.api.IMatchProcessor;
import org.eclipse.incquery.viewers.runtime.model.Edge;
import org.eclipse.incquery.viewers.runtime.model.patterns.Param2edgeMatch;
import org.eclipse.incquery.viewmodel.traceability.Trace;

/**
 * A match processor tailored for the org.eclipse.incquery.viewers.runtime.model.patterns.param2edge pattern.
 * 
 * Clients should derive an (anonymous) class that implements the abstract process().
 * 
 */
@SuppressWarnings("all")
public abstract class Param2edgeProcessor implements IMatchProcessor<Param2edgeMatch> {
  /**
   * Defines the action that is to be executed on each match.
   * @param pSource the value of pattern parameter source in the currently processed match
   * @param pTarget the value of pattern parameter target in the currently processed match
   * @param pTrace the value of pattern parameter trace in the currently processed match
   * @param pEdge the value of pattern parameter edge in the currently processed match
   * 
   */
  public abstract void process(final Object pSource, final Object pTarget, final Trace pTrace, final Edge pEdge);
  
  @Override
  public void process(final Param2edgeMatch match) {
    process(match.getSource(), match.getTarget(), match.getTrace(), match.getEdge());
  }
}
