/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.testing.ui.handlers;

import com.google.inject.Inject;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.log4j.Logger;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.ui.dialogs.WorkspaceResourceDialog;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.incquery.runtime.api.IPatternMatch;
import org.eclipse.incquery.runtime.api.IncQueryEngine;
import org.eclipse.incquery.runtime.api.IncQueryMatcher;
import org.eclipse.incquery.snapshot.EIQSnapshot.EIQSnapshotFactory;
import org.eclipse.incquery.snapshot.EIQSnapshot.IncQuerySnapshot;
import org.eclipse.incquery.testing.core.ModelLoadHelper;
import org.eclipse.incquery.testing.core.SnapshotHelper;
import org.eclipse.incquery.tooling.ui.queryexplorer.content.matcher.ObservablePatternMatcher;
import org.eclipse.incquery.tooling.ui.queryexplorer.content.matcher.ObservablePatternMatcherRoot;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.handlers.HandlerUtil;

public class SaveSnapshotHandler
extends AbstractHandler {
    @Inject
    SnapshotHelper helper;
    @Inject
    ModelLoadHelper loader;
    @Inject
    private Logger logger;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IStructuredSelection selection = (IStructuredSelection)HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection instanceof TreeSelection) {
            this.saveSnapshot((TreeSelection)selection, event);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void saveSnapshot(TreeSelection selection, ExecutionEvent event) {
        IncQuerySnapshot snapshot;
        IncQueryEngine engine;
        ArrayList<ObservablePatternMatcher> matchers;
        IEditorPart editor;
        block16: {
            block18: {
                Object obj;
                block17: {
                    obj = selection.getFirstElement();
                    editor = null;
                    matchers = new ArrayList<ObservablePatternMatcher>();
                    engine = null;
                    if (!(obj instanceof ObservablePatternMatcher)) break block17;
                    ObservablePatternMatcher observablePatternMatcher = (ObservablePatternMatcher)obj;
                    editor = observablePatternMatcher.getParent().getEditorPart();
                    matchers.add(observablePatternMatcher);
                    IncQueryMatcher matcher = observablePatternMatcher.getMatcher();
                    if (matcher == null) break block18;
                    engine = matcher.getEngine();
                    break block18;
                }
                if (obj instanceof ObservablePatternMatcherRoot) {
                    ObservablePatternMatcherRoot matcherRoot = (ObservablePatternMatcherRoot)obj;
                    editor = matcherRoot.getEditorPart();
                    if (matcherRoot.getMatchers().size() > 0) {
                        matchers.addAll(matcherRoot.getMatchers());
                        for (ObservablePatternMatcher obsMatcher : matcherRoot.getMatchers()) {
                            IncQueryMatcher matcher = obsMatcher.getMatcher();
                            if (matcher == null || matcher.getEngine() == null) continue;
                            engine = matcher.getEngine();
                            break;
                        }
                    }
                }
            }
            if (engine == null) {
                this.logger.error((Object)"Cannot save snapshot without IncQueryEngine!");
                return;
            }
            ResourceSet resourceSet = this.getResourceSetForNotifier(engine.getScope());
            if (resourceSet == null) {
                engine.getLogger().error((Object)"Cannot save snapshot, models not in ResourceSet!");
                return;
            }
            IFile snapshotFile = null;
            IFile[] files = WorkspaceResourceDialog.openFileSelection((Shell)HandlerUtil.getActiveShell((ExecutionEvent)event), (String)"Existing snapshot", (String)"Select existing EMF-IncQuery snapshot file (Cancel for new file)", (boolean)false, null, null);
            snapshot = null;
            if (files.length == 0) {
                snapshotFile = WorkspaceResourceDialog.openNewFile((Shell)HandlerUtil.getActiveShell((ExecutionEvent)event), (String)"New snapshot", (String)"Select EMF-IncQuery snapshot target file (.eiqsnapshot extension)", null, null);
                if (snapshotFile != null && !snapshotFile.exists()) {
                    snapshot = EIQSnapshotFactory.eINSTANCE.createIncQuerySnapshot();
                    Resource res = resourceSet.createResource(URI.createPlatformResourceURI((String)snapshotFile.getFullPath().toString(), (boolean)true));
                    res.getContents().add((Object)snapshot);
                    break block16;
                } else {
                    engine.getLogger().error((Object)"Selected file name must use .eiqsnapshot extension!");
                    return;
                }
            }
            snapshotFile = files[0];
            if (snapshotFile != null && snapshotFile.getFileExtension().equals("eiqsnapshot")) {
                snapshot = this.loader.loadExpectedResultsFromFile(resourceSet, snapshotFile);
                if (snapshot == null) {
                    engine.getLogger().error((Object)"Selected file does not contain snapshot!");
                    return;
                }
                if (!this.validateInputSpecification(engine, snapshot)) {
                    return;
                }
            } else {
                engine.getLogger().error((Object)"Selected file not .eiqsnapshot!");
                return;
            }
        }
        for (ObservablePatternMatcher matcher : matchers) {
            if (matcher.getMatcher() == null) continue;
            IPatternMatch filter = matcher.getMatcher().newMatch(matcher.getFilter());
            this.helper.saveMatchesToSnapshot(matcher.getMatcher(), filter, snapshot);
        }
        if (editor != null) {
            editor.doSave((IProgressMonitor)new NullProgressMonitor());
            return;
        }
        try {
            snapshot.eResource().save(null);
            return;
        }
        catch (IOException e) {
            engine.getLogger().error((Object)"Error during saving snapshot into file!", (Throwable)e);
        }
    }

    private boolean validateInputSpecification(IncQueryEngine engine, IncQuerySnapshot snapshot) {
        if (snapshot.getInputSpecification() != null) {
            Notifier root = this.helper.getEMFRootForSnapshot(snapshot);
            Notifier matcherRoot = engine.getScope();
            if (matcherRoot != root) {
                engine.getLogger().error((Object)("Existing snapshot model root (" + root + ") not equal to selected input (" + matcherRoot + ")!"));
                return false;
            }
            return true;
        }
        return true;
    }

    private ResourceSet getResourceSetForNotifier(Notifier notifier) {
        if (notifier instanceof EObject) {
            Resource resource = ((EObject)notifier).eResource();
            if (resource != null) {
                return resource.getResourceSet();
            }
        } else {
            if (notifier instanceof Resource) {
                return ((Resource)notifier).getResourceSet();
            }
            if (notifier instanceof ResourceSet) {
                return (ResourceSet)notifier;
            }
        }
        return null;
    }
}

