package org.eclipse.incquery.viewmodel.traceability.patterns.util;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.incquery.runtime.api.IncQueryEngine;
import org.eclipse.incquery.runtime.api.impl.BaseGeneratedEMFPQuery;
import org.eclipse.incquery.runtime.api.impl.BaseGeneratedEMFQuerySpecification;
import org.eclipse.incquery.runtime.emf.types.EClassTransitiveInstancesKey;
import org.eclipse.incquery.runtime.emf.types.EStructuralFeatureInstancesKey;
import org.eclipse.incquery.runtime.exception.IncQueryException;
import org.eclipse.incquery.runtime.matchers.psystem.PBody;
import org.eclipse.incquery.runtime.matchers.psystem.PVariable;
import org.eclipse.incquery.runtime.matchers.psystem.annotations.PAnnotation;
import org.eclipse.incquery.runtime.matchers.psystem.basicdeferred.Equality;
import org.eclipse.incquery.runtime.matchers.psystem.basicdeferred.ExportedParameter;
import org.eclipse.incquery.runtime.matchers.psystem.basicenumerables.TypeConstraint;
import org.eclipse.incquery.runtime.matchers.psystem.queries.PParameter;
import org.eclipse.incquery.runtime.matchers.psystem.queries.QueryInitializationException;
import org.eclipse.incquery.runtime.matchers.tuple.FlatTuple;
import org.eclipse.incquery.viewmodel.traceability.patterns.TraceMatch;
import org.eclipse.incquery.viewmodel.traceability.patterns.TraceMatcher;

/**
 * A pattern-specific query specification that can instantiate TraceMatcher in a type-safe way.
 * 
 * @see TraceMatcher
 * @see TraceMatch
 * 
 */
@SuppressWarnings("all")
public final class TraceQuerySpecification extends BaseGeneratedEMFQuerySpecification<TraceMatcher> {
  private TraceQuerySpecification() {
    super(GeneratedPQuery.INSTANCE);
  }
  
  /**
   * @return the singleton instance of the query specification
   * @throws IncQueryException if the pattern definition could not be loaded
   * 
   */
  public static TraceQuerySpecification instance() throws IncQueryException {
    try{
    	return LazyHolder.INSTANCE;
    } catch (ExceptionInInitializerError err) {
    	throw processInitializerError(err);
    }
  }
  
  @Override
  protected TraceMatcher instantiate(final IncQueryEngine engine) throws IncQueryException {
    return TraceMatcher.on(engine);
  }
  
  @Override
  public TraceMatch newEmptyMatch() {
    return TraceMatch.newEmptyMatch();
  }
  
  @Override
  public TraceMatch newMatch(final Object... parameters) {
    return TraceMatch.newMatch((java.lang.Object) parameters[0], (java.lang.String) parameters[1], (org.eclipse.emf.ecore.EObject) parameters[2], (org.eclipse.incquery.viewmodel.traceability.Trace) parameters[3], (java.lang.String) parameters[4]);
  }
  
  /**
   * Inner class allowing the singleton instance of {@link TraceQuerySpecification} to be created 
   * 	<b>not</b> at the class load time of the outer class, 
   * 	but rather at the first call to {@link TraceQuerySpecification#instance()}.
   * 
   * <p> This workaround is required e.g. to support recursion.
   * 
   */
  private static class LazyHolder {
    private final static TraceQuerySpecification INSTANCE = new TraceQuerySpecification();
    
    /**
     * Statically initializes the query specification <b>after</b> the field {@link #INSTANCE} is assigned.
     * This initialization order is required to support indirect recursion.
     * 
     * <p> The static initializer is defined using a helper field to work around limitations of the code generator.
     * 
     */
    private final static Object STATIC_INITIALIZER = ensureInitialized();
    
    public static Object ensureInitialized() {
      INSTANCE.ensureInitializedInternalSneaky();
      return null;					
    }
  }
  
  private static class GeneratedPQuery extends BaseGeneratedEMFPQuery {
    private final static TraceQuerySpecification.GeneratedPQuery INSTANCE = new GeneratedPQuery();
    
    @Override
    public String getFullyQualifiedName() {
      return "org.eclipse.incquery.viewmodel.traceability.patterns.trace";
    }
    
    @Override
    public List<String> getParameterNames() {
      return Arrays.asList("source","id","target","trace","traceabilityId");
    }
    
    @Override
    public List<PParameter> getParameters() {
      return Arrays.asList(new PParameter("source", "java.lang.Object"),new PParameter("id", "java.lang.String"),new PParameter("target", "org.eclipse.emf.ecore.EObject"),new PParameter("trace", "org.eclipse.incquery.viewmodel.traceability.Trace"),new PParameter("traceabilityId", "java.lang.String"));
    }
    
    @Override
    public Set<PBody> doGetContainedBodies() throws QueryInitializationException {
      Set<PBody> bodies = Sets.newLinkedHashSet();
      try {
      	{
      		PBody body = new PBody(this);
      		PVariable var_source = body.getOrCreateVariableByName("source");
      		PVariable var_id = body.getOrCreateVariableByName("id");
      		PVariable var_target = body.getOrCreateVariableByName("target");
      		PVariable var_trace = body.getOrCreateVariableByName("trace");
      		PVariable var_traceabilityId = body.getOrCreateVariableByName("traceabilityId");
      		PVariable var_traceability = body.getOrCreateVariableByName("traceability");
      		body.setSymbolicParameters(Arrays.<ExportedParameter>asList(
      		   new ExportedParameter(body, var_source, "source"),
      		   new ExportedParameter(body, var_id, "id"),
      		   new ExportedParameter(body, var_target, "target"),
      		   new ExportedParameter(body, var_trace, "trace"),
      		   new ExportedParameter(body, var_traceabilityId, "traceabilityId")
      		));
      		// 	Trace.params(trace, source)
      		new TypeConstraint(body, new FlatTuple(var_trace), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("http://org.eclipse.incquery/viewmodel/traceability/1.0", "Trace")));
      		PVariable var__virtual_0_ = body.getOrCreateVariableByName(".virtual{0}");
      		new TypeConstraint(body, new FlatTuple(var_trace, var__virtual_0_), new EStructuralFeatureInstancesKey(getFeatureLiteral("http://org.eclipse.incquery/viewmodel/traceability/1.0", "Trace", "params")));
      		new Equality(body, var__virtual_0_, var_source);
      		// 	Trace.targets(trace, target)
      		new TypeConstraint(body, new FlatTuple(var_trace), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("http://org.eclipse.incquery/viewmodel/traceability/1.0", "Trace")));
      		PVariable var__virtual_1_ = body.getOrCreateVariableByName(".virtual{1}");
      		new TypeConstraint(body, new FlatTuple(var_trace, var__virtual_1_), new EStructuralFeatureInstancesKey(getFeatureLiteral("http://org.eclipse.incquery/viewmodel/traceability/1.0", "Trace", "targets")));
      		new Equality(body, var__virtual_1_, var_target);
      		// 	Trace.id(trace,id)
      		new TypeConstraint(body, new FlatTuple(var_trace), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("http://org.eclipse.incquery/viewmodel/traceability/1.0", "Trace")));
      		PVariable var__virtual_2_ = body.getOrCreateVariableByName(".virtual{2}");
      		new TypeConstraint(body, new FlatTuple(var_trace, var__virtual_2_), new EStructuralFeatureInstancesKey(getFeatureLiteral("http://org.eclipse.incquery/viewmodel/traceability/1.0", "Trace", "id")));
      		new Equality(body, var__virtual_2_, var_id);
      		// 	Traceability.id(traceability,traceabilityId)
      		new TypeConstraint(body, new FlatTuple(var_traceability), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("http://org.eclipse.incquery/viewmodel/traceability/1.0", "Traceability")));
      		PVariable var__virtual_3_ = body.getOrCreateVariableByName(".virtual{3}");
      		new TypeConstraint(body, new FlatTuple(var_traceability, var__virtual_3_), new EStructuralFeatureInstancesKey(getFeatureLiteral("http://org.eclipse.incquery/viewmodel/traceability/1.0", "Traceability", "id")));
      		new Equality(body, var__virtual_3_, var_traceabilityId);
      		// 	Traceability.traces(traceability,trace)
      		new TypeConstraint(body, new FlatTuple(var_traceability), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("http://org.eclipse.incquery/viewmodel/traceability/1.0", "Traceability")));
      		PVariable var__virtual_4_ = body.getOrCreateVariableByName(".virtual{4}");
      		new TypeConstraint(body, new FlatTuple(var_traceability, var__virtual_4_), new EStructuralFeatureInstancesKey(getFeatureLiteral("http://org.eclipse.incquery/viewmodel/traceability/1.0", "Traceability", "traces")));
      		new Equality(body, var__virtual_4_, var_trace);
      		bodies.add(body);
      	}
      	{
      		PBody body = new PBody(this);
      		PVariable var_source = body.getOrCreateVariableByName("source");
      		PVariable var_id = body.getOrCreateVariableByName("id");
      		PVariable var_target = body.getOrCreateVariableByName("target");
      		PVariable var_trace = body.getOrCreateVariableByName("trace");
      		PVariable var_traceabilityId = body.getOrCreateVariableByName("traceabilityId");
      		PVariable var_traceability = body.getOrCreateVariableByName("traceability");
      		body.setSymbolicParameters(Arrays.<ExportedParameter>asList(
      		   new ExportedParameter(body, var_source, "source"),
      		   new ExportedParameter(body, var_id, "id"),
      		   new ExportedParameter(body, var_target, "target"),
      		   new ExportedParameter(body, var_trace, "trace"),
      		   new ExportedParameter(body, var_traceabilityId, "traceabilityId")
      		));
      		// 	Trace.objects(trace, source)
      		new TypeConstraint(body, new FlatTuple(var_trace), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("http://org.eclipse.incquery/viewmodel/traceability/1.0", "Trace")));
      		PVariable var__virtual_0_ = body.getOrCreateVariableByName(".virtual{0}");
      		new TypeConstraint(body, new FlatTuple(var_trace, var__virtual_0_), new EStructuralFeatureInstancesKey(getFeatureLiteral("http://org.eclipse.incquery/viewmodel/traceability/1.0", "Trace", "objects")));
      		new Equality(body, var__virtual_0_, var_source);
      		// 	Trace.targets(trace, target)
      		new TypeConstraint(body, new FlatTuple(var_trace), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("http://org.eclipse.incquery/viewmodel/traceability/1.0", "Trace")));
      		PVariable var__virtual_1_ = body.getOrCreateVariableByName(".virtual{1}");
      		new TypeConstraint(body, new FlatTuple(var_trace, var__virtual_1_), new EStructuralFeatureInstancesKey(getFeatureLiteral("http://org.eclipse.incquery/viewmodel/traceability/1.0", "Trace", "targets")));
      		new Equality(body, var__virtual_1_, var_target);
      		// 	Trace.id(trace,id)
      		new TypeConstraint(body, new FlatTuple(var_trace), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("http://org.eclipse.incquery/viewmodel/traceability/1.0", "Trace")));
      		PVariable var__virtual_2_ = body.getOrCreateVariableByName(".virtual{2}");
      		new TypeConstraint(body, new FlatTuple(var_trace, var__virtual_2_), new EStructuralFeatureInstancesKey(getFeatureLiteral("http://org.eclipse.incquery/viewmodel/traceability/1.0", "Trace", "id")));
      		new Equality(body, var__virtual_2_, var_id);
      		// 	Traceability.id(traceability,traceabilityId)
      		new TypeConstraint(body, new FlatTuple(var_traceability), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("http://org.eclipse.incquery/viewmodel/traceability/1.0", "Traceability")));
      		PVariable var__virtual_3_ = body.getOrCreateVariableByName(".virtual{3}");
      		new TypeConstraint(body, new FlatTuple(var_traceability, var__virtual_3_), new EStructuralFeatureInstancesKey(getFeatureLiteral("http://org.eclipse.incquery/viewmodel/traceability/1.0", "Traceability", "id")));
      		new Equality(body, var__virtual_3_, var_traceabilityId);
      		// 	Traceability.traces(traceability,trace)
      		new TypeConstraint(body, new FlatTuple(var_traceability), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("http://org.eclipse.incquery/viewmodel/traceability/1.0", "Traceability")));
      		PVariable var__virtual_4_ = body.getOrCreateVariableByName(".virtual{4}");
      		new TypeConstraint(body, new FlatTuple(var_traceability, var__virtual_4_), new EStructuralFeatureInstancesKey(getFeatureLiteral("http://org.eclipse.incquery/viewmodel/traceability/1.0", "Traceability", "traces")));
      		new Equality(body, var__virtual_4_, var_trace);
      		bodies.add(body);
      	}
      	                {
      		PAnnotation annotation = new PAnnotation("QueryExplorer");
      		annotation.addAttribute("checked", false);
      		addAnnotation(annotation);
      	}
      	// to silence compiler error
      	if (false) throw new IncQueryException("Never", "happens");
      } catch (IncQueryException ex) {
      	throw processDependencyException(ex);
      }
      return bodies;
    }
  }
}
