/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.proton.codec;

import java.util.Arrays;
import java.util.Collection;
import org.apache.qpid.proton.codec.AbstractPrimitiveType;
import org.apache.qpid.proton.codec.DecoderImpl;
import org.apache.qpid.proton.codec.EncoderImpl;
import org.apache.qpid.proton.codec.FixedSizePrimitiveTypeEncoding;
import org.apache.qpid.proton.codec.PrimitiveTypeEncoding;
import org.apache.qpid.proton.codec.TypeEncoding;

public final class BooleanType
extends AbstractPrimitiveType<Boolean> {
    private static final byte BYTE_0 = 0;
    private static final byte BYTE_1 = 1;
    private BooleanEncoding _trueEncoder;
    private BooleanEncoding _falseEncoder;
    private BooleanEncoding _booleanEncoder;

    BooleanType(EncoderImpl encoder, DecoderImpl decoder) {
        this._trueEncoder = new TrueEncoding(encoder, decoder);
        this._falseEncoder = new FalseEncoding(encoder, decoder);
        this._booleanEncoder = new AllBooleanEncoding(encoder, decoder);
        encoder.register(Boolean.class, this);
        decoder.register(this);
    }

    @Override
    public Class<Boolean> getTypeClass() {
        return Boolean.class;
    }

    public BooleanEncoding getEncoding(Boolean val) {
        return val != false ? this._trueEncoder : this._falseEncoder;
    }

    public BooleanEncoding getEncoding(boolean val) {
        return val ? this._trueEncoder : this._falseEncoder;
    }

    public void writeValue(boolean val) {
        this.getEncoding(val).write(val);
    }

    @Override
    public BooleanEncoding getCanonicalEncoding() {
        return this._booleanEncoder;
    }

    @Override
    public Collection<BooleanEncoding> getAllEncodings() {
        return Arrays.asList(this._trueEncoder, this._falseEncoder, this._booleanEncoder);
    }

    private class AllBooleanEncoding
    extends FixedSizePrimitiveTypeEncoding<Boolean>
    implements BooleanEncoding {
        public AllBooleanEncoding(EncoderImpl encoder, DecoderImpl decoder) {
            super(encoder, decoder);
        }

        @Override
        public BooleanType getType() {
            return BooleanType.this;
        }

        @Override
        protected int getFixedSize() {
            return 1;
        }

        @Override
        public byte getEncodingCode() {
            return 86;
        }

        @Override
        public void writeValue(Boolean val) {
            this.getEncoder().writeRaw(val != false ? (byte)1 : 0);
        }

        @Override
        public void write(boolean val) {
            this.writeConstructor();
            this.getEncoder().writeRaw(val ? (byte)1 : 0);
        }

        @Override
        public void writeValue(boolean b) {
            this.getEncoder().writeRaw(b ? (byte)1 : 0);
        }

        @Override
        public boolean readPrimitiveValue() {
            return this.getDecoder().readRawByte() != 0;
        }

        @Override
        public boolean encodesSuperset(TypeEncoding<Boolean> encoding) {
            return this.getType() == encoding.getType();
        }

        @Override
        public Boolean readValue() {
            return this.readPrimitiveValue() ? Boolean.TRUE : Boolean.FALSE;
        }

        @Override
        public boolean encodesJavaPrimitive() {
            return true;
        }
    }

    private class FalseEncoding
    extends FixedSizePrimitiveTypeEncoding<Boolean>
    implements BooleanEncoding {
        public FalseEncoding(EncoderImpl encoder, DecoderImpl decoder) {
            super(encoder, decoder);
        }

        @Override
        protected int getFixedSize() {
            return 0;
        }

        @Override
        public byte getEncodingCode() {
            return 66;
        }

        @Override
        public BooleanType getType() {
            return BooleanType.this;
        }

        @Override
        public void writeValue(Boolean val) {
        }

        @Override
        public void write(boolean b) {
            this.writeConstructor();
        }

        @Override
        public void writeValue(boolean b) {
        }

        @Override
        public boolean readPrimitiveValue() {
            return false;
        }

        @Override
        public boolean encodesSuperset(TypeEncoding<Boolean> encoding) {
            return encoding == this;
        }

        @Override
        public Boolean readValue() {
            return Boolean.FALSE;
        }

        @Override
        public boolean encodesJavaPrimitive() {
            return true;
        }
    }

    private class TrueEncoding
    extends FixedSizePrimitiveTypeEncoding<Boolean>
    implements BooleanEncoding {
        public TrueEncoding(EncoderImpl encoder, DecoderImpl decoder) {
            super(encoder, decoder);
        }

        @Override
        protected int getFixedSize() {
            return 0;
        }

        @Override
        public byte getEncodingCode() {
            return 65;
        }

        @Override
        public BooleanType getType() {
            return BooleanType.this;
        }

        @Override
        public void writeValue(Boolean val) {
        }

        @Override
        public void write(boolean b) {
            this.writeConstructor();
        }

        @Override
        public void writeValue(boolean b) {
        }

        @Override
        public boolean encodesSuperset(TypeEncoding<Boolean> encoding) {
            return encoding == this;
        }

        @Override
        public Boolean readValue() {
            return Boolean.TRUE;
        }

        @Override
        public boolean readPrimitiveValue() {
            return true;
        }

        @Override
        public boolean encodesJavaPrimitive() {
            return true;
        }
    }

    public static interface BooleanEncoding
    extends PrimitiveTypeEncoding<Boolean> {
        public void write(boolean var1);

        @Override
        public void writeValue(boolean var1);

        public boolean readPrimitiveValue();
    }
}

