/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.VertxException;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.User;
import io.vertx.ext.auth.authentication.Credentials;
import io.vertx.ext.auth.otp.OtpCredentials;
import io.vertx.ext.auth.otp.OtpKey;
import io.vertx.ext.auth.otp.OtpKeyGenerator;
import io.vertx.ext.auth.otp.hotp.HotpAuth;
import io.vertx.ext.web.Route;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.Session;
import io.vertx.ext.web.handler.HttpException;
import io.vertx.ext.web.handler.OtpAuthHandler;
import io.vertx.ext.web.handler.impl.AuthenticationHandlerImpl;
import io.vertx.ext.web.impl.OrderListener;

public class HotpAuthHandlerImpl
extends AuthenticationHandlerImpl<HotpAuth>
implements OtpAuthHandler,
OrderListener {
    private final OtpKeyGenerator otpKeyGen;
    private String verifyUrl;
    private String issuer;
    private String label;
    private int order = -1;
    private Route register = null;
    private Route verify = null;

    public HotpAuthHandlerImpl(HotpAuth totp, OtpKeyGenerator otpKeyGen) {
        super(totp, "hotp");
        this.otpKeyGen = otpKeyGen;
    }

    @Override
    public void authenticate(RoutingContext ctx, Handler<AsyncResult<User>> handler) {
        if (this.verify == null) {
            handler.handle(Future.failedFuture(new HttpException(500, (Throwable)new IllegalStateException("No callback mounted!"))));
            return;
        }
        User user = ctx.user();
        if (user == null) {
            handler.handle(Future.failedFuture(new HttpException(401)));
        } else {
            Boolean userOtp = (Boolean)user.get("mfa");
            if (userOtp == null || !userOtp.booleanValue()) {
                if (this.verifyUrl == null) {
                    handler.handle(Future.failedFuture(new HttpException(401, "User HOTP verification missing")));
                } else {
                    Session session = ctx.session();
                    if (session != null) {
                        String uri = ctx.request().uri();
                        session.put("redirect_uri", uri);
                    }
                    handler.handle(Future.failedFuture(new HttpException(302, this.verifyUrl)));
                }
            } else {
                handler.handle(Future.succeededFuture(user));
            }
        }
    }

    @Override
    public OtpAuthHandler verifyUrl(String verifyUrl) {
        this.verifyUrl = verifyUrl;
        return this;
    }

    @Override
    public OtpAuthHandler issuer(String issuer) {
        this.issuer = issuer;
        return this;
    }

    @Override
    public OtpAuthHandler label(String label) {
        this.label = label;
        return this;
    }

    @Override
    public OtpAuthHandler setupRegisterCallback(Route route) {
        this.register = route;
        if (this.order != -1) {
            this.mountRegister();
        }
        return this;
    }

    @Override
    public OtpAuthHandler setupCallback(Route route) {
        this.verify = route;
        if (this.order != -1) {
            this.mountVerify();
        }
        return this;
    }

    @Override
    public void onOrder(int order) {
        this.order = order;
        if (this.register != null) {
            this.mountRegister();
        }
        if (this.verify != null) {
            this.mountVerify();
        }
    }

    private void mountRegister() {
        this.register.method(HttpMethod.POST).order(this.order - 1).handler(ctx -> {
            User user = ctx.user();
            if (user == null || user.get("username") == null) {
                ctx.fail(new VertxException("User object misses 'username' attribute", true));
                return;
            }
            OtpKey key = this.otpKeyGen.generate();
            ((HotpAuth)this.authProvider).createAuthenticator((String)user.get("username"), key).onFailure(ctx::fail).onSuccess(authenticator -> ctx.json(new JsonObject().put("issuer", this.issuer).put("label", this.label).put("url", ((HotpAuth)this.authProvider).generateUri(key, this.issuer, (String)user.get("username"), this.label))));
        });
    }

    private void mountVerify() {
        this.verify.method(HttpMethod.POST).order(this.order - 1).handler(ctx -> {
            User user = ctx.user();
            if (user == null || user.get("username") == null) {
                ctx.fail(new VertxException("User object misses 'username' attribute", true));
                return;
            }
            if (ctx.request().getParam("code") == null) {
                ctx.fail(new HttpException(400, "Missing 'code' form attribute"));
                return;
            }
            ((HotpAuth)this.authProvider).authenticate((Credentials)new OtpCredentials((String)user.get("username"), ctx.request().getParam("code"))).onSuccess(newUser -> {
                user.principal().mergeIn(newUser.principal());
                user.attributes().mergeIn(newUser.attributes());
                user.attributes().put("mfa", "hotp");
                String redirect = "/";
                Session session = ctx.session();
                if (session != null) {
                    session.regenerateId();
                    String back = (String)session.get("redirect_uri");
                    if (back != null) {
                        redirect = back;
                    }
                }
                ctx.redirect(redirect);
            }).onFailure(err -> ctx.fail(401, (Throwable)err));
        });
    }
}

