/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.kafka.client.serialization;

import io.quarkus.kafka.client.serialization.JsonbProducer;
import jakarta.json.bind.Jsonb;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import org.apache.kafka.common.serialization.Serializer;

public class JsonbSerializer<T>
implements Serializer<T> {
    public static final String NULL_AS_NULL_CONFIG = "json.serialize.null-as-null";
    private final Jsonb jsonb;
    private final boolean jsonbNeedsClosing;
    private boolean nullAsNull = false;

    public JsonbSerializer() {
        this(JsonbProducer.get(), true);
    }

    public JsonbSerializer(Jsonb jsonb) {
        this(jsonb, false);
    }

    private JsonbSerializer(Jsonb jsonb, boolean jsonbNeedsClosing) {
        this.jsonb = jsonb;
        this.jsonbNeedsClosing = jsonbNeedsClosing;
    }

    @Override
    public void configure(Map<String, ?> configs, boolean isKey) {
        if (configs.containsKey(NULL_AS_NULL_CONFIG) && Boolean.parseBoolean((String)configs.get(NULL_AS_NULL_CONFIG))) {
            this.nullAsNull = true;
        }
    }

    @Override
    public byte[] serialize(String topic, T data) {
        byte[] byArray;
        if (this.nullAsNull && data == null) {
            return null;
        }
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        try {
            this.jsonb.toJson(data, (OutputStream)output);
            byArray = output.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    output.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        output.close();
        return byArray;
    }

    @Override
    public void close() {
        if (!this.jsonbNeedsClosing) {
            return;
        }
        try {
            this.jsonb.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

