/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logmanager;

import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.Set;
import org.jboss.logmanager.EmbeddedConfigurator;
import org.jboss.logmanager.Level;
import org.jboss.logmanager.Logger;
import org.jboss.logmanager.LoggerNode;

public final class LogContext {
    static final EmbeddedConfigurator CONFIGURATOR = LogContext.getConfigurator();
    private static final LogContext INSTANCE = new LogContext();
    private final LoggerNode rootLogger;
    private static final HashMap<String, java.util.logging.Level> LEVEL_MAP;
    private final Set<AutoCloseable> closeHandlers;
    final Object treeLock = new Object();

    private static void add(Map<String, java.util.logging.Level> map, java.util.logging.Level level) {
        map.put(level.getName().toUpperCase(Locale.US), level);
    }

    LogContext() {
        this.rootLogger = new LoggerNode(this);
        this.closeHandlers = new LinkedHashSet<AutoCloseable>();
    }

    private static LogContext create() {
        return new LogContext();
    }

    public <V> V getAttachment(Logger.AttachmentKey<V> key) {
        return this.rootLogger.getAttachment(key);
    }

    public <V> V attach(Logger.AttachmentKey<V> key, V value) throws SecurityException {
        return this.rootLogger.attach(key, value);
    }

    public <V> V attachIfAbsent(Logger.AttachmentKey<V> key, V value) throws SecurityException {
        return this.rootLogger.attachIfAbsent(key, value);
    }

    public <V> V detach(Logger.AttachmentKey<V> key) throws SecurityException {
        return this.rootLogger.detach(key);
    }

    public static LogContext getLogContext() {
        return LogContext.getInstance();
    }

    public Logger getLogger(String name) {
        return this.rootLogger.getOrCreate(name).createLogger();
    }

    public Logger getLoggerIfExists(String name) {
        LoggerNode node = this.rootLogger.getIfExists(name);
        return node == null ? null : node.createLogger();
    }

    public <V> V getAttachment(String loggerName, Logger.AttachmentKey<V> key) {
        LoggerNode node = this.rootLogger.getIfExists(loggerName);
        if (node == null) {
            return null;
        }
        return node.getAttachment(key);
    }

    public java.util.logging.Level getLevelForName(String name) throws IllegalArgumentException {
        java.util.logging.Level level;
        if (name != null && (level = LEVEL_MAP.get(name)) != null) {
            return level;
        }
        throw new IllegalArgumentException("Unknown level \"" + name + "\"");
    }

    public static LogContext getInstance() {
        return INSTANCE;
    }

    static EmbeddedConfigurator getConfigurator() {
        ServiceLoader<EmbeddedConfigurator> configLoader = ServiceLoader.load(EmbeddedConfigurator.class, LogContext.class.getClassLoader());
        Iterator<EmbeddedConfigurator> iterator = configLoader.iterator();
        while (true) {
            try {
                if (!iterator.hasNext()) {
                    return EmbeddedConfigurator.EMPTY;
                }
                return iterator.next();
            }
            catch (RuntimeException | ServiceConfigurationError e) {
                System.err.print("Warning: failed to load configurator: ");
                e.printStackTrace(System.err);
                continue;
            }
            break;
        }
    }

    public Enumeration<String> getLoggerNames() {
        final ArrayDeque<Iterator<LoggerNode>> nodeStack = new ArrayDeque<Iterator<LoggerNode>>();
        nodeStack.add(Collections.singleton(this.rootLogger).iterator());
        return new Enumeration<String>(){
            LoggerNode next;

            @Override
            public boolean hasMoreElements() {
                if (this.next != null) {
                    return true;
                }
                while (!nodeStack.isEmpty()) {
                    Iterator itr = (Iterator)nodeStack.peekFirst();
                    if (!itr.hasNext()) {
                        nodeStack.pollFirst();
                        continue;
                    }
                    LoggerNode node = (LoggerNode)itr.next();
                    nodeStack.addLast(node.getChildren().iterator());
                    if (!node.hasLogger()) continue;
                    this.next = node;
                    return true;
                }
                return false;
            }

            @Override
            public String nextElement() {
                if (!this.hasMoreElements()) {
                    throw new NoSuchElementException();
                }
                try {
                    String string = this.next.getFullName();
                    return string;
                }
                finally {
                    this.next = null;
                }
            }
        };
    }

    static {
        HashMap<String, java.util.logging.Level> map = new HashMap<String, java.util.logging.Level>();
        LogContext.add(map, java.util.logging.Level.OFF);
        LogContext.add(map, java.util.logging.Level.ALL);
        LogContext.add(map, java.util.logging.Level.SEVERE);
        LogContext.add(map, java.util.logging.Level.WARNING);
        LogContext.add(map, java.util.logging.Level.CONFIG);
        LogContext.add(map, java.util.logging.Level.INFO);
        LogContext.add(map, java.util.logging.Level.FINE);
        LogContext.add(map, java.util.logging.Level.FINER);
        LogContext.add(map, java.util.logging.Level.FINEST);
        LogContext.add(map, Level.FATAL);
        LogContext.add(map, Level.ERROR);
        LogContext.add(map, Level.WARN);
        LogContext.add(map, Level.INFO);
        LogContext.add(map, Level.DEBUG);
        LogContext.add(map, Level.TRACE);
        LEVEL_MAP = map;
    }
}

