/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.model.jackson;

import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import com.fasterxml.jackson.databind.deser.ResolvableDeserializer;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TreeTraversingParser;
import com.fasterxml.jackson.databind.util.NameTransformer;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class JsonUnwrappedDeserializer<T>
extends JsonDeserializer<T>
implements ContextualDeserializer {
    private static JsonUnwrapped cancelUnwrappedAnnotation;
    private JsonDeserializer<T> beanDeserializer;
    private Set<String> ownPropertyNames;
    private String unwrappedPropertyName;
    private NameTransformer nameTransformer;

    public JsonUnwrappedDeserializer() {
    }

    public JsonUnwrappedDeserializer(DeserializationContext deserializationContext) throws JsonMappingException {
        JavaType type = deserializationContext.getContextualType();
        BeanDescription description = deserializationContext.getConfig().introspect(type);
        JsonUnwrapped[] tempUnwrappedAnnotation = new JsonUnwrapped[]{null};
        List unwrappedProperties = description.findProperties().stream().filter(prop -> Arrays.asList(prop.getConstructorParameter(), prop.getMutator(), prop.getField()).stream().filter(Objects::nonNull).anyMatch(member -> {
            JsonUnwrapped unwrappedAnnotation = member.getAnnotation(JsonUnwrapped.class);
            if (unwrappedAnnotation != null) {
                tempUnwrappedAnnotation[0] = unwrappedAnnotation;
                member.getAllAnnotations().add(cancelUnwrappedAnnotation);
            }
            return unwrappedAnnotation != null;
        })).collect(Collectors.toList());
        if (unwrappedProperties.isEmpty()) {
            throw new UnsupportedOperationException("@JsonUnwrapped properties not found in " + type.getTypeName());
        }
        if (unwrappedProperties.size() > 1) {
            throw new UnsupportedOperationException("Multiple @JsonUnwrapped properties found in " + type.getTypeName());
        }
        BeanPropertyDefinition unwrappedProperty = (BeanPropertyDefinition)unwrappedProperties.get(0);
        this.nameTransformer = NameTransformer.simpleTransformer(tempUnwrappedAnnotation[0].prefix(), tempUnwrappedAnnotation[0].suffix());
        this.unwrappedPropertyName = unwrappedProperty.getName();
        this.ownPropertyNames = description.findProperties().stream().map(BeanPropertyDefinition::getName).collect(Collectors.toSet());
        this.ownPropertyNames.remove(this.unwrappedPropertyName);
        this.ownPropertyNames.removeAll(description.getIgnoredPropertyNames());
        JsonDeserializer<Object> rawBeanDeserializer = deserializationContext.getFactory().createBeanDeserializer(deserializationContext, type, description);
        ((ResolvableDeserializer)((Object)rawBeanDeserializer)).resolve(deserializationContext);
        this.beanDeserializer = rawBeanDeserializer;
    }

    @Override
    public JsonDeserializer<?> createContextual(DeserializationContext deserializationContext, BeanProperty beanProperty) throws JsonMappingException {
        return new JsonUnwrappedDeserializer<T>(deserializationContext);
    }

    @Override
    public T deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        ObjectNode node = (ObjectNode)jsonParser.readValueAsTree();
        ObjectNode ownNode = deserializationContext.getNodeFactory().objectNode();
        ObjectNode unwrappedNode = deserializationContext.getNodeFactory().objectNode();
        node.fields().forEachRemaining(entry -> {
            String key = (String)entry.getKey();
            JsonNode value = (JsonNode)entry.getValue();
            String transformed = this.nameTransformer.reverse(key);
            if (transformed != null && !this.ownPropertyNames.contains(key)) {
                unwrappedNode.replace(transformed, value);
            } else {
                ownNode.replace(key, value);
            }
        });
        ownNode.replace(this.unwrappedPropertyName, unwrappedNode);
        try (TreeTraversingParser syntheticParser = new TreeTraversingParser(ownNode, jsonParser.getCodec());){
            syntheticParser.nextToken();
            T t = this.beanDeserializer.deserialize(syntheticParser, deserializationContext);
            return t;
        }
    }

    static {
        try {
            cancelUnwrappedAnnotation = CancelUnwrapped.class.getField("dummy").getAnnotation(JsonUnwrapped.class);
        }
        catch (NoSuchFieldException ex) {
            throw new RuntimeException(ex);
        }
    }

    private static class CancelUnwrapped {
        @JsonUnwrapped(enabled=false)
        public Object dummy;

        private CancelUnwrapped() {
        }
    }
}

