/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.util;

import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.hono.util.KubernetesContainerUtil;
import org.eclipse.hono.util.Pair;
import org.eclipse.hono.util.Strings;

public class CommandConstants {
    public static final String COMMAND_ENDPOINT = "command";
    public static final String COMMAND_ENDPOINT_SHORT = "c";
    public static final String COMMAND_RESPONSE_ENDPOINT = "command_response";
    public static final String COMMAND_RESPONSE_ENDPOINT_SHORT = "cr";
    public static final String INTERNAL_COMMAND_ENDPOINT = "command_internal";
    public static final String NORTHBOUND_COMMAND_REQUEST_ENDPOINT = "command";
    public static final String NORTHBOUND_COMMAND_RESPONSE_ENDPOINT = "command_response";
    public static final String COMMAND_RESPONSE_REQUEST_PART = "req";
    public static final String COMMAND_RESPONSE_REQUEST_PART_SHORT = "q";
    public static final String COMMAND_RESPONSE_RESPONSE_PART = "res";
    public static final String COMMAND_RESPONSE_RESPONSE_PART_SHORT = "s";
    public static final String CONTENT_TYPE_DELIVERY_FAILURE_NOTIFICATION = "application/vnd.eclipse-hono-delivery-failure-notification+json";
    public static final String MSG_PROPERTY_ADAPTER_INSTANCE_ID = "adapter_instance_id";
    public static final String MSG_PROPERTY_DEVICE_TTD = "ttd";
    public static final String INTERNAL_COMMAND_SPAN_OPERATION_NAME = "delegate Command request";
    public static final int TOPIC_POSITION_RESPONSE_STATUS = 5;
    public static final int TOPIC_POSITION_RESPONSE_REQ_ID = 4;
    private static final Pattern KUBERNETES_ADAPTER_INSTANCE_ID_PATTERN = Pattern.compile("^(.*)_([0-9a-f]{12})_\\d+$");

    private CommandConstants() {
    }

    public static boolean isCommandEndpoint(String endpoint) {
        return "command".equals(endpoint) || COMMAND_ENDPOINT_SHORT.equals(endpoint);
    }

    public static boolean isNorthboundCommandResponseEndpoint(String endpoint) {
        return "command_response".equals(endpoint);
    }

    public static String getNewAdapterInstanceId(String adapterName, int counter) {
        String k8sContainerId = KubernetesContainerUtil.getContainerId();
        if (k8sContainerId == null || k8sContainerId.length() < 12) {
            return CommandConstants.getNewAdapterInstanceIdForNonK8sEnv(adapterName);
        }
        String prefix = System.getenv("HOSTNAME");
        if (Strings.isNullOrEmpty(prefix)) {
            prefix = adapterName;
        }
        return CommandConstants.getNewAdapterInstanceIdForK8sEnv(prefix, k8sContainerId, counter);
    }

    public static String getNewAdapterInstanceIdForNonK8sEnv(String adapterName) {
        String prefix = Strings.isNullOrEmpty(adapterName) ? "" : adapterName.replaceAll("[^a-zA-Z0-9._-]", "") + "-";
        return prefix + UUID.randomUUID();
    }

    public static String getNewAdapterInstanceIdForK8sEnv(String podName, String containerId, int counter) {
        Objects.requireNonNull(containerId);
        String podNameToUse = Optional.ofNullable(podName).map(p -> p.replaceAll("[^a-zA-Z0-9._-]", "")).orElse("");
        return String.format("%s_%s_%d", podNameToUse, containerId.substring(0, 12), counter);
    }

    public static Pair<String, String> getK8sPodNameAndContainerIdFromAdapterInstanceId(String adapterInstanceId) {
        Objects.requireNonNull(adapterInstanceId);
        Matcher matcher = KUBERNETES_ADAPTER_INSTANCE_ID_PATTERN.matcher(adapterInstanceId);
        if (!matcher.matches()) {
            return null;
        }
        return Pair.of(matcher.group(1), matcher.group(2));
    }
}

