/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.context;

import io.smallrye.context.CompletableFutureWrapper;
import io.smallrye.context.SmallRyeThreadContext;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Supplier;

public class Jdk12CompletableFutureWrapper<T>
extends CompletableFutureWrapper<T> {
    public Jdk12CompletableFutureWrapper(SmallRyeThreadContext context, CompletableFuture<T> f, Executor executor, int flags) {
        super(context, f, executor, flags);
    }

    @Override
    public <U> CompletableFuture<U> newIncompleteFuture() {
        CompletableFuture ret = new CompletableFuture();
        return this.context.withContextCapture(ret, this.executor, this.flags);
    }

    @Override
    public Executor defaultExecutor() {
        return this.executor;
    }

    @Override
    public CompletableFuture<T> copy() {
        return this.context.withContextCapture(this.f.copy(), this.executor, this.flags);
    }

    @Override
    public CompletionStage<T> minimalCompletionStage() {
        return this.context.withContextCapture(this.f.minimalCompletionStage());
    }

    @Override
    public CompletableFuture<T> completeAsync(Supplier<? extends T> supplier) {
        return this.context.withContextCapture(this.f.completeAsync(this.context.contextualSupplierUnlessContextualized(supplier), this.executor), this.executor, this.flags);
    }

    @Override
    public CompletableFuture<T> completeAsync(Supplier<? extends T> supplier, Executor executor) {
        return this.context.withContextCapture(this.f.completeAsync(this.context.contextualSupplierUnlessContextualized(supplier), executor), this.executor, this.flags);
    }

    @Override
    public CompletableFuture<T> orTimeout(long timeout, TimeUnit unit) {
        return this.context.withContextCapture(this.f.orTimeout(timeout, unit), this.executor, this.flags);
    }

    @Override
    public CompletableFuture<T> completeOnTimeout(T value, long timeout, TimeUnit unit) {
        return this.context.withContextCapture(this.f.completeOnTimeout(value, timeout, unit), this.executor, this.flags);
    }

    @Override
    public CompletableFuture<T> exceptionallyAsync(Function<Throwable, ? extends T> fn) {
        this.checkDefaultExecutor();
        return this.context.withContextCapture(this.f.exceptionallyAsync((Function)this.context.contextualFunctionUnlessContextualized(fn), this.executor), this.executor, this.flags);
    }

    @Override
    public CompletableFuture<T> exceptionallyAsync(Function<Throwable, ? extends T> fn, Executor executor) {
        return this.context.withContextCapture(this.f.exceptionallyAsync((Function)this.context.contextualFunctionUnlessContextualized(fn), executor), this.executor, this.flags);
    }

    @Override
    public CompletableFuture<T> exceptionallyCompose(Function<Throwable, ? extends CompletionStage<T>> fn) {
        return this.context.withContextCapture(this.f.exceptionallyCompose((Function)this.context.contextualFunctionUnlessContextualized(fn)), this.executor, this.flags);
    }

    @Override
    public CompletableFuture<T> exceptionallyComposeAsync(Function<Throwable, ? extends CompletionStage<T>> fn) {
        this.checkDefaultExecutor();
        return this.context.withContextCapture(this.f.exceptionallyComposeAsync((Function)this.context.contextualFunctionUnlessContextualized(fn), this.executor), this.executor, this.flags);
    }

    @Override
    public CompletableFuture<T> exceptionallyComposeAsync(Function<Throwable, ? extends CompletionStage<T>> fn, Executor executor) {
        return this.context.withContextCapture(this.f.exceptionallyComposeAsync((Function)this.context.contextualFunctionUnlessContextualized(fn), executor), this.executor, this.flags);
    }
}

