/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.groups;

import io.smallrye.common.annotation.CheckReturnValue;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.infrastructure.Infrastructure;
import io.smallrye.mutiny.operators.multi.MultiCombineLatestOp;
import io.smallrye.mutiny.operators.multi.MultiZipOp;
import java.util.List;
import java.util.function.Function;
import org.reactivestreams.Publisher;

public class MultiItemCombineIterable {
    private boolean collectFailures;
    private boolean latest;
    private final Iterable<? extends Publisher<?>> iterable;

    public MultiItemCombineIterable(Iterable<? extends Publisher<?>> iterable) {
        this.iterable = iterable;
    }

    @CheckReturnValue
    public MultiItemCombineIterable collectFailures() {
        this.collectFailures = true;
        return this;
    }

    @CheckReturnValue
    public MultiItemCombineIterable latestItems() {
        this.latest = true;
        return this;
    }

    @CheckReturnValue
    public <O> Multi<O> using(Function<List<?>, O> combinator) {
        ParameterValidation.nonNull(combinator, "combinator");
        return this.combine(combinator);
    }

    @CheckReturnValue
    <O> Multi<O> combine(Function<List<?>, ? extends O> combinator) {
        if (this.latest) {
            if (this.collectFailures) {
                return Infrastructure.onMultiCreation(new MultiCombineLatestOp(this.iterable, combinator, 128, true));
            }
            return Infrastructure.onMultiCreation(new MultiCombineLatestOp(this.iterable, combinator, 128, false));
        }
        if (this.collectFailures) {
            return Infrastructure.onMultiCreation(new MultiZipOp<O>(this.iterable, combinator, 128, true));
        }
        return Infrastructure.onMultiCreation(new MultiZipOp<O>(this.iterable, combinator, 128, false));
    }
}

