/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.util;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.Objects;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KubernetesContainerUtil {
    private static final int MAXLENGTH = 65;
    private static final Logger LOGGER = LoggerFactory.getLogger(KubernetesContainerUtil.class);

    private KubernetesContainerUtil() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getContainerId() {
        try {
            File file = new File("/proc/self/cgroup");
            if (!file.exists()) {
                LOGGER.warn("Unable to access container information");
                return null;
            }
            try (Stream<String> lines = Files.lines(file.toPath());){
                String id = lines.map(KubernetesContainerUtil::getContainerId).filter(Objects::nonNull).findFirst().orElse(null);
                LOGGER.debug("Found container id {}", (Object)id);
                String string = id;
                return string;
            }
        }
        catch (IOException ioe) {
            LOGGER.warn("Error obtaining container id: {}", (Object)ioe.getMessage());
        }
        return null;
    }

    static String getContainerId(String cgroupLine) {
        String line = cgroupLine;
        if (line.contains("/kubepods")) {
            int i = line.lastIndexOf(47);
            if (i < 0) {
                return null;
            }
            if ((i = (line = line.substring(i + 1)).lastIndexOf(46)) > 0) {
                line = line.substring(0, i);
            }
            if ((i = line.lastIndexOf("-")) > -1) {
                line = line.substring(i + 1);
            }
            return line.length() <= 65 ? line : line.substring(0, 65);
        }
        return null;
    }
}

