/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.client.command;

import java.util.Objects;
import java.util.Optional;
import org.eclipse.hono.client.command.CommandRequestIdParameters;
import org.eclipse.hono.util.MessagingType;
import org.eclipse.hono.util.Pair;

public final class Commands {
    private static final byte BITFLAG_INDEX_REPLY_TO_CONTAINED_DEVICE_ID = 0;
    private static final byte BITFLAG_INDEX_MESSAGING_TYPE = 1;

    private Commands() {
    }

    public static String encodeRequestIdParameters(String correlationId, String replyToId, String deviceId, MessagingType messagingType) {
        Objects.requireNonNull(messagingType);
        if (correlationId == null || deviceId == null) {
            return null;
        }
        String replyToIdWithoutDeviceOrEmpty = Optional.ofNullable(replyToId).orElse("");
        boolean replyToContainedDeviceId = replyToIdWithoutDeviceOrEmpty.startsWith(deviceId + "/");
        if (replyToContainedDeviceId) {
            replyToIdWithoutDeviceOrEmpty = replyToIdWithoutDeviceOrEmpty.substring(deviceId.length() + 1);
        }
        return String.format("%s%02x%s%s", Commands.encodeReplyToOptions(replyToContainedDeviceId, messagingType), correlationId.length(), correlationId, replyToIdWithoutDeviceOrEmpty);
    }

    public static String encodeRequestIdParameters(String correlationId, MessagingType messagingType) {
        return Commands.encodeRequestIdParameters(correlationId, null, "", messagingType);
    }

    public static CommandRequestIdParameters decodeRequestIdParameters(String requestId, String deviceId) {
        Objects.requireNonNull(requestId);
        Objects.requireNonNull(deviceId);
        try {
            String replyToOptionsBitFlag = requestId.substring(0, 1);
            boolean addDeviceIdToReply = Commands.isReplyToContainedDeviceIdOptionSet(replyToOptionsBitFlag);
            int lengthStringOne = Integer.parseInt(requestId.substring(1, 3), 16);
            String replyIdWithoutDevice = requestId.substring(3 + lengthStringOne);
            String correlationId = requestId.substring(3, 3 + lengthStringOne);
            String replyToId = addDeviceIdToReply ? deviceId + "/" + replyIdWithoutDevice : replyIdWithoutDevice;
            MessagingType messagingType = Commands.getMessagingTypeFromBitFlag(replyToOptionsBitFlag);
            return new CommandRequestIdParameters(correlationId, replyToId, messagingType);
        }
        catch (IndexOutOfBoundsException e) {
            throw new IllegalArgumentException("invalid requestId", e);
        }
    }

    public static String getDeviceFacingReplyToId(String replyToId, String deviceId, MessagingType messagingType) {
        Objects.requireNonNull(deviceId);
        Objects.requireNonNull(messagingType);
        boolean replyToContainedDeviceId = replyToId != null && replyToId.startsWith(deviceId + "/");
        String replyToIdWithoutDeviceId = replyToContainedDeviceId ? replyToId.substring(deviceId.length() + 1) : Optional.ofNullable(replyToId).orElse("");
        String bitFlagString = Commands.encodeReplyToOptions(replyToContainedDeviceId, messagingType);
        return String.format("%s/%s%s", deviceId, bitFlagString, replyToIdWithoutDeviceId);
    }

    public static Pair<String, MessagingType> getOriginalReplyToIdAndMessagingType(String deviceFacingReplyToId, String deviceId) {
        Objects.requireNonNull(deviceFacingReplyToId);
        Objects.requireNonNull(deviceId);
        try {
            String replyToOptionsBitFlag = deviceFacingReplyToId.substring(deviceId.length() + 1, deviceId.length() + 2);
            boolean replyToContainedDeviceId = Commands.isReplyToContainedDeviceIdOptionSet(replyToOptionsBitFlag);
            MessagingType messagingType = Commands.getMessagingTypeFromBitFlag(replyToOptionsBitFlag);
            String originalReplyToId = deviceFacingReplyToId.replaceFirst(deviceId + "/" + replyToOptionsBitFlag, (String)(replyToContainedDeviceId ? deviceId + "/" : ""));
            return Pair.of(originalReplyToId, messagingType);
        }
        catch (IndexOutOfBoundsException e) {
            throw new IllegalArgumentException("invalid deviceFacingReplyToId", e);
        }
    }

    private static String encodeReplyToOptions(boolean replyToContainedDeviceId, MessagingType messagingType) {
        int bitFlag = 0;
        if (replyToContainedDeviceId) {
            bitFlag |= 1;
        }
        int messagingTypeIndex = Commands.getMessagingTypeIndex(messagingType);
        return String.valueOf(bitFlag |= messagingTypeIndex << 1 & Commands.getMessagingTypeBitmask());
    }

    private static boolean isReplyToContainedDeviceIdOptionSet(String replyToOptionsBitFlag) {
        return Commands.decodeReplyToOption(replyToOptionsBitFlag, 1);
    }

    private static boolean decodeReplyToOption(String replyToOptionsBitFlag, int bitmask) {
        return (Integer.parseInt(replyToOptionsBitFlag) & bitmask) == bitmask;
    }

    private static MessagingType getMessagingTypeFromBitFlag(String replyToOptionsBitFlag) {
        int messagingTypeIndex = (Integer.parseInt(replyToOptionsBitFlag) & Commands.getMessagingTypeBitmask()) >>> 1;
        return Commands.getMessagingTypeFromIndex(messagingTypeIndex);
    }

    private static int getMessagingTypeBitmask() {
        return 2;
    }

    private static int getMessagingTypeIndex(MessagingType messagingType) {
        return messagingType.equals((Object)MessagingType.kafka) ? 1 : 0;
    }

    private static MessagingType getMessagingTypeFromIndex(int messagingTypeIndex) {
        return messagingTypeIndex == 1 ? MessagingType.kafka : MessagingType.amqp;
    }
}

