/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.sqlite;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.sql.rowset.serial.SerialBlob;
import javax.sql.rowset.serial.SerialException;
import org.apache.commons.codec.binary.Base64;
import org.eclipse.hawk.core.IConsole;
import org.eclipse.hawk.core.graph.IGraphDatabase;
import org.eclipse.hawk.core.graph.IGraphEdge;
import org.eclipse.hawk.core.graph.IGraphIterable;
import org.eclipse.hawk.core.graph.IGraphNode;
import org.eclipse.hawk.core.graph.IGraphNodeIndex;
import org.eclipse.hawk.core.graph.IGraphTransaction;
import org.eclipse.hawk.sqlite.SQLiteDatabase;
import org.eclipse.hawk.sqlite.SQLiteTransaction;
import org.eclipse.hawk.sqlite.iteration.StatementGraphNodeIterable;
import org.eclipse.hawk.sqlite.queries.IQueries;
import org.eclipse.hawk.sqlite.schema.ISchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSQLiteDatabase
implements IGraphDatabase {
    private static final String SQLITE_FILE = "hawk.sqlite";
    private static final Logger LOGGER = LoggerFactory.getLogger(SQLiteDatabase.class);
    private IGraphDatabase.Mode currentMode = IGraphDatabase.Mode.TX_MODE;
    private File storageFolder;
    private File tempFolder;
    private SQLiteConnection conn;

    protected abstract IQueries createQueries(Connection var1);

    protected abstract ISchema createSchema(Connection var1);

    private static void deleteRecursively(File f) throws IOException {
        if (!f.exists()) {
            return;
        }
        Files.walkFileTree(f.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.delete(file);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                Files.delete(dir);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    public String getPath() {
        return this.storageFolder.getAbsolutePath();
    }

    public void run(File parentfolder, IConsole c) {
        this.run(parentfolder, "jdbc:sqlite:" + new File(parentfolder, SQLITE_FILE).getAbsolutePath());
    }

    public void run(File parentfolder, String jdbcConnectionString) {
        this.storageFolder = parentfolder;
        this.tempFolder = new File(this.storageFolder, "temp");
        if (!this.tempFolder.exists()) {
            this.tempFolder.mkdirs();
        }
        try {
            Connection db = DriverManager.getConnection(jdbcConnectionString);
            db.setAutoCommit(false);
            this.conn = new SQLiteConnection(db, this.createQueries(db), this.createSchema(db));
            this.conn.getSchema().createSchema();
        }
        catch (SQLException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    public void shutdown() throws Exception {
        if (this.conn != null) {
            this.conn.close();
            this.conn = null;
        }
    }

    public void delete() throws Exception {
        this.shutdown();
        AbstractSQLiteDatabase.deleteRecursively(this.storageFolder);
    }

    public IGraphNodeIndex getOrCreateNodeIndex(String name) {
        try {
            PreparedStatement stmt = this.conn.getQueries().getUpsertNodeIndexStatement(name);
            int rowCount = stmt.executeUpdate();
            if (rowCount > 0) {
                this.conn.getSchema().createNodeIndex(name);
            }
            return this.createNodeIndex(name);
        }
        catch (SQLException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    protected abstract IGraphNodeIndex createNodeIndex(String var1);

    public IGraphNodeIndex getMetamodelIndex() {
        return this.getOrCreateNodeIndex("_hawk_metamodels");
    }

    public IGraphNodeIndex getFileIndex() {
        return this.getOrCreateNodeIndex("_hawk_files");
    }

    public IGraphTransaction beginTransaction() throws Exception {
        return new SQLiteTransaction(this);
    }

    public boolean isTransactional() {
        return true;
    }

    public void enterBatchMode() {
        this.currentMode = IGraphDatabase.Mode.NO_TX_MODE;
    }

    public void exitBatchMode() {
        this.currentMode = IGraphDatabase.Mode.TX_MODE;
    }

    public IGraphIterable<? extends IGraphNode> allNodes(String label) {
        return new StatementGraphNodeIterable<IGraphNode>(() -> this.conn.getQueries().getNodeIDsByLabelStatement(label), () -> this.conn.getQueries().getNodeCountByLabelStatement(label), () -> this.conn.getQueries().getFirstNodeIDByLabelStatement(label), o -> this.createNode((Integer)o));
    }

    public IGraphNode createNode(Map<String, Object> props, String label) {
        try {
            PreparedStatement insertNodeStmt = this.conn.getQueries().getInsertNodeStatement(label);
            int rowCount = insertNodeStmt.executeUpdate();
            assert (rowCount == 1) : "A row should have been inserted for the node";
            int nodeId = insertNodeStmt.getGeneratedKeys().getInt(1);
            IGraphNode node = this.createNode(nodeId);
            if (props != null) {
                for (Map.Entry<String, Object> e : props.entrySet()) {
                    node.setProperty(e.getKey(), e.getValue());
                }
            }
            return node;
        }
        catch (SQLException ex) {
            LOGGER.error(ex.getMessage(), (Throwable)ex);
            return null;
        }
    }

    protected abstract IGraphNode createNode(int var1);

    public IGraphEdge createRelationship(IGraphNode start, IGraphNode end, String type, Map<String, Object> props) {
        int startId = (Integer)start.getId();
        int endId = (Integer)end.getId();
        try {
            PreparedStatement stmt = this.conn.getQueries().getInsertEdgeStatement(startId, endId, type);
            int rowCount = stmt.executeUpdate();
            if (rowCount == 0) {
                return (IGraphEdge)start.getOutgoingWithType(type, Collections.singleton(end)).iterator().next();
            }
            assert (rowCount == 1) : "One row should have been inserted for the edge";
            int edgeId = stmt.getGeneratedKeys().getInt(1);
            IGraphEdge edge = this.createEdge(type, startId, endId, edgeId);
            if (props != null) {
                for (Map.Entry<String, Object> e : props.entrySet()) {
                    edge.setProperty(e.getKey(), e.getValue());
                }
            }
            return edge;
        }
        catch (SQLException ex) {
            LOGGER.error(ex.getMessage(), (Throwable)ex);
            return null;
        }
    }

    protected abstract IGraphEdge createEdge(String var1, int var2, int var3, int var4);

    public SQLiteConnection getGraph() {
        return this.conn;
    }

    public IGraphNode getNodeById(Object id) {
        if (id instanceof String) {
            return this.createNode(Integer.parseInt((String)id));
        }
        return this.createNode((Integer)id);
    }

    public String getTempDir() {
        return this.tempFolder.getAbsolutePath();
    }

    public IGraphDatabase.Mode currentMode() {
        return this.currentMode;
    }

    public Set<String> getNodeIndexNames() {
        try {
            PreparedStatement stmt = this.conn.getQueries().getAllNodeIndicesStatement();
            stmt.execute();
            return this.conn.getStrings(stmt);
        }
        catch (SQLException ex) {
            LOGGER.error(ex.getMessage(), (Throwable)ex);
            return Collections.emptySet();
        }
    }

    public SQLiteConnection getConnection() {
        return this.conn;
    }

    public class SQLiteConnection
    implements AutoCloseable {
        public static final String TYPE_BLOB_BASE64 = "blobBase64";
        private final Connection rawConn;
        private final Set<String> dropIndicesOnCommit = new HashSet<String>();
        private final IQueries queries;
        private final ISchema schema;

        public SQLiteConnection(Connection rawConn, IQueries queries, ISchema schema) {
            this.rawConn = rawConn;
            this.queries = queries;
            this.schema = schema;
        }

        @Override
        public void close() throws SQLException {
            this.rawConn.close();
        }

        public Statement createStatement() throws SQLException {
            return this.rawConn.createStatement();
        }

        public IQueries getQueries() {
            return this.queries;
        }

        public ISchema getSchema() {
            return this.schema;
        }

        public void commit() throws SQLException {
            for (String idx : this.dropIndicesOnCommit) {
                this.schema.dropNodeIndexTable(idx);
            }
            this.dropIndicesOnCommit.clear();
            this.rawConn.commit();
        }

        public void rollback() throws SQLException {
            this.dropIndicesOnCommit.clear();
            this.rawConn.rollback();
        }

        public Object preprocessPropertyValue(Object value) throws IOException, SerialException, SQLException {
            if (value.getClass().isArray()) {
                ByteArrayOutputStream bOS = new ByteArrayOutputStream();
                Throwable throwable = null;
                Object var4_5 = null;
                try (ObjectOutputStream oOS = new ObjectOutputStream(bOS);){
                    oOS.writeObject(value);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                value = new SerialBlob(bOS.toByteArray());
            }
            return value;
        }

        /*
         * Loose catch block
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public Object getPropertyValue(PreparedStatement stmt) throws SQLException, IOException, ClassNotFoundException {
            Throwable throwable = null;
            Object var3_4 = null;
            try (ResultSet rs = stmt.getResultSet();){
                String type;
                if (!rs.next()) return null;
                switch (type = rs.getString(1)) {
                    case "Boolean": {
                        return rs.getInt(2) == 1;
                    }
                    case "blobBase64": {
                        byte[] bytes = Base64.decodeBase64((String)rs.getString(2));
                        Throwable throwable2 = null;
                        Object var9_12 = null;
                        ObjectInputStream oIS = new ObjectInputStream(new ByteArrayInputStream(bytes));
                        Object object = oIS.readObject();
                        if (oIS == null) return object;
                        oIS.close();
                        return object;
                        {
                            catch (Throwable throwable3) {
                                try {
                                    if (oIS == null) throw throwable3;
                                    oIS.close();
                                    throw throwable3;
                                }
                                catch (Throwable throwable4) {
                                    if (throwable2 == null) {
                                        throwable2 = throwable4;
                                        throw throwable2;
                                    } else {
                                        if (throwable2 == throwable4) throw throwable2;
                                        throwable2.addSuppressed(throwable4);
                                    }
                                    throw throwable2;
                                }
                            }
                        }
                    }
                }
                return rs.getObject(2);
            }
            catch (Throwable throwable5) {
                if (throwable == null) {
                    throwable = throwable5;
                    throw throwable;
                } else {
                    if (throwable == throwable5) throw throwable;
                    throwable.addSuppressed(throwable5);
                }
                throw throwable;
            }
        }

        public Set<String> getStrings(PreparedStatement stmt) throws SQLException {
            Throwable throwable = null;
            Object var3_4 = null;
            try (ResultSet rs = stmt.getResultSet();){
                HashSet<String> results = new HashSet<String>();
                while (rs.next()) {
                    results.add(rs.getString(1));
                }
                return results;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }

        public void dropIndexTableOnCommit(String name) {
            this.dropIndicesOnCommit.add(name);
        }
    }
}

