/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.artifact.processors.checksum;

import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.util.Optional;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.artifact.processors.checksum.MessageDigestProcessingStep;
import org.eclipse.equinox.internal.p2.artifact.processors.checksum.Messages;
import org.eclipse.equinox.internal.p2.repository.helpers.ChecksumProducer;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.repository.artifact.IArtifactDescriptor;
import org.eclipse.equinox.p2.repository.artifact.IProcessingStepDescriptor;
import org.eclipse.osgi.util.NLS;

public final class ChecksumVerifier
extends MessageDigestProcessingStep {
    private String expectedChecksum;
    private final String algorithmName;
    private final String providerName;
    private final String algorithmId;

    public ChecksumVerifier(String digestAlgorithm, String providerName, String algorithmId) {
        this.algorithmName = digestAlgorithm;
        this.providerName = providerName;
        this.algorithmId = algorithmId;
        this.basicInitialize(null);
    }

    @Override
    public final void initialize(IProvisioningAgent agent, IProcessingStepDescriptor descriptor, IArtifactDescriptor context) {
        super.initialize(agent, descriptor, context);
        this.basicInitialize(descriptor);
        if (!this.getStatus().isOK()) {
            return;
        }
        this.expectedChecksum = descriptor.getData();
        if (Optional.ofNullable(this.expectedChecksum).orElse("").isEmpty()) {
            int code = this.buildErrorCode(descriptor);
            this.setStatus((IStatus)new Status(code, "org.eclipse.equinox.p2.artifact.repository", NLS.bind((String)Messages.Error_invalid_checksum, (Object)this.algorithmName, (Object)this.expectedChecksum)));
        }
    }

    private void basicInitialize(IProcessingStepDescriptor descriptor) {
        try {
            this.messageDigest = ChecksumProducer.getMessageDigest((String)this.algorithmName, (String)this.providerName);
            this.setStatus(Status.OK_STATUS);
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException e) {
            int code = this.buildErrorCode(descriptor);
            this.setStatus((IStatus)new Status(code, "org.eclipse.equinox.p2.artifact.repository", NLS.bind((String)Messages.Error_checksum_unavailable, (Object)this.algorithmName), (Throwable)e));
        }
    }

    private int buildErrorCode(IProcessingStepDescriptor descriptor) {
        return descriptor == null ? 4 : (descriptor.isRequired() ? 4 : 1);
    }

    @Override
    protected final void onClose(String digestString) {
        if (!digestString.equals(this.expectedChecksum)) {
            this.setStatus((IStatus)new Status(4, "org.eclipse.equinox.p2.artifact.repository", 1203, NLS.bind((String)Messages.Error_unexpected_checksum, (Object[])new Object[]{this.algorithmName, this.expectedChecksum, digestString}), null));
        }
    }

    public String getExpectedChecksum() {
        return this.expectedChecksum;
    }

    public String getAlgorithmName() {
        return this.algorithmName;
    }

    public String getAlgorithmId() {
        return this.algorithmId;
    }
}

