/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.code.editor.fx.e4.internal;

import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IContextFunction;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.MApplicationElement;
import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.menu.MPopupMenu;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.fx.code.editor.fx.e4.EditorClassURLProvider;
import org.eclipse.fx.code.editor.fx.e4.EditorContainerService;
import org.eclipse.fx.code.editor.fx.e4.EditorContextMenuService;
import org.eclipse.fx.code.editor.fx.e4.EditorPartTabContextMenuService;
import org.eclipse.fx.code.editor.fx.services.EditorContextMenuProvider;
import org.eclipse.fx.code.editor.services.EditorOpener;
import org.eclipse.fx.code.editor.services.EditorOpenerTypeProvider;
import org.eclipse.fx.code.editor.services.FileIconProvider;
import org.eclipse.fx.core.RankedObjectRegistry;
import org.eclipse.fx.core.URI;
import org.eclipse.fx.core.di.Service;
import org.eclipse.fx.core.di.context.ServiceContextFunction;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(service={IContextFunction.class}, property={"service.context.key=org.eclipse.fx.code.editor.services.EditorOpener"})
public class EditorOpenerContextFunction
extends ServiceContextFunction<EditorOpenerTypeProvider> {
    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    public void registerService(EditorOpenerTypeProvider service, Map<String, Object> properties) {
        super.registerService((Object)service, properties);
    }

    public void unregisterService(EditorOpenerTypeProvider service) {
        super.unregisterService((Object)service);
    }

    public Object compute(IEclipseContext context) {
        return new ProxyEditorOpener(context, (RankedObjectRegistry<EditorOpenerTypeProvider>)this.registry);
    }

    public static class DefaultEditorOpener
    implements EditorOpener {
        @Inject
        MApplication application;
        @Inject
        EditorContainerService containerService;
        @Inject
        EModelService modelService;
        @Inject
        @Service
        List<FileIconProvider> fileIconProvider;
        @Inject
        @Service
        List<EditorClassURLProvider> editorUrlProvider;
        @Inject
        EditorContextMenuService contextMenuService;
        @Inject
        EditorPartTabContextMenuService tabContextMenuService;

        public boolean openEditor(String uri) {
            IEclipseContext context;
            List list = this.modelService.findElements((MApplicationElement)this.application, MPart.class, 29, p -> uri.equals(p.getPersistedState().get("documentUrl")));
            MPart part = null;
            if (list.isEmpty()) {
                MElementContainer<MUIElement> container = this.containerService.getContainer();
                if (container != null) {
                    part = (MPart)this.modelService.createModelElement(MPart.class);
                    part.setCloseable(true);
                    part.setLabel(URI.create((String)uri).lastSegment());
                    String editorBundleURI = this.editorUrlProvider.stream().filter(e -> e.test(uri)).findFirst().map(e -> e.getBundleClassURI(uri)).orElse("bundleclass://org.eclipse.fx.code.editor.fx/org.eclipse.fx.code.editor.fx.TextEditor");
                    part.setContributionURI(editorBundleURI);
                    part.setContributorURI("platform:/plugin/org.eclipse.fx.code.editor.fx.e4");
                    String iconUri = this.fileIconProvider.stream().filter(f -> f.test((Object)uri)).findFirst().map(f -> f.getFileIconUri(uri)).orElse("platform:/plugin/org.eclipse.fx.code.editor.fx.e4/icons/file_16.png");
                    part.setIconURI(iconUri);
                    part.getPersistedState().put("documentUrl", uri);
                    part.getTags().add("removeOnHide");
                    MPopupMenu menu = this.contextMenuService.getContextMenu(this.modelService, this.application, part, EditorContextMenuProvider.Type.CONTENT);
                    if (menu != null) {
                        part.getMenus().add(menu);
                    }
                    if ((menu = this.tabContextMenuService.getContextMenu(this.modelService, this.application, part)) != null) {
                        menu.getTags().add("tabmenu");
                        part.getMenus().add(menu);
                    }
                    container.getChildren().add(part);
                }
            } else {
                part = (MPart)list.get(0);
            }
            if ((context = this.modelService.getContainingContext((MUIElement)part)) != null) {
                EPartService partService = (EPartService)context.get(EPartService.class);
                partService.activate(part);
            }
            return true;
        }

        public boolean test(String uri) {
            return true;
        }
    }

    public static class ProxyEditorOpener
    implements EditorOpener {
        private final IEclipseContext context;
        private final RankedObjectRegistry<EditorOpenerTypeProvider> objectRegistry;

        public ProxyEditorOpener(IEclipseContext context, RankedObjectRegistry<EditorOpenerTypeProvider> objectRegistry) {
            this.context = context;
            this.objectRegistry = objectRegistry;
        }

        public boolean openEditor(String uri) {
            EditorOpener opener = this.objectRegistry.getRankedElements().stream().filter(e -> e.test((Object)uri)).map(e -> (EditorOpener)ContextInjectionFactory.make((Class)e.getType((Object)uri), (IEclipseContext)this.context)).filter(e -> e.test(uri)).findFirst().orElseGet(() -> (EditorOpener)ContextInjectionFactory.make(DefaultEditorOpener.class, (IEclipseContext)this.context));
            boolean success = opener.openEditor(uri);
            if (!success) {
                success = ((DefaultEditorOpener)ContextInjectionFactory.make(DefaultEditorOpener.class, (IEclipseContext)this.context)).openEditor(uri);
            }
            return success;
        }

        public boolean test(String uri) {
            return true;
        }
    }
}

