/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.workbench.base.debug;

import java.io.IOException;
import java.io.Writer;
import java.util.function.Predicate;
import org.eclipse.e4.ui.model.application.MApplicationElement;
import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MGenericStack;
import org.eclipse.e4.ui.model.application.ui.MGenericTile;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.MUILabel;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspective;
import org.eclipse.e4.ui.model.application.ui.basic.MPartSashContainerElement;
import org.eclipse.e4.ui.model.application.ui.basic.MStackElement;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.fx.core.text.TextUtil;

public class ModelStructureDump {
    public static void dump(MApplicationElement element, Writer writer, DefaultConfiguration defaultConfiguration) throws IOException {
        ModelStructureDump.dump(element, writer, defaultConfiguration, defaultConfiguration);
    }

    public static void dump(MApplicationElement element, Writer writer, Visitor visitor, Predicate<MApplicationElement> contentFilter) throws IOException {
        ModelStructureDump.dump(0, element, writer, visitor, contentFilter);
    }

    private static void dump(int nestLevel, MApplicationElement element, Writer writer, Visitor visitor, Predicate<MApplicationElement> contentFilter) throws IOException {
        writer.append(TextUtil.createRepeatedString((char)' ', (int)(nestLevel * 4)) + " + ");
        boolean proceed = visitor.visit(element, writer);
        writer.append('\n');
        if (proceed) {
            EList eContents = ((EObject)element).eContents();
            for (EObject eo : eContents) {
                if (!(eo instanceof MApplicationElement) || !contentFilter.test((MApplicationElement)eo)) continue;
                ModelStructureDump.dump(nestLevel + 1, (MApplicationElement)eo, writer, visitor, contentFilter);
            }
        }
    }

    public static enum DefaultConfiguration implements Visitor,
    Predicate<MApplicationElement>
    {
        BasicUI(DefaultConfiguration::basicUI_visit, DefaultConfiguration::basicUI_filter);

        private final Visitor visitorDelegate;
        private final Predicate<MApplicationElement> filterDelegate;

        private DefaultConfiguration(Visitor delegate, Predicate<MApplicationElement> filterDelegate) {
            this.visitorDelegate = delegate;
            this.filterDelegate = filterDelegate;
        }

        @Override
        public boolean visit(MApplicationElement element, Writer writer) throws IOException {
            return this.visitorDelegate.visit(element, writer);
        }

        @Override
        public boolean test(MApplicationElement t) {
            return this.filterDelegate.test(t);
        }

        private static boolean basicUI_visit(MApplicationElement element, Writer writer) throws IOException {
            writer.append(((EObject)element).eClass().getName());
            if (element instanceof MUILabel) {
                writer.append(" - " + ((MUILabel)element).getLocalizedLabel());
            }
            if (element instanceof MUIElement && ((MUIElement)element).getContainerData() != null && !((MUIElement)element).getContainerData().isEmpty()) {
                writer.append(": " + ((MUIElement)element).getContainerData());
            }
            return element instanceof MElementContainer;
        }

        private static boolean basicUI_filter(MApplicationElement element) {
            return element instanceof MPartSashContainerElement || element instanceof MStackElement || element instanceof MWindow || element instanceof MGenericStack || element instanceof MGenericTile || element instanceof MPerspective;
        }
    }

    public static interface Visitor {
        public boolean visit(MApplicationElement var1, Writer var2) throws IOException;
    }
}

