/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.controls.styledtext.behavior;

import java.util.Optional;
import javafx.animation.Animation;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.css.PseudoClass;
import javafx.event.Event;
import javafx.event.EventTarget;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.scene.Cursor;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCombination;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.util.Duration;
import org.eclipse.fx.core.IntTuple;
import org.eclipse.fx.core.SystemUtils;
import org.eclipse.fx.core.text.DefaultTextEditActions;
import org.eclipse.fx.core.text.TextEditAction;
import org.eclipse.fx.core.text.TextUtil;
import org.eclipse.fx.ui.controls.Util;
import org.eclipse.fx.ui.controls.styledtext.StyledTextArea;
import org.eclipse.fx.ui.controls.styledtext.StyledTextContent;
import org.eclipse.fx.ui.controls.styledtext.TextSelection;
import org.eclipse.fx.ui.controls.styledtext.TriggerActionMapping;
import org.eclipse.fx.ui.controls.styledtext.VerifyEvent;
import org.eclipse.fx.ui.controls.styledtext.behavior.HoverSupport;
import org.eclipse.fx.ui.controls.styledtext.behavior.TextPositionSupport;
import org.eclipse.fx.ui.controls.styledtext.events.TextPositionEvent;
import org.eclipse.fx.ui.controls.styledtext.events.UndoHintEvent;
import org.eclipse.fx.ui.controls.styledtext.internal.TextNode;
import org.eclipse.fx.ui.controls.styledtext.skin.StyledTextSkin;
import org.eclipse.jdt.annotation.NonNull;

public class StyledTextBehavior {
    private TriggerActionMapping keyTriggerMapping = new TriggerActionMapping();
    private TextPositionSupport textPositionSupport;
    private HoverSupport hoverSupport;
    private final StyledTextArea styledText;
    int acceleration = 3;
    private final int AUTO_SCROLL_RATE = 50;
    private static final boolean AUTO_SCROLL = !Boolean.getBoolean("styledtext.autoscroll.disabled");
    private final Timeline positionUpdaterTop = new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)50.0), e -> {
        int lineIdx;
        if (this.getControl().getCaretOffset() > 0 && (lineIdx = this.getControl().getContent().getLineAtOffset(this.getControl().getCaretOffset())) > 0) {
            int lineStart = this.getControl().getContent().getOffsetAtLine(Math.max(lineIdx - this.acceleration, 0));
            this.moveCaretAbsolute(lineStart, true);
        }
    }, new KeyValue[0])});
    private final Timeline positionUpdaterBottom = new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)50.0), e -> {
        int lineIdx;
        if (this.getControl().getCaretOffset() < this.getControl().getContent().getCharCount() && (lineIdx = this.getControl().getContent().getLineAtOffset(this.getControl().getCaretOffset())) < this.getControl().getContent().getLineCount() - 1) {
            int targetIndex = Math.min(lineIdx + this.acceleration, this.getControl().getContent().getLineCount() - 1);
            int lineEndStart = this.getControl().getContent().getOffsetAtLine(targetIndex);
            if (targetIndex == this.getControl().getLineCount() - 1) {
                lineEndStart = Math.min(lineEndStart + this.getControl().getContent().getLine(targetIndex).length(), this.getControl().getCharCount());
            }
            this.moveCaretAbsolute(lineEndStart, true);
        }
    }, new KeyValue[0])});
    private volatile boolean pressedInSelection = false;
    private volatile boolean dragMoveTextMode = false;
    private volatile boolean dragSelectionMode = false;
    private volatile int dragMoveTextOffset = -1;
    private volatile int dragMoveTextLength = -1;
    private int mousePressedOffset = -1;
    private Optional<TextNode> currentQuickLinkNode = Optional.empty();
    private static final PseudoClass QUICK_LINK_ACTIVE_PSEUDOCLASS_STATE = PseudoClass.getPseudoClass((String)"quick-link-active");
    private static final PseudoClass DRAG_TEXT_MOVE_ACTIVE_PSEUDOCLASS_STATE = PseudoClass.getPseudoClass((String)"drag-text-move-active");
    private static final PseudoClass DRAG_TEXT_COPY_ACTIVE_PSEUDOCLASS_STATE = PseudoClass.getPseudoClass((String)"drag-text-copy-active");

    public StyledTextBehavior(StyledTextArea styledText) {
        this.styledText = styledText;
        this.positionUpdaterTop.setCycleCount(-1);
        this.positionUpdaterBottom.setCycleCount(-1);
        styledText.addEventHandler(KeyEvent.KEY_PRESSED, this::onKeyPressed);
        styledText.addEventHandler(KeyEvent.KEY_TYPED, this::onKeyTyped);
        styledText.addEventHandler(MouseEvent.MOUSE_PRESSED, this::onMousePressed);
        styledText.addEventHandler(TextPositionEvent.TEXT_POSITION_MOVED, this::onTextPositionMoved);
        this.keyTriggerMapping.subscribe(this::defaultHandle);
        this.initKeymapping(this.keyTriggerMapping);
        styledText.addEventHandler(TextPositionEvent.TEXT_POSITION_PRESSED, this::onTextPositionPressed);
        styledText.addEventHandler(TextPositionEvent.TEXT_POSITION_CLICKED, this::onTextPositionClicked);
        styledText.addEventHandler(TextPositionEvent.TEXT_POSITION_RELEASED, this::onTextPositionReleased);
        styledText.addEventHandler(TextPositionEvent.TEXT_POSITION_DRAGGED, this::onTextPositionDragged);
        styledText.addEventHandler(TextPositionEvent.TEXT_POSITION_DRAG_DETECTED, this::onTextPositionDragDetected);
        this.keyTriggerMapping.overrideProperty().bind(styledText.overrideActionMappingProperty());
    }

    public void installContentListeners(javafx.scene.layout.Region contentNode) {
        this.textPositionSupport = TextPositionSupport.install(contentNode, this.getControl());
        this.hoverSupport = HoverSupport.install(contentNode);
    }

    static int computeStart(StyledTextContent content, int firstLine) {
        return content.getOffsetAtLine(firstLine);
    }

    static int computeEnd(StyledTextContent content, int lastLine) {
        int endIndex = content.getLineCount() > lastLine + 1 ? content.getOffsetAtLine(lastLine + 1) : content.getOffsetAtLine(lastLine) + content.getLine(lastLine).length();
        return endIndex;
    }

    static int computeLength(StyledTextContent content, int firstLine, int lastLine) {
        return StyledTextBehavior.computeEnd(content, lastLine) - StyledTextBehavior.computeStart(content, firstLine);
    }

    private @NonNull LineRegion getLineRegion(TextSelection selection) {
        int firstLine = this.getControl().getLineAtOffset(selection.offset);
        int lastLine = this.getControl().getLineAtOffset(selection.offset + selection.length);
        int lastLineBegin = this.getControl().getOffsetAtLine(lastLine);
        if (lastLineBegin == selection.offset + selection.length) {
            --lastLine;
        }
        lastLine = Math.min(this.getControl().getContent().getLineCount() - 1, lastLine);
        lastLine = Math.max(firstLine, lastLine);
        return new LineRegion(firstLine, lastLine);
    }

    private static boolean isInRange(int offset, int rangeOffset, int rangeLength) {
        return offset >= rangeOffset && offset < rangeOffset + rangeLength;
    }

    private boolean isInSelection(int offset) {
        int selOffset = this.getControl().getSelection().offset;
        int selLength = this.getControl().getSelection().length;
        boolean r = selLength > 0 && StyledTextBehavior.isInRange(offset, selOffset, selLength);
        return r;
    }

    private void onKeyPressed(KeyEvent event) {
        if (this.keyTriggerMapping.exists(event)) {
            this.getControl().fireEvent(UndoHintEvent.createBeginCompoundChangeEvent());
            try {
                boolean handled = this.keyTriggerMapping.triggerAction(event, new TriggerActionMapping.Context(this.getControl()));
                if (handled) {
                    event.consume();
                    return;
                }
            }
            finally {
                this.getControl().fireEvent(UndoHintEvent.createEndCompoundChangeEvent());
            }
        }
        if (this.dragMoveTextMode) {
            if (event.getCode() == KeyCode.ESCAPE) {
                this.dragMoveTextMode = false;
                this.pressedInSelection = false;
                ((StyledTextSkin)this.getControl().getSkin()).updateInsertionMarkerIndex(-1);
                this.getControl().pseudoClassStateChanged(DRAG_TEXT_MOVE_ACTIVE_PSEUDOCLASS_STATE, false);
                this.getControl().pseudoClassStateChanged(DRAG_TEXT_COPY_ACTIVE_PSEUDOCLASS_STATE, false);
                event.consume();
                return;
            }
            if (event.isShortcutDown()) {
                this.getControl().pseudoClassStateChanged(DRAG_TEXT_MOVE_ACTIVE_PSEUDOCLASS_STATE, false);
                this.getControl().pseudoClassStateChanged(DRAG_TEXT_COPY_ACTIVE_PSEUDOCLASS_STATE, true);
            } else {
                this.getControl().pseudoClassStateChanged(DRAG_TEXT_MOVE_ACTIVE_PSEUDOCLASS_STATE, true);
                this.getControl().pseudoClassStateChanged(DRAG_TEXT_COPY_ACTIVE_PSEUDOCLASS_STATE, false);
            }
        }
        VerifyEvent evt = new VerifyEvent((Object)this.getControl(), (EventTarget)this.getControl(), event);
        Event.fireEvent((EventTarget)this.getControl(), (Event)evt);
        if (SystemUtils.isMacOS()) {
            if (event.getCode() == KeyCode.ALT || event.isAltDown()) {
                event.consume();
            }
        } else if (Util.MNEMONICS_FIX) {
            if (event.isAltDown() && event.isControlDown()) {
                event.consume();
            } else if (event.isAltDown() && event.getCode() == KeyCode.TAB) {
                event.consume();
            }
        }
        if (evt.isConsumed()) {
            event.consume();
            return;
        }
        if (KeyCombination.keyCombination((String)"Tab").match(event) && this.getControl().getEditable()) {
            this.getControl().insert("\t");
            event.consume();
        }
    }

    private void onKeyTyped(KeyEvent event) {
        if (this.getControl().getEditable()) {
            String character = event.getCharacter();
            if (character.length() == 0) {
                return;
            }
            if ((event.isControlDown() || event.isAltDown() || SystemUtils.isMacOS() && event.isMetaDown()) && (!event.isControlDown() && !SystemUtils.isMacOS() || !event.isAltDown())) {
                return;
            }
            if (character.charAt(0) > '\u001f' && character.charAt(0) != '\u007f' && !event.isMetaDown()) {
                this.getControl().insert(character);
                if (this.keyTriggerMapping.exists(character.charAt(0))) {
                    this.getControl().fireEvent(UndoHintEvent.createBeginCompoundChangeEvent());
                    try {
                        this.keyTriggerMapping.triggerAction(character.charAt(0), new TriggerActionMapping.Context(this.getControl()));
                    }
                    finally {
                        this.getControl().fireEvent(UndoHintEvent.createEndCompoundChangeEvent());
                    }
                }
            }
        }
    }

    private void onTextPositionDragDetected(TextPositionEvent event) {
        if (event.getButton() != MouseButton.PRIMARY) {
            return;
        }
        if (this.pressedInSelection) {
            if (Util.isCopyEvent(event)) {
                this.getControl().pseudoClassStateChanged(DRAG_TEXT_COPY_ACTIVE_PSEUDOCLASS_STATE, true);
            } else {
                this.getControl().pseudoClassStateChanged(DRAG_TEXT_MOVE_ACTIVE_PSEUDOCLASS_STATE, true);
            }
            this.dragMoveTextMode = true;
            this.dragMoveTextOffset = this.getControl().getSelection().offset;
            this.dragMoveTextLength = this.getControl().getSelection().length;
        } else {
            this.dragSelectionMode = true;
        }
    }

    private void onTextPositionDragged(TextPositionEvent event) {
        if (this.dragSelectionMode) {
            if (event.getOffset() >= 0) {
                this.positionUpdaterTop.stop();
                this.positionUpdaterBottom.stop();
                this.moveCaretAbsolute(event.getOffset(), true);
            } else if (AUTO_SCROLL) {
                if (event.getY() <= 0.0) {
                    this.acceleration = (int)Math.abs(event.getY());
                    this.positionUpdaterBottom.stop();
                    if (this.positionUpdaterTop.getStatus() != Animation.Status.RUNNING) {
                        this.positionUpdaterTop.playFromStart();
                    }
                } else {
                    Bounds b = ((StyledTextSkin)this.getControl().getSkin()).getContentBounds();
                    this.acceleration = (int)Math.abs(b.getMaxY() - event.getY());
                    this.positionUpdaterTop.stop();
                    if (this.positionUpdaterBottom.getStatus() != Animation.Status.RUNNING) {
                        this.positionUpdaterBottom.playFromStart();
                    }
                }
            }
            event.consume();
        } else if (this.dragMoveTextMode) {
            ((StyledTextSkin)this.getControl().getSkin()).updateInsertionMarkerIndex(event.getOffset());
            if (Util.isCopyEvent(event)) {
                this.getControl().pseudoClassStateChanged(DRAG_TEXT_MOVE_ACTIVE_PSEUDOCLASS_STATE, false);
                this.getControl().pseudoClassStateChanged(DRAG_TEXT_COPY_ACTIVE_PSEUDOCLASS_STATE, true);
            } else {
                this.getControl().pseudoClassStateChanged(DRAG_TEXT_MOVE_ACTIVE_PSEUDOCLASS_STATE, true);
                this.getControl().pseudoClassStateChanged(DRAG_TEXT_COPY_ACTIVE_PSEUDOCLASS_STATE, false);
            }
            event.consume();
        }
    }

    private void onTextPositionReleased(TextPositionEvent event) {
        if (this.dragSelectionMode) {
            this.dragSelectionMode = false;
            this.positionUpdaterTop.stop();
            this.positionUpdaterBottom.stop();
            event.consume();
        } else if (this.dragMoveTextMode) {
            ((StyledTextSkin)this.getControl().getSkin()).updateInsertionMarkerIndex(-1);
            this.getControl().pseudoClassStateChanged(DRAG_TEXT_MOVE_ACTIVE_PSEUDOCLASS_STATE, false);
            this.getControl().pseudoClassStateChanged(DRAG_TEXT_COPY_ACTIVE_PSEUDOCLASS_STATE, false);
            int targetOffset = event.getOffset();
            if (this.getControl().getSelection().contains(targetOffset)) {
                this.dragMoveTextMode = false;
                event.consume();
                return;
            }
            if (targetOffset < 0) {
                this.dragMoveTextMode = false;
                event.consume();
                return;
            }
            @NonNull String text = this.getControl().getContent().getTextRange(this.dragMoveTextOffset, this.dragMoveTextLength);
            if (this.getControl().getEditable()) {
                this.getControl().fireEvent(UndoHintEvent.createBeginCompoundChangeEvent());
                try {
                    if (!Util.isCopyEvent(event)) {
                        if (StyledTextBehavior.isInRange(targetOffset, this.dragMoveTextOffset, this.dragMoveTextLength)) {
                            targetOffset = this.dragMoveTextOffset;
                        } else if (targetOffset >= this.dragMoveTextOffset + this.dragMoveTextLength) {
                            targetOffset -= this.dragMoveTextLength;
                        }
                        this.getControl().getContent().replaceTextRange(this.dragMoveTextOffset, this.dragMoveTextLength, "");
                    }
                    this.getControl().getContent().replaceTextRange(targetOffset, 0, text);
                    this.moveCaretAbsolute(targetOffset + text.length());
                    this.getControl().setSelection(new TextSelection(targetOffset, text.length()));
                }
                finally {
                    this.getControl().fireEvent(UndoHintEvent.createEndCompoundChangeEvent());
                }
            }
            this.dragMoveTextMode = false;
            event.consume();
        } else if (this.pressedInSelection) {
            this.moveCaretAbsolute(this.mousePressedOffset, event.isShiftDown());
            event.consume();
        }
        this.pressedInSelection = false;
    }

    private void onTextPositionPressed(TextPositionEvent event) {
        if (event.getButton() != MouseButton.PRIMARY && event.getButton() != MouseButton.SECONDARY) {
            return;
        }
        this.mousePressedOffset = event.getOffset();
        if (this.mousePressedOffset < 0) {
            this.mousePressedOffset = this.getControl().getContent().getCharCount();
        }
        if (this.isInSelection(this.mousePressedOffset) && event.getButton() == MouseButton.SECONDARY) {
            event.consume();
        } else if (this.isInSelection(this.mousePressedOffset) && this.getControl().getEditable()) {
            this.pressedInSelection = true;
            event.consume();
        } else {
            this.moveCaretAbsolute(this.mousePressedOffset, event.isShiftDown());
            event.consume();
        }
    }

    private void doLink(StyledTextArea.QuickLink link) {
        if (link instanceof StyledTextArea.SimpleQuickLink) {
            StyledTextArea.SimpleQuickLink simple = (StyledTextArea.SimpleQuickLink)link;
            this.getControl().setCaretOffset((Integer)simple.getRegion().upperEndpoint());
            this.getControl().setSelection(new TextSelection((Integer)simple.getRegion().lowerEndpoint(), (Integer)simple.getRegion().upperEndpoint() - (Integer)simple.getRegion().lowerEndpoint()));
        } else if (link instanceof StyledTextArea.CustomQuickLink) {
            StyledTextArea.CustomQuickLink custom = (StyledTextArea.CustomQuickLink)link;
            custom.getAction().run();
        }
    }

    private void onTextPositionClicked(TextPositionEvent event) {
        if (event.isStillSincePress()) {
            if (event.getClickCount() == 2 && event.getButton() == MouseButton.PRIMARY) {
                this.keyTriggerMapping.triggerAction((TextEditAction)DefaultTextEditActions.SELECT_WORD, new TriggerActionMapping.Context(this.getControl()));
                event.consume();
            }
            if (event.getClickCount() == 3 && event.getButton() == MouseButton.PRIMARY) {
                this.keyTriggerMapping.triggerAction((TextEditAction)DefaultTextEditActions.SELECT_LINE, new TriggerActionMapping.Context(this.getControl()));
                event.consume();
            }
        }
        if (event.isShortcutDown()) {
            Optional<StyledTextArea.QuickLinkable> linkable = this.getControl().getQuickLinkCallback().apply(event.getOffset());
            linkable.ifPresent(l -> {
                if (l.getLinks().size() == 1) {
                    this.doLink(l.getLinks().get(0));
                }
            });
        }
    }

    protected StyledTextArea getControl() {
        return this.styledText;
    }

    private void onMousePressed(MouseEvent event) {
        this.getControl().requestFocus();
    }

    private void setCurrentQuickLinkNode(Optional<TextNode> node) {
        if (node.isPresent()) {
            this.getControl().setCursor(Cursor.HAND);
        } else {
            this.getControl().setCursor(null);
        }
        this.currentQuickLinkNode.ifPresent(n -> {
            boolean bl = n.getStyleClass().remove((Object)"quick_link");
        });
        this.currentQuickLinkNode.ifPresent(n -> n.setCursor(null));
        if (this.currentQuickLinkNode.isPresent() != node.isPresent()) {
            this.getControl().pseudoClassStateChanged(QUICK_LINK_ACTIVE_PSEUDOCLASS_STATE, !this.currentQuickLinkNode.isPresent());
        }
        this.currentQuickLinkNode = node;
        this.currentQuickLinkNode.ifPresent(n -> {
            boolean bl = n.getStyleClass().add((Object)"quick_link");
        });
        this.currentQuickLinkNode.ifPresent(n -> n.requestLayout());
    }

    private void onTextPositionMoved(TextPositionEvent event) {
        if (event.isShortcutDown()) {
            Optional<StyledTextArea.QuickLinkable> linkable = this.getControl().getQuickLinkCallback().apply(event.getOffset());
            if (linkable.isPresent()) {
                Point2D screenLocation = new Point2D(event.getScreenX(), event.getScreenY());
                Optional<TextNode> node = ((StyledTextSkin)this.getControl().getSkin()).findTextNode(screenLocation);
                if (!this.currentQuickLinkNode.equals(node)) {
                    this.setCurrentQuickLinkNode(node);
                }
            } else {
                this.setCurrentQuickLinkNode(Optional.empty());
            }
        } else {
            this.setCurrentQuickLinkNode(Optional.empty());
        }
    }

    private int computeCurrentLineNumber() {
        int offset = this.getControl().getCaretOffset();
        return this.getControl().getLineAtOffset(offset);
    }

    private int computeCurrentLineStartOffset() {
        int lineNumber = this.computeCurrentLineNumber();
        return this.getControl().getOffsetAtLine(lineNumber);
    }

    protected boolean defaultHandle(TextEditAction action, TriggerActionMapping.Context context) {
        if (!this.getControl().getEditable() && action.isModification()) {
            return true;
        }
        if (action == DefaultTextEditActions.TEXT_START) {
            this.defaultNavigateTextStart();
            return true;
        }
        if (action == DefaultTextEditActions.TEXT_END) {
            this.defaultNavigateTextEnd();
            return true;
        }
        if (action == DefaultTextEditActions.TEXT_PAGE_DOWN) {
            this.defaultNavigateTextPageDown();
            return true;
        }
        if (action == DefaultTextEditActions.TEXT_PAGE_UP) {
            this.defaultNavigateTextPageUp();
            return true;
        }
        if (action == DefaultTextEditActions.LINE_START) {
            this.defaultNavigateLineStart();
            return true;
        }
        if (action == DefaultTextEditActions.LINE_END) {
            this.defaultNavigateLineEnd();
            return true;
        }
        if (action == DefaultTextEditActions.WORD_NEXT) {
            this.defaultNavigateWordNext();
            return true;
        }
        if (action == DefaultTextEditActions.WORD_PREVIOUS) {
            this.defaultNavigateWordPrevious();
            return true;
        }
        if (action == DefaultTextEditActions.SELECT_TEXT_START) {
            this.defaultSelectTextStart();
            return true;
        }
        if (action == DefaultTextEditActions.SELECT_TEXT_END) {
            this.defaultSelectTextEnd();
            return true;
        }
        if (action == DefaultTextEditActions.SELECT_TEXT_PAGE_DOWN) {
            this.defaultSelectTextPageDown();
            return true;
        }
        if (action == DefaultTextEditActions.SELECT_TEXT_PAGE_UP) {
            this.defaultSelectTextPageUp();
            return true;
        }
        if (action == DefaultTextEditActions.SELECT_LINE_START) {
            this.defaultSelectLineStart();
            return true;
        }
        if (action == DefaultTextEditActions.SELECT_LINE_END) {
            this.defaultSelectLineEnd();
            return true;
        }
        if (action == DefaultTextEditActions.SELECT_WORD_NEXT) {
            this.defaultSelectWordNext();
            return true;
        }
        if (action == DefaultTextEditActions.SELECT_WORD_PREVIOUS) {
            this.defaultSelectWordPrevious();
            return true;
        }
        if (action == DefaultTextEditActions.SELECT_WORD) {
            this.defaultSelectWord();
            return true;
        }
        if (action == DefaultTextEditActions.SELECT_LINE) {
            this.defaultSelectLine();
            return true;
        }
        if (action == DefaultTextEditActions.DELETE_LINE) {
            this.defaultDeleteLine();
            return true;
        }
        if (action == DefaultTextEditActions.DELETE_WORD_NEXT) {
            this.defaultDeleteWordNext();
            return true;
        }
        if (action == DefaultTextEditActions.DELETE_WORD_PREVIOUS) {
            this.defaultDeleteWordPrevious();
            return true;
        }
        if (action == DefaultTextEditActions.MOVE_LINES_UP) {
            this.defaultMoveLinesUp();
            return true;
        }
        if (action == DefaultTextEditActions.MOVE_LINES_DOWN) {
            this.defaultMoveLinesDown();
            return true;
        }
        if (action == DefaultTextEditActions.INDENT) {
            this.defaultIndent();
            return true;
        }
        if (action == DefaultTextEditActions.OUTDENT) {
            this.defaultOutdent();
            return true;
        }
        if (action == DefaultTextEditActions.NEW_LINE) {
            this.defaultNewLine();
            return true;
        }
        if (action == DefaultTextEditActions.SELECT_ALL) {
            this.defaultSelectAll();
            return true;
        }
        if (action == DefaultTextEditActions.CUT) {
            this.defaultCut();
            return true;
        }
        if (action == DefaultTextEditActions.COPY) {
            this.defaultCopy();
            return true;
        }
        if (action == DefaultTextEditActions.PASTE) {
            this.defaultPaste();
            return true;
        }
        if (action == DefaultTextEditActions.DELETE) {
            this.defaultDelete();
            return true;
        }
        if (action == DefaultTextEditActions.DELETE_PREVIOUS) {
            this.defaultDeletePrevious();
            return true;
        }
        if (action == DefaultTextEditActions.DELETE_LINE) {
            this.defaultDeleteLine();
            return true;
        }
        if (action == DefaultTextEditActions.SCROLL_LINE_UP) {
            this.defaultScrollLineUp();
            return true;
        }
        if (action == DefaultTextEditActions.SCROLL_LINE_DOWN) {
            this.defaultScrollLineDown();
            return true;
        }
        if (action == DefaultTextEditActions.NAVIGATE_TO_LINE) {
            this.defaultNavigateLineEnd();
            return true;
        }
        if (action == DefaultTextEditActions.MOVE_UP) {
            this.defaultUp(false);
            return true;
        }
        if (action == DefaultTextEditActions.MOVE_LEFT) {
            this.defaultLeft(false);
            return true;
        }
        if (action == DefaultTextEditActions.MOVE_RIGHT) {
            this.defaultRight(false);
            return true;
        }
        if (action == DefaultTextEditActions.MOVE_DOWN) {
            this.defaultDown(false);
            return true;
        }
        if (action == DefaultTextEditActions.SELECT_UP) {
            this.defaultUp(true);
            return true;
        }
        if (action == DefaultTextEditActions.SELECT_LEFT) {
            this.defaultLeft(true);
            return true;
        }
        if (action == DefaultTextEditActions.SELECT_RIGHT) {
            this.defaultRight(true);
            return true;
        }
        if (action == DefaultTextEditActions.SELECT_DOWN) {
            this.defaultDown(true);
            return true;
        }
        return false;
    }

    protected void defaultNavigateTextStart() {
        this.getControl().setCaretOffset(0);
    }

    protected void defaultNavigateTextEnd() {
        this.getControl().setCaretOffset(this.getControl().getContent().getCharCount());
    }

    private int calculatePageDownOffset() {
        int linesPerPage = ((StyledTextSkin)this.getControl().getSkin()).getVisibleLineCount();
        int globalOffset = this.getControl().getCaretOffset();
        int lineIndex = this.getControl().getContent().getLineAtOffset(globalOffset);
        int lineLocalOffset = globalOffset - this.getControl().getContent().getOffsetAtLine(lineIndex);
        int newLineIndex = Math.min(this.getControl().getContent().getLineCount() - 1, lineIndex + linesPerPage);
        int newLineLocalOffset = Math.min(this.getControl().getContent().getLine(newLineIndex).length(), lineLocalOffset);
        return this.getControl().getOffsetAtLine(newLineIndex) + newLineLocalOffset;
    }

    private int calculatePageUpOffset() {
        int linesPerPage = ((StyledTextSkin)this.getControl().getSkin()).getVisibleLineCount();
        int globalOffset = this.getControl().getCaretOffset();
        int lineIndex = this.getControl().getContent().getLineAtOffset(globalOffset);
        int lineLocalOffset = globalOffset - this.getControl().getContent().getOffsetAtLine(lineIndex);
        int newLineIndex = Math.max(0, lineIndex - linesPerPage);
        int newLineLocalOffset = Math.min(this.getControl().getContent().getLine(newLineIndex).length(), lineLocalOffset);
        return this.getControl().getOffsetAtLine(newLineIndex) + newLineLocalOffset;
    }

    protected void defaultSelectTextPageUp() {
        this.moveCaretAbsolute(this.calculatePageUpOffset(), true);
    }

    protected void defaultSelectTextPageDown() {
        this.moveCaretAbsolute(this.calculatePageDownOffset(), true);
    }

    protected void defaultNavigateLineStart() {
        this.moveCaretAbsolute(this.computeCurrentLineStartOffset());
    }

    protected void defaultNavigateLineEnd() {
        int caretLine = this.computeCurrentLineNumber();
        this.moveCaretAbsolute(this.getControl().getContent().getOffsetAtLine(caretLine) + this.getControl().getContent().getLine(caretLine).length());
    }

    protected void defaultNavigateWordNext() {
        int following = TextUtil.findWordEndOffset((TextUtil.IterableCharSequence)this.getControl().getContent(), (int)this.getControl().getCaretOffset(), (boolean)true);
        if (following != -1) {
            this.moveCaretAbsolute(following);
        }
    }

    protected void defaultNavigateWordPrevious() {
        int previous = TextUtil.findWordStartOffset((TextUtil.IterableCharSequence)this.getControl().getContent(), (int)this.getControl().getCaretOffset(), (boolean)true);
        if (previous != -1) {
            this.moveCaretAbsolute(previous);
        }
    }

    protected void defaultSelectTextStart() {
        this.moveCaretAbsolute(0, true);
    }

    protected void defaultSelectTextEnd() {
        this.moveCaretAbsolute(this.getControl().getCharCount(), true);
    }

    protected void defaultNavigateTextPageUp() {
        this.moveCaretAbsolute(this.calculatePageUpOffset(), false);
    }

    protected void defaultNavigateTextPageDown() {
        this.moveCaretAbsolute(this.calculatePageDownOffset(), false);
    }

    protected void defaultSelectLineStart() {
        this.moveCaretAbsolute(this.computeCurrentLineStartOffset(), true);
    }

    protected void defaultSelectLineEnd() {
        int caretLine = this.getControl().getContent().getLineAtOffset(this.getControl().getCaretOffset());
        int end = this.getControl().getContent().getOffsetAtLine(caretLine) + this.getControl().getContent().getLine(caretLine).length();
        this.moveCaretAbsolute(end, true);
    }

    protected void defaultSelectWordNext() {
        int following = TextUtil.findWordEndOffset((TextUtil.IterableCharSequence)this.getControl().getContent(), (int)this.getControl().getCaretOffset(), (boolean)true);
        if (following != -1) {
            this.moveCaretAbsolute(following, true);
        }
    }

    protected void defaultSelectWordPrevious() {
        int previous = TextUtil.findWordStartOffset((TextUtil.IterableCharSequence)this.getControl().getContent(), (int)this.getControl().getCaretOffset(), (boolean)true);
        if (previous != -1) {
            this.moveCaretAbsolute(previous, true);
        }
    }

    protected void defaultSelectWord() {
        IntTuple bounds = TextUtil.findWordBounds((TextUtil.IterableCharSequence)this.getControl().getContent(), (int)this.getControl().getCaretOffset(), (boolean)true);
        int previous = bounds.value1;
        int next = bounds.value2;
        if (previous != -1 && next != -1) {
            this.moveCaretAbsolute(previous);
            this.moveCaretAbsolute(next, true);
        }
    }

    protected void defaultSelectLine() {
        @NonNull LineRegion lineRegion = this.getLineRegion(this.getControl().getSelection());
        lineRegion.selectWithCaretAtEnd();
    }

    protected void defaultDeleteLine() {
        LineRegion lineRegion = this.getLineRegion(this.getControl().getSelection());
        lineRegion.replace("");
        this.moveCaretAbsolute(lineRegion.start);
    }

    protected void defaultDeleteWordNext() {
        int offset = this.getControl().getCaretOffset();
        int following = TextUtil.findWordEndOffset((TextUtil.IterableCharSequence)this.getControl().getContent(), (int)offset, (boolean)true);
        if (following != -1) {
            this.getControl().getContent().replaceTextRange(this.getControl().getCaretOffset(), following - offset, "");
        }
    }

    protected void defaultDeleteWordPrevious() {
        int offset = this.getControl().getCaretOffset();
        int previous = TextUtil.findWordStartOffset((TextUtil.IterableCharSequence)this.getControl().getContent(), (int)offset, (boolean)true);
        if (previous != -1) {
            this.getControl().setCaretOffset(previous);
            this.getControl().getContent().replaceTextRange(previous, offset - previous, "");
        }
    }

    protected void defaultMoveLinesUp() {
        LineRegion moveTarget = this.getLineRegion(this.getControl().getSelection());
        if (moveTarget.firstLine > 0) {
            LineRegion above = new LineRegion(moveTarget.firstLine - 1);
            LineRegion all = new LineRegion(above.firstLine, moveTarget.lastLine);
            String aboveText = above.read();
            Object moveTargetText = moveTarget.read();
            if (moveTarget.lastLine + 1 == this.getControl().getContent().getLineCount()) {
                moveTargetText = (String)moveTargetText + this.getControl().getLineSeparator().getValue();
                aboveText = aboveText.replaceFirst("\r?\n$", "");
            }
            all.replace((String)moveTargetText + aboveText);
            new LineRegion(moveTarget.firstLine - 1, moveTarget.lastLine - 1).selectWithCaretAtStart();
        }
    }

    protected void defaultMoveLinesDown() {
        LineRegion moveTarget = this.getLineRegion(this.getControl().getSelection());
        if (moveTarget.lastLine + 1 < this.getControl().getContent().getLineCount()) {
            LineRegion below = new LineRegion(moveTarget.lastLine + 1);
            LineRegion all = new LineRegion(moveTarget.firstLine, below.lastLine);
            Object belowText = below.read();
            String moveTargetText = moveTarget.read();
            if (below.lastLine + 1 == this.getControl().getContent().getLineCount()) {
                belowText = (String)belowText + this.getControl().getLineSeparator().getValue();
                moveTargetText = moveTargetText.replaceFirst("\r?\n$", "");
            }
            all.replace((String)belowText + moveTargetText);
            new LineRegion(moveTarget.firstLine + 1, moveTarget.lastLine + 1).selectWithCaretAtStart();
        }
    }

    protected void defaultNewLine() {
        int offset = this.getControl().getCaretOffset();
        int line = this.getControl().getContent().getLineAtOffset(offset);
        int lineOffset = offset - this.getControl().getContent().getOffsetAtLine(line);
        String lineContent = this.getControl().getContent().getLine(line);
        char[] chars = lineContent.toCharArray();
        Object prefix = "";
        int i = 0;
        while (i < Math.min(lineOffset, chars.length)) {
            if (chars[i] != ' ' && chars[i] != '\t') break;
            prefix = (String)prefix + chars[i];
            ++i;
        }
        if (this.getControl().getSelection().length > 0) {
            int caretPos = this.getControl().getSelection().offset + this.getControl().getLineSeparator().getValue().length() + ((String)prefix).length();
            this.getControl().getContent().replaceTextRange(this.getControl().getSelection().offset, this.getControl().getSelection().length, this.getControl().getLineSeparator().getValue() + (String)prefix);
            this.getControl().setCaretOffset(caretPos);
        } else {
            this.getControl().getContent().replaceTextRange(this.getControl().getCaretOffset(), 0, this.getControl().getLineSeparator().getValue() + (String)prefix);
            this.getControl().setCaretOffset(offset + this.getControl().getLineSeparator().getValue().length() + ((String)prefix).length());
        }
    }

    protected void defaultSelectAll() {
        int length = this.getControl().getContent().getCharCount();
        this.getControl().setSelectionRange(0, length);
    }

    protected void defaultCopy() {
        this.getControl().copy();
    }

    protected void defaultPaste() {
        if (this.getControl().getEditable()) {
            this.getControl().paste();
        }
    }

    protected void defaultCut() {
        if (this.getControl().getEditable()) {
            this.getControl().cut();
        }
    }

    protected void defaultDelete() {
        int offset = this.getControl().getCaretOffset();
        TextSelection selection = this.getControl().getSelection();
        if (selection.length > 0) {
            this.getControl().getContent().replaceTextRange(selection.offset, selection.length, "");
            this.getControl().setCaretOffset(selection.offset);
        } else {
            int del = 1;
            if (this.getControl().getCaretOffset() + 2 <= this.getControl().getContent().getCharCount() && "\r\n".equals(this.getControl().getContent().getTextRange(this.getControl().getCaretOffset(), 2))) {
                del = 2;
            }
            if (this.getControl().getCaretOffset() + del <= this.getControl().getContent().getCharCount()) {
                this.getControl().getContent().replaceTextRange(this.getControl().getCaretOffset(), del, "");
                this.getControl().setCaretOffset(offset);
            }
        }
    }

    protected void defaultDeletePrevious() {
        int offset = this.getControl().getCaretOffset();
        TextSelection selection = this.getControl().getSelection();
        if (selection.length > 0) {
            this.getControl().getContent().replaceTextRange(selection.offset, selection.length, "");
            this.getControl().setCaretOffset(selection.offset);
        } else {
            int start = this.getControl().getCaretOffset() - 1;
            int del = 1;
            if (start - 1 >= 0 && "\r\n".equals(this.getControl().getContent().getTextRange(this.getControl().getCaretOffset() - 2, 2))) {
                --start;
                del = 2;
            }
            if (start >= 0) {
                this.getControl().getContent().replaceTextRange(start, del, "");
                this.getControl().setCaretOffset(offset - del);
            }
        }
    }

    private boolean isMultilineSelection() {
        return this.getControl().getLineAtOffset(this.getControl().getSelection().offset) != this.getControl().getLineAtOffset(this.getControl().getSelection().offset + this.getControl().getSelection().length);
    }

    protected void defaultIndent() {
        if (this.isMultilineSelection()) {
            String allContent = this.getControl().getContent().getTextRange(0, this.getControl().getCharCount());
            StringBuffer dataBuffer = new StringBuffer(allContent);
            int caret = this.getControl().getCaretOffset();
            int selectionOffset = this.getControl().getSelection().offset;
            int selectionLength = this.getControl().getSelection().length;
            int firstLine = this.getControl().getLineAtOffset(selectionOffset);
            int lastLine = this.getControl().getLineAtOffset(selectionOffset + selectionLength);
            if (this.getControl().getOffsetAtLine(lastLine) < selectionOffset + selectionLength) {
                ++lastLine;
            }
            int added = 0;
            int firstLineDelta = 0;
            int indentLength = this.getControl().isInsertSpacesForTab() ? this.getControl().getTabAdvance() : 1;
            String insertString = "\t";
            if (this.getControl().isInsertSpacesForTab()) {
                StringBuilder b = new StringBuilder();
                int i = 0;
                while (i < this.getControl().getTabAdvance()) {
                    b.append(" ");
                    ++i;
                }
                insertString = b.toString();
            }
            int lineNumber = firstLine;
            while (lineNumber < lastLine) {
                int lineStart = this.getControl().getOffsetAtLine(lineNumber) + added;
                dataBuffer.replace(lineStart, lineStart + 0, insertString);
                added += insertString.length();
                if (lineNumber == firstLine && selectionOffset > lineStart) {
                    firstLineDelta = selectionOffset - lineStart;
                }
                ++lineNumber;
            }
            int start = selectionOffset - firstLineDelta;
            int length = selectionLength + added + firstLineDelta;
            String replaced = dataBuffer.substring(start, start + length);
            this.getControl().getContent().replaceTextRange(start, length - added, replaced);
            this.getControl().setCaretOffset(selectionOffset == caret ? caret + indentLength : caret + added);
            this.getControl().setSelectionRange(selectionOffset + indentLength, selectionLength + added - indentLength);
        }
    }

    protected void defaultOutdent() {
        String allContent = this.getControl().getContent().getTextRange(0, this.getControl().getCharCount());
        StringBuffer dataBuffer = new StringBuffer(allContent);
        int caret = this.getControl().getCaretOffset();
        int selectionOffset = this.getControl().getSelection().offset;
        int selectionLength = this.getControl().getSelection().length;
        int firstLine = this.getControl().getLineAtOffset(selectionOffset);
        int lastLine = this.getControl().getLineAtOffset(selectionOffset + selectionLength);
        if (this.getControl().getOffsetAtLine(lastLine) < selectionOffset + selectionLength) {
            ++lastLine;
        }
        int firstLineDelta = 0;
        int firstLineSelectionIndent = 0;
        int[] removals = new int[lastLine - firstLine];
        int lineNumber = firstLine;
        while (lineNumber < lastLine) {
            int lineStart = this.getControl().getOffsetAtLine(lineNumber);
            if (dataBuffer.charAt(lineStart) != '\t') {
                String begin = dataBuffer.substring(lineStart, Math.min(lineStart + this.getControl().getTabAdvance(), dataBuffer.length()));
                if (begin.length() != this.getControl().getTabAdvance()) {
                    return;
                }
                char[] cs = begin.toCharArray();
                int i = 0;
                while (i < cs.length) {
                    if (cs[i] == '\t') {
                        removals[lineNumber - firstLine] = i + 1;
                        break;
                    }
                    if (cs[i] != ' ') {
                        return;
                    }
                    ++i;
                }
                if (removals[lineNumber - firstLine] == 0) {
                    removals[lineNumber - firstLine] = this.getControl().getTabAdvance();
                }
            } else {
                removals[lineNumber - firstLine] = 1;
            }
            if (lineNumber == firstLine && selectionOffset > lineStart) {
                firstLineDelta = removals[lineNumber - firstLine];
                firstLineSelectionIndent = selectionOffset - lineStart;
            }
            ++lineNumber;
        }
        int start = selectionOffset - firstLineSelectionIndent;
        int end = start + selectionLength + firstLineSelectionIndent;
        String replacedText = dataBuffer.substring(start, end);
        int removed = 0;
        int lineNumber2 = lastLine - 1;
        while (lineNumber2 >= firstLine) {
            int lineStart = this.getControl().getOffsetAtLine(lineNumber2);
            dataBuffer.replace(lineStart, lineStart + removals[lineNumber2 - firstLine], "");
            removed += removals[lineNumber2 - firstLine];
            --lineNumber2;
        }
        String newText = dataBuffer.substring(start, end - removed);
        this.getControl().getContent().replaceTextRange(start, replacedText.length(), newText);
        this.getControl().setCaretOffset(selectionOffset == caret ? caret - firstLineDelta : caret - removed);
        this.getControl().setSelectionRange(selectionOffset - firstLineDelta, selectionLength - removed + firstLineDelta);
    }

    protected void defaultUp(boolean select) {
        int currentRowIndex = this.getControl().getContent().getLineAtOffset(this.getControl().getCaretOffset());
        int offset = this.getControl().getCaretOffset();
        int rowIndex = currentRowIndex;
        if (rowIndex == 0) {
            return;
        }
        int colIdx = offset - this.getControl().getContent().getOffsetAtLine(rowIndex);
        int lineOffset = this.getControl().getContent().getOffsetAtLine(--rowIndex);
        int newCaretPosition = lineOffset + colIdx;
        int maxPosition = lineOffset + this.getControl().getContent().getLine(rowIndex).length();
        this.moveCaretAbsolute(Math.min(newCaretPosition, maxPosition), select);
    }

    protected void defaultDown(boolean select) {
        int currentRowIndex = this.getControl().getContent().getLineAtOffset(this.getControl().getCaretOffset());
        int offset = this.getControl().getCaretOffset();
        int rowIndex = currentRowIndex;
        if (rowIndex + 1 == this.getControl().getContent().getLineCount()) {
            return;
        }
        int colIdx = offset - this.getControl().getContent().getOffsetAtLine(rowIndex);
        int lineOffset = this.getControl().getContent().getOffsetAtLine(++rowIndex);
        int newCaretPosition = lineOffset + colIdx;
        int maxPosition = lineOffset + this.getControl().getContent().getLine(rowIndex).length();
        this.moveCaretAbsolute(Math.min(newCaretPosition, maxPosition), select);
    }

    protected void defaultLeft(boolean select) {
        this.moveCaretRelative(-1, select);
    }

    protected void defaultNavigateToLine() {
        try {
            Optional<Integer> num = ((StyledTextSkin)this.getControl().getSkin()).fastQuery("Goto Line", "Line Number", Integer::parseInt);
            num.ifPresent(n -> this.defaultNavigateToLine(n - 1));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void defaultNavigateToLine(int lineIndex) {
        this.getControl().navigateToLine(lineIndex);
    }

    protected void defaultRight(boolean select) {
        this.moveCaretRelative(1, select);
    }

    protected void defaultScrollLineUp() {
        ((StyledTextSkin)this.getControl().getSkin()).scrollLineUp();
    }

    protected void defaultScrollLineDown() {
        ((StyledTextSkin)this.getControl().getSkin()).scrollLineDown();
    }

    void moveCaretAbsolute(int absoluteOffset) {
        int offset = Math.max(0, absoluteOffset);
        offset = Math.min(this.getControl().getCharCount(), offset);
        this.getControl().setCaretOffset(offset);
    }

    private void moveCaretAbsolute(int absoluteOffset, boolean select) {
        int offset = Math.max(0, absoluteOffset);
        offset = Math.min(this.getControl().getCharCount(), offset);
        if (offset > 0) {
            String textRange = this.getControl().getContent().getTextRange(offset - 1, 1);
            if (this.getControl().getCaretOffset() > offset) {
                if (textRange.equals("\r")) {
                    --offset;
                }
            } else if (textRange.equals("\r")) {
                ++offset;
            }
        }
        this.getControl().impl_setCaretOffset(Math.max(0, offset), select);
    }

    private void moveCaretRelative(int deltaOffset, boolean select) {
        int offset = this.getControl().getCaretOffset() + deltaOffset;
        this.moveCaretAbsolute(offset, select);
    }

    protected void initKeymapping(TriggerActionMapping m) {
        if (SystemUtils.isMacOS()) {
            m.map("Meta+Left", (TextEditAction)DefaultTextEditActions.LINE_START);
            m.map("Meta+Right", (TextEditAction)DefaultTextEditActions.LINE_END);
            m.map("Meta+Up", (TextEditAction)DefaultTextEditActions.TEXT_START);
            m.map("Meta+Down", (TextEditAction)DefaultTextEditActions.TEXT_END);
            m.map("Alt+Right", (TextEditAction)DefaultTextEditActions.WORD_NEXT);
            m.map("Alt+Left", (TextEditAction)DefaultTextEditActions.WORD_PREVIOUS);
            m.map("Page Down", (TextEditAction)DefaultTextEditActions.TEXT_PAGE_DOWN);
            m.map("Page Up", (TextEditAction)DefaultTextEditActions.TEXT_PAGE_UP);
            m.map("Meta+Shift+Left", (TextEditAction)DefaultTextEditActions.SELECT_LINE_START);
            m.map("Meta+Shift+Right", (TextEditAction)DefaultTextEditActions.SELECT_LINE_END);
            m.map("Meta+Shift+Up", (TextEditAction)DefaultTextEditActions.SELECT_TEXT_START);
            m.map("Meta+Shift+Down", (TextEditAction)DefaultTextEditActions.SELECT_TEXT_END);
            m.map("Alt+Shift+Right", (TextEditAction)DefaultTextEditActions.SELECT_WORD_NEXT);
            m.map("Alt+Shift+Left", (TextEditAction)DefaultTextEditActions.SELECT_WORD_PREVIOUS);
            m.map("Shift+Page Down", (TextEditAction)DefaultTextEditActions.SELECT_TEXT_PAGE_DOWN);
            m.map("Shift+Page Up", (TextEditAction)DefaultTextEditActions.SELECT_TEXT_PAGE_UP);
            m.map("Alt+Delete", (TextEditAction)DefaultTextEditActions.DELETE_WORD_NEXT);
            m.map("Alt+Backspace", (TextEditAction)DefaultTextEditActions.DELETE_WORD_PREVIOUS);
            m.map("Meta+D", (TextEditAction)DefaultTextEditActions.DELETE_LINE);
            m.map("Meta+C", (TextEditAction)DefaultTextEditActions.COPY);
            m.map("Meta+V", (TextEditAction)DefaultTextEditActions.PASTE);
            m.map("Meta+X", (TextEditAction)DefaultTextEditActions.CUT);
            m.map("Meta+A", (TextEditAction)DefaultTextEditActions.SELECT_ALL);
            m.map("Meta+Up", (TextEditAction)DefaultTextEditActions.SCROLL_LINE_UP);
            m.map("Meta+Down", (TextEditAction)DefaultTextEditActions.SCROLL_LINE_DOWN);
            m.map("Alt+Up", (TextEditAction)DefaultTextEditActions.MOVE_LINES_UP);
            m.map("Alt+Down", (TextEditAction)DefaultTextEditActions.MOVE_LINES_DOWN);
            m.map("Meta+L", (TextEditAction)DefaultTextEditActions.NAVIGATE_TO_LINE);
        } else {
            m.map("Ctrl+Right", (TextEditAction)DefaultTextEditActions.WORD_NEXT);
            m.map("Ctrl+Left", (TextEditAction)DefaultTextEditActions.WORD_PREVIOUS);
            m.map("Ctrl+Shift+Right", (TextEditAction)DefaultTextEditActions.SELECT_WORD_NEXT);
            m.map("Ctrl+Shift+Left", (TextEditAction)DefaultTextEditActions.SELECT_WORD_PREVIOUS);
            m.map("Page Down", (TextEditAction)DefaultTextEditActions.TEXT_PAGE_DOWN);
            m.map("Page Up", (TextEditAction)DefaultTextEditActions.TEXT_PAGE_UP);
            m.map("Shift+Page Down", (TextEditAction)DefaultTextEditActions.SELECT_TEXT_PAGE_DOWN);
            m.map("Shift+Page Up", (TextEditAction)DefaultTextEditActions.SELECT_TEXT_PAGE_UP);
            m.map("Home", (TextEditAction)DefaultTextEditActions.LINE_START);
            m.map("Shift+Home", (TextEditAction)DefaultTextEditActions.SELECT_LINE_START);
            m.map("Ctrl+Home", (TextEditAction)DefaultTextEditActions.TEXT_START);
            m.map("Ctrl+Shift+Home", (TextEditAction)DefaultTextEditActions.SELECT_TEXT_START);
            m.map("End", (TextEditAction)DefaultTextEditActions.LINE_END);
            m.map("Shift+End", (TextEditAction)DefaultTextEditActions.SELECT_LINE_END);
            m.map("Ctrl+End", (TextEditAction)DefaultTextEditActions.TEXT_END);
            m.map("Ctrl+Shift+End", (TextEditAction)DefaultTextEditActions.SELECT_TEXT_END);
            m.map("Ctrl+Delete", (TextEditAction)DefaultTextEditActions.DELETE_WORD_NEXT);
            m.map("Ctrl+Backspace", (TextEditAction)DefaultTextEditActions.DELETE_WORD_PREVIOUS);
            m.map("Ctrl+C", (TextEditAction)DefaultTextEditActions.COPY);
            m.map("Ctrl+V", (TextEditAction)DefaultTextEditActions.PASTE);
            m.map("Ctrl+X", (TextEditAction)DefaultTextEditActions.CUT);
            m.map("Ctrl+Insert", (TextEditAction)DefaultTextEditActions.COPY);
            m.map("Shift+Insert", (TextEditAction)DefaultTextEditActions.PASTE);
            m.map("Shift+Delete", (TextEditAction)DefaultTextEditActions.CUT);
            m.map("Ctrl+A", (TextEditAction)DefaultTextEditActions.SELECT_ALL);
            m.map("Ctrl+Up", (TextEditAction)DefaultTextEditActions.SCROLL_LINE_UP);
            m.map("Ctrl+Down", (TextEditAction)DefaultTextEditActions.SCROLL_LINE_DOWN);
            m.map("Ctrl+D", (TextEditAction)DefaultTextEditActions.DELETE_LINE);
            m.map("Alt+Up", (TextEditAction)DefaultTextEditActions.MOVE_LINES_UP);
            m.map("Alt+Down", (TextEditAction)DefaultTextEditActions.MOVE_LINES_DOWN);
            m.map("Ctrl+L", (TextEditAction)DefaultTextEditActions.NAVIGATE_TO_LINE);
        }
        m.mapConditional("tab-on-multiline", this::isMultilineSelection, "Tab", (TextEditAction)DefaultTextEditActions.INDENT);
        m.map("Shift+Tab", (TextEditAction)DefaultTextEditActions.OUTDENT);
        m.map("Delete", (TextEditAction)DefaultTextEditActions.DELETE);
        m.map("Backspace", (TextEditAction)DefaultTextEditActions.DELETE_PREVIOUS);
        m.map("Enter", (TextEditAction)DefaultTextEditActions.NEW_LINE);
        m.map("Up", (TextEditAction)DefaultTextEditActions.MOVE_UP);
        m.map("Down", (TextEditAction)DefaultTextEditActions.MOVE_DOWN);
        m.map("Left", (TextEditAction)DefaultTextEditActions.MOVE_LEFT);
        m.map("Right", (TextEditAction)DefaultTextEditActions.MOVE_RIGHT);
        m.map("Shift+Up", (TextEditAction)DefaultTextEditActions.SELECT_UP);
        m.map("Shift+Down", (TextEditAction)DefaultTextEditActions.SELECT_DOWN);
        m.map("Shift+Left", (TextEditAction)DefaultTextEditActions.SELECT_LEFT);
        m.map("Shift+Right", (TextEditAction)DefaultTextEditActions.SELECT_RIGHT);
    }

    public void triggerAction(TextEditAction action) {
        this.keyTriggerMapping.triggerAction(action, new TriggerActionMapping.Context(this.getControl()));
    }

    private class LineRegion
    extends Region {
        public final int firstLine;
        public final int lastLine;

        public LineRegion(int firstLine, int lastLine) {
            super(StyledTextBehavior.computeStart(StyledTextBehavior.this.getControl().getContent(), firstLine), StyledTextBehavior.computeLength(StyledTextBehavior.this.getControl().getContent(), firstLine, lastLine));
            this.firstLine = firstLine;
            this.lastLine = lastLine;
        }

        public LineRegion(int singleLineIndex) {
            this(singleLineIndex, singleLineIndex);
        }
    }

    private class Region {
        public final int start;
        public final int end;
        public final int length;

        Region(int startIndex, int length) {
            this.start = startIndex;
            this.end = startIndex + length;
            this.length = length;
        }

        public String read() {
            return StyledTextBehavior.this.getControl().getContent().getTextRange(this.start, this.length);
        }

        public void replace(@NonNull String replacement) {
            StyledTextBehavior.this.getControl().getContent().replaceTextRange(this.start, this.length, replacement);
        }

        public void selectWithCaretAtStart() {
            StyledTextBehavior.this.moveCaretAbsolute(this.start);
            StyledTextBehavior.this.getControl().setSelection(new TextSelection(this.start, this.length));
        }

        public void selectWithCaretAtEnd() {
            StyledTextBehavior.this.moveCaretAbsolute(this.end);
            StyledTextBehavior.this.getControl().setSelection(new TextSelection(this.start, this.length));
        }
    }
}

