/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.core;

import jakarta.annotation.PreDestroy;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.fx.core.StreamUtils;

public abstract class DisposeableCollector<T> {
    private Consumer<T> dispose;
    private List<T> objects = new ArrayList<T>();

    public DisposeableCollector(Consumer<T> dispose) {
        this.dispose = dispose;
    }

    protected void register(T o) {
        this.objects.add(o);
    }

    protected void unregister(T o) {
        this.objects.remove(o);
    }

    @PreDestroy
    public void dispose() {
        StreamUtils.reverse(this.objects).forEach(o -> {
            try {
                this.dispose.accept(o);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        });
        this.objects.clear();
    }
}

