/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.internal.project.registry;

import com.google.common.collect.HashMultimap;
import java.io.File;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.m2e.core.embedder.ArtifactKey;
import org.eclipse.m2e.core.internal.MavenPluginActivator;
import org.eclipse.m2e.core.internal.project.registry.Capability;
import org.eclipse.m2e.core.internal.project.registry.MavenProjectFacade;
import org.eclipse.m2e.core.internal.project.registry.RequiredCapability;
import org.eclipse.m2e.core.internal.project.registry.VersionlessKey;

abstract class BasicProjectRegistry
implements Serializable {
    private static final long serialVersionUID = 6232274446642339434L;
    private final String m2e_version = MavenPluginActivator.getQualifiedVersion();
    protected final Map<ArtifactKey, Set<IFile>> workspaceArtifacts = new HashMap<ArtifactKey, Set<IFile>>();
    protected final Map<IFile, MavenProjectFacade> workspacePoms = new HashMap<IFile, MavenProjectFacade>();
    protected final Map<File, MavenProjectFacade> workspacePomFiles = new HashMap<File, MavenProjectFacade>();
    protected final Map<VersionlessKey, Map<RequiredCapability, Set<IFile>>> requiredCapabilities = new HashMap<VersionlessKey, Map<RequiredCapability, Set<IFile>>>();
    protected final Map<IFile, Set<Capability>> projectCapabilities = new HashMap<IFile, Set<Capability>>();
    protected final Map<IFile, Set<RequiredCapability>> projectRequirements = new HashMap<IFile, Set<RequiredCapability>>();

    protected BasicProjectRegistry() {
    }

    protected BasicProjectRegistry(BasicProjectRegistry other) {
        this.replaceWith(other);
    }

    protected final void replaceWith(BasicProjectRegistry other) {
        this.clear();
        BasicProjectRegistry.copy(other.workspaceArtifacts, this.workspaceArtifacts);
        BasicProjectRegistry.copy(other.workspacePoms, this.workspacePoms);
        BasicProjectRegistry.copy(other.projectCapabilities, this.projectCapabilities);
        BasicProjectRegistry.copy(other.projectRequirements, this.projectRequirements);
        BasicProjectRegistry.copy(other.requiredCapabilities, this.requiredCapabilities);
        for (MavenProjectFacade facade : this.workspacePoms.values()) {
            this.workspacePomFiles.put(facade.getPomFile(), facade);
        }
    }

    private static void copy(Map from, Map to) {
        for (Map.Entry entry : from.entrySet()) {
            Object value = entry.getValue();
            if (value instanceof Map) {
                LinkedHashMap map = new LinkedHashMap();
                BasicProjectRegistry.copy((Map)value, map);
                value = map;
            } else if (value instanceof Set) {
                LinkedHashSet set = new LinkedHashSet((Set)value);
                value = set;
            }
            to.put(entry.getKey(), value);
        }
    }

    public MavenProjectFacade getProjectFacade(IFile pom) {
        return this.workspacePoms.get(pom);
    }

    public MavenProjectFacade getProjectFacade(File pom) {
        return this.workspacePomFiles.get(pom);
    }

    public MavenProjectFacade getProjectFacade(String groupId, String artifactId, String version) {
        Set<IFile> paths = this.workspaceArtifacts.get(new ArtifactKey(groupId, artifactId, version, null));
        if (paths == null || paths.isEmpty()) {
            return null;
        }
        return this.workspacePoms.get(paths.iterator().next());
    }

    public MavenProjectFacade[] getProjects() {
        return this.workspacePoms.values().toArray(new MavenProjectFacade[this.workspacePoms.size()]);
    }

    public Map<ArtifactKey, Collection<IFile>> getWorkspaceArtifacts(String groupId, String artifactId) {
        HashMultimap artifacts = HashMultimap.create();
        for (Map.Entry<ArtifactKey, Set<IFile>> entry : this.workspaceArtifacts.entrySet()) {
            ArtifactKey workspaceKey = entry.getKey();
            if (!groupId.equals(workspaceKey.getGroupId()) || !artifactId.equals(workspaceKey.getArtifactId())) continue;
            artifacts.putAll((Object)workspaceKey, (Iterable)entry.getValue());
        }
        return artifacts.asMap();
    }

    protected void clear() {
        this.workspaceArtifacts.clear();
        this.workspacePoms.clear();
        this.workspacePomFiles.clear();
        this.requiredCapabilities.clear();
        this.projectCapabilities.clear();
        this.projectRequirements.clear();
    }

    public boolean isValid() {
        return MavenPluginActivator.getQualifiedVersion().equals(this.m2e_version) && this.workspaceArtifacts != null && this.workspacePoms != null && this.workspacePomFiles != null && this.requiredCapabilities != null && this.projectCapabilities != null && this.projectRequirements != null && this.areFacadesValid();
    }

    private boolean areFacadesValid() {
        for (MavenProjectFacade facade : this.workspacePoms.values()) {
            if (facade != null && facade.getPom() != null && facade.getPom().getLocation() != null) continue;
            return false;
        }
        return true;
    }

    protected Set<RequiredCapability> getProjectRequirements(IFile pom) {
        return this.projectRequirements.get(pom);
    }
}

