/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.javart.util;

import eglx.lang.InvalidArgumentException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;

public class TimestampIntervalMask
implements Serializable {
    private static final long serialVersionUID = 10L;
    private String pattern;
    private transient String lowerCasePattern;

    public TimestampIntervalMask(String pattern) {
        this.lowerCasePattern = this.pattern = "";
        if (pattern != null && (pattern = pattern.trim()).length() > 0) {
            int[] flags = new int[100];
            int index = 0;
            int i = 0;
            while (i < pattern.length()) {
                switch (pattern.charAt(i)) {
                    case 'Y': 
                    case 'y': {
                        flags[index++] = 0;
                        break;
                    }
                    case 'm': {
                        flags[index++] = 4;
                        break;
                    }
                    case 'M': {
                        flags[index++] = 1;
                        break;
                    }
                    case 'D': 
                    case 'd': {
                        flags[index++] = 2;
                        break;
                    }
                    case 'H': 
                    case 'h': {
                        flags[index++] = 3;
                        break;
                    }
                    case 'S': 
                    case 's': {
                        flags[index++] = 5;
                        break;
                    }
                    case 'F': 
                    case 'f': {
                        flags[index++] = 6;
                        break;
                    }
                    default: {
                        InvalidArgumentException ex = new InvalidArgumentException();
                        throw ex.fillInMessage("EGL0053E", "yyyyMMddhhmmssffffff");
                    }
                }
                ++i;
            }
            int endIndex = index - 1;
            index = 0;
            while (index < endIndex) {
                if (flags[index] != flags[index + 1] && flags[index] + 1 != flags[index + 1]) {
                    InvalidArgumentException ex = new InvalidArgumentException();
                    throw ex.fillInMessage("EGL0053E", "yyyyMMddhhmmssffffff");
                }
                ++index;
            }
            this.pattern = pattern;
            this.lowerCasePattern = pattern.replace('S', 'f').toLowerCase();
        }
    }

    public int getStartCode() {
        if (this.lowerCasePattern.length() > 0) {
            switch (this.lowerCasePattern.charAt(0)) {
                case 'y': {
                    return 0;
                }
                case 'm': {
                    return this.isMonth(true) ? 1 : 4;
                }
                case 'd': {
                    return 2;
                }
                case 'h': {
                    return 3;
                }
                case 's': {
                    return 5;
                }
                case 'f': {
                    switch (this.numStartChars()) {
                        case 1: {
                            return 6;
                        }
                        case 2: {
                            return 7;
                        }
                        case 3: {
                            return 8;
                        }
                        case 4: {
                            return 9;
                        }
                        case 5: {
                            return 10;
                        }
                        case 6: {
                            return 11;
                        }
                    }
                }
            }
        }
        return -1;
    }

    public int getEndCode() {
        if (this.lowerCasePattern.length() > 0) {
            switch (this.lowerCasePattern.charAt(this.lowerCasePattern.length() - 1)) {
                case 'y': {
                    return 0;
                }
                case 'm': {
                    return this.isMonth(false) ? 1 : 4;
                }
                case 'd': {
                    return 2;
                }
                case 'h': {
                    return 3;
                }
                case 's': {
                    return 5;
                }
                case 'f': {
                    switch (this.numEndChars()) {
                        case 1: {
                            return 6;
                        }
                        case 2: {
                            return 7;
                        }
                        case 3: {
                            return 8;
                        }
                        case 4: {
                            return 9;
                        }
                        case 5: {
                            return 10;
                        }
                        case 6: {
                            return 11;
                        }
                    }
                }
            }
        }
        return -1;
    }

    private boolean isMonth(boolean isStartCode) {
        if (isStartCode) {
            int count = this.numStartChars();
            if (this.lowerCasePattern.length() == count) {
                return this.pattern.charAt(0) == 'M';
            }
            return this.lowerCasePattern.charAt(count) == 'd';
        }
        int count = this.numEndChars();
        if (this.lowerCasePattern.length() == count) {
            return this.pattern.charAt(0) == 'M';
        }
        return this.lowerCasePattern.charAt(this.lowerCasePattern.length() - count - 1) == 'y';
    }

    private int numStartChars() {
        int count = 1;
        char prevCh = this.lowerCasePattern.charAt(0);
        int i = 1;
        while (i < this.lowerCasePattern.length()) {
            if (this.lowerCasePattern.charAt(i) != prevCh) break;
            prevCh = this.lowerCasePattern.charAt(i);
            ++count;
            ++i;
        }
        return count;
    }

    private int numEndChars() {
        int count = 1;
        char prevCh = this.lowerCasePattern.charAt(this.lowerCasePattern.length() - 1);
        int i = this.lowerCasePattern.length() - 2;
        while (i >= 0) {
            if (this.lowerCasePattern.charAt(i) != prevCh) break;
            prevCh = this.lowerCasePattern.charAt(i);
            ++count;
            --i;
        }
        return count;
    }

    public String getFormattingPattern(int startCode, int endCode) {
        StringBuilder buf = new StringBuilder();
        int idx = 0;
        int length = this.lowerCasePattern.length();
        switch (startCode) {
            case 0: {
                while (idx < length && this.lowerCasePattern.charAt(idx) == 'y') {
                    buf.append('y');
                    ++idx;
                }
                if (endCode == 0) break;
            }
            case 1: {
                if (startCode != 1) {
                    buf.append('-');
                }
                while (idx < length && this.lowerCasePattern.charAt(idx) == 'm') {
                    buf.append('M');
                    ++idx;
                }
                if (endCode == 1) break;
            }
            case 2: {
                if (startCode != 2) {
                    buf.append('-');
                }
                while (idx < length && this.lowerCasePattern.charAt(idx) == 'd') {
                    buf.append('d');
                    ++idx;
                }
                if (endCode == 2) break;
            }
            case 3: {
                if (startCode != 3) {
                    buf.append(' ');
                }
                while (idx < length && this.lowerCasePattern.charAt(idx) == 'h') {
                    buf.append('H');
                    ++idx;
                }
                if (endCode == 3) break;
            }
            case 4: {
                if (startCode != 4) {
                    buf.append(':');
                }
                while (idx < length && this.lowerCasePattern.charAt(idx) == 'm') {
                    buf.append('m');
                    ++idx;
                }
                if (endCode == 4) break;
            }
            case 5: {
                if (startCode != 5) {
                    buf.append(':');
                }
                while (idx < length && this.lowerCasePattern.charAt(idx) == 's') {
                    buf.append('s');
                    ++idx;
                }
                if (endCode == 5) break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                if (startCode <= 5) {
                    buf.append('.');
                }
                int i = 0;
                while (i < endCode - 5) {
                    buf.append('S');
                    ++i;
                }
                break;
            }
        }
        return buf.toString();
    }

    public int getMaskLength() {
        return this.pattern.length();
    }

    public int getYearDigits() {
        return this.getDigits('y');
    }

    public int getMonthDigits() {
        return this.getDigits('m');
    }

    public int getDayDigits() {
        return this.getDigits('d');
    }

    public int getHourDigits() {
        return this.getDigits('h');
    }

    public int getMinuteDigits() {
        return this.getDigits('m');
    }

    public int getSecondDigits() {
        return this.getDigits('s');
    }

    public int getFractionDigits() {
        return this.getDigits('f');
    }

    private int getDigits(char type) {
        int first = this.lowerCasePattern.indexOf(type);
        if (first >= 0) {
            int last = this.lowerCasePattern.lastIndexOf(type);
            return last - first + 1;
        }
        return 0;
    }

    public long getMaxMonthValue() {
        long maxValue = 0L;
        int firstY = this.lowerCasePattern.indexOf(121);
        int firstM = this.lowerCasePattern.indexOf(109);
        if (firstM >= 0) {
            if (firstY >= 0) {
                maxValue = 11L;
            } else {
                int lastM = this.lowerCasePattern.lastIndexOf(109);
                maxValue = this.maxValue(lastM - firstM + 1);
            }
        }
        if (firstY >= 0) {
            int lastY = this.lowerCasePattern.lastIndexOf(121);
            maxValue += this.maxValue(lastY - firstY + 1) * 12L;
        }
        return maxValue;
    }

    public long getMaxSecondValue() {
        int multiplier;
        long maxValue = 0L;
        char firstChar = this.lowerCasePattern.charAt(0);
        switch (firstChar) {
            case 'd': {
                multiplier = 86400;
                break;
            }
            case 'h': {
                multiplier = 3600;
                break;
            }
            case 'm': {
                multiplier = 60;
                break;
            }
            case 's': {
                multiplier = 1;
                break;
            }
            default: {
                multiplier = 0;
            }
        }
        maxValue = (this.maxValue(this.lowerCasePattern.lastIndexOf(firstChar) + 1) + 1L) * (long)multiplier - 1L;
        return maxValue;
    }

    private long maxValue(int digits) {
        switch (digits) {
            case 1: {
                return 9L;
            }
            case 2: {
                return 99L;
            }
            case 3: {
                return 999L;
            }
            case 4: {
                return 9999L;
            }
            case 5: {
                return 99999L;
            }
            case 6: {
                return 999999L;
            }
            case 7: {
                return 9999999L;
            }
            case 8: {
                return 99999999L;
            }
            case 9: {
                return 999999999L;
            }
        }
        return 0L;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.lowerCasePattern = this.pattern == null ? "" : this.pattern.toLowerCase();
    }
}

