/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.javart.services.servlet.rest.rpc;

import eglx.http.HttpMethod;
import eglx.http.HttpUtilities;
import eglx.http.Request;
import eglx.http.Response;
import eglx.json.JsonLib;
import eglx.json.JsonUtilities;
import eglx.services.Encoding;
import eglx.services.ServiceInvocationException;
import eglx.services.ServiceKind;
import java.net.MalformedURLException;
import java.net.URL;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.edt.javart.services.ServiceUtilities;
import org.eclipse.edt.javart.services.servlet.JsonRpcInvoker;
import org.eclipse.edt.javart.services.servlet.Servlet;
import org.eclipse.edt.javart.services.servlet.rest.rpc.RestRpcUtilities;
import org.eclipse.edt.javart.services.servlet.rest.rpc.RestServiceProjectInfo;

public class ServiceServlet
extends Servlet {
    private static final long serialVersionUID = 10L;
    static final String SERVICE_SERVLET = "EGL REST Service servlet";
    protected String contextRoot;
    protected RestServiceProjectInfo restServiceProjectInfo;

    @Override
    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.contextRoot = config.getServletContext().getContextPath();
        while (this.contextRoot.charAt(0) == '/') {
            this.contextRoot = this.contextRoot.substring(1);
        }
        this.traceInfos();
    }

    @Override
    protected String servletName() {
        return SERVICE_SERVLET;
    }

    protected RestServiceProjectInfo restServiceProjectInfo() {
        if (this.restServiceProjectInfo == null) {
            this.restServiceProjectInfo = RestRpcUtilities.getRestServiceInfo(String.valueOf(this.contextRoot) + "-uri.xml");
        }
        return this.restServiceProjectInfo;
    }

    @Override
    protected Response processRequest(String urlString, Request request, HttpServletRequest httpServletReq) {
        Response response;
        block18: {
            block17: {
                response = null;
                try {
                    if (HttpMethod.POST.equals((Object)request.method)) {
                        if (this.tracer().traceIsOn(1)) {
                            this.tracer().put("this is an EGL REST RPC service");
                        }
                        String pathInfo = null;
                        pathInfo = httpServletReq.getPathInfo();
                        if (pathInfo == null || pathInfo.length() == 0) {
                            String path;
                            try {
                                URL url = new URL(urlString);
                                path = url.getPath();
                            }
                            catch (MalformedURLException malformedURLException) {
                                path = urlString;
                            }
                            int contextRootStart = path.indexOf(47);
                            int contextRootEnd = path.indexOf(47, contextRootStart + 1);
                            int serviceIdx = path.indexOf(47, contextRootEnd + 1);
                            if (serviceIdx == -1) {
                                serviceIdx = path.length();
                            }
                            pathInfo = path.substring(serviceIdx);
                        }
                        if (this.restServiceProjectInfo() == null) break block17;
                        RestServiceProjectInfo.ServiceFunctionInfo serviceFunctionInfo = this.restServiceProjectInfo().getServiceFunctionInfo(pathInfo, request.method);
                        if (this.tracer().traceIsOn(1) && serviceFunctionInfo != null) {
                            this.tracer().put("invoking service " + serviceFunctionInfo.getClassName());
                            this.tracer().put("    request encoding:" + String.valueOf((Object)serviceFunctionInfo.getInEncoding()));
                            this.tracer().put("    response encoding:" + String.valueOf((Object)serviceFunctionInfo.getOutEncoding()));
                            this.tracer().put("    hostProgramService?:" + String.valueOf(serviceFunctionInfo.isHostProgramService()));
                            this.tracer().put("    body:" + request.body == null ? "null" : request.body);
                        }
                        response = new Response();
                        if (serviceFunctionInfo != null) {
                            JsonRpcInvoker invoker = new JsonRpcInvoker(serviceFunctionInfo.getClassName(), ServiceKind.REST);
                            response = invoker.invoke(request);
                            if (this.tracer().traceIsOn(1)) {
                                this.tracer().put("returned from service" + (Object)((Object)response) == null ? "null" : JsonLib.convertToJSON(response));
                            }
                            break block17;
                        }
                        throw ServiceUtilities.buildServiceInvocationException("EGL0029E", new String[]{urlString}, null, ServiceKind.WEB);
                    }
                    throw ServiceUtilities.buildServiceInvocationException("EGL0030E", new String[]{HttpUtilities.httpMethodToString(request.method)}, null, ServiceKind.WEB);
                }
                catch (ServiceInvocationException sie) {
                    if (response == null) {
                        response = new Response();
                    }
                    response.body = JsonUtilities.createJsonAnyException(sie);
                    response.status = 500;
                    response.statusMessage = "FAILED";
                    HttpUtilities.addContentType(response, Encoding.JSON, null);
                    break block18;
                }
                catch (Throwable throwable) {
                    try {
                        if (response == null) {
                            response = new Response();
                        }
                        response.body = JsonUtilities.createJsonAnyException(ServiceUtilities.buildServiceInvocationException("EGL0024E", new String[]{urlString, "POST"}, null, ServiceKind.REST));
                        response.status = 500;
                        response.statusMessage = "FAILED";
                    }
                    catch (Throwable throwable2) {
                        HttpUtilities.addContentType(response, Encoding.JSON, null);
                        throw throwable2;
                    }
                    HttpUtilities.addContentType(response, Encoding.JSON, null);
                    break block18;
                }
            }
            HttpUtilities.addContentType(response, Encoding.JSON, null);
        }
        return response;
    }

    protected boolean resultContainsError(String result) {
        return result.indexOf("{\"error\" : {") != -1;
    }

    private void traceInfos() {
        if (this.tracer().traceIsOn(1)) {
            StringBuilder buf = new StringBuilder();
            buf.append("EGL REST service servlet " + this.contextRoot + " starting" + '\n');
            buf.append(this.restServiceProjectInfo().toString());
            this.trace(buf.toString());
        }
    }
}

