/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.javart.services.servlet.proxy;

import eglx.http.Request;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import org.eclipse.edt.javart.Runtime;
import org.eclipse.edt.javart.services.servlet.Invoker;

abstract class EglHttpConnection
extends Invoker {
    protected EglHttpConnection() {
    }

    protected HttpURLConnection getHttpProxyConnection(Request restRequest) throws IOException {
        if (this.useProxy()) {
            return EglHttpConnection.getProxyConnection(restRequest);
        }
        return null;
    }

    protected HttpURLConnection openConnection(Request restRequest) throws IOException {
        HttpURLConnection connection = this.getHttpProxyConnection(restRequest);
        if (connection == null) {
            connection = (HttpURLConnection)new URL(restRequest.uri).openConnection();
        }
        return connection;
    }

    private boolean useProxy() {
        return "true".equals(Runtime.getRunUnit().getProperties().get("egl.service.invocation.useProxy"));
    }

    private static HttpURLConnection getProxyConnection(Request restRequest) throws IOException {
        String urlString = restRequest.uri;
        Proxy proxy = EglHttpConnection.getProxy(urlString);
        if (proxy != null) {
            return (HttpURLConnection)new URL(urlString).openConnection(proxy);
        }
        return null;
    }

    private static Proxy getProxy(String urlString) {
        Proxy proxy;
        block5: {
            proxy = null;
            ProxySelector ps = ProxySelector.getDefault();
            try {
                URI uri = new URI(urlString);
                List<Proxy> proxies = ps.select(uri);
                if (proxies == null || proxies.size() <= 0) break block5;
                int idx = 0;
                while (idx < proxies.size()) {
                    Proxy tempProxy = proxies.get(idx);
                    if (tempProxy.type() == Proxy.Type.HTTP) {
                        proxy = tempProxy;
                        break;
                    }
                    if (tempProxy.type() == Proxy.Type.SOCKS && proxy == null) {
                        proxy = tempProxy;
                    }
                    ++idx;
                }
            }
            catch (URISyntaxException uRISyntaxException) {}
        }
        return proxy;
    }
}

