/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.javart.services.servlet;

import eglx.http.HttpUtilities;
import eglx.http.Request;
import eglx.http.Response;
import eglx.json.JsonLib;
import eglx.lang.AnyException;
import eglx.services.ServiceInvocationException;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.edt.javart.AnyBoxedObject;
import org.eclipse.edt.runtime.java.eglx.lang.EDictionary;

public class ServletUtilities {
    private ServletUtilities() {
    }

    public static Request createHttpRequest(String object) throws ServiceInvocationException {
        Request request = null;
        if (object == null) {
            request = new Request();
        } else {
            try {
                EDictionary localRequest = new EDictionary();
                JsonLib.convertFromJSON(object, localRequest);
                request = new Request();
                Object obj = ServletUtilities.unBox(localRequest.get((Object)"body"));
                request.body = obj == null ? null : obj.toString();
                request.headers = (EDictionary)ServletUtilities.unBox(localRequest.get((Object)"headers"));
                obj = ServletUtilities.unBox(localRequest.get((Object)"method"));
                request.method = HttpUtilities.convert(obj instanceof Number ? ((Number)obj).intValue() : -1);
                obj = ServletUtilities.unBox(localRequest.get((Object)"uri"));
                request.uri = obj == null ? null : obj.toString();
            }
            catch (AnyException anyException) {}
        }
        return request;
    }

    private static Object unBox(Object obj) {
        while (obj instanceof AnyBoxedObject) {
            obj = ((AnyBoxedObject)obj).ezeUnbox();
        }
        return obj;
    }

    public static void setBody(Response outerResponse, Response innerResponse) {
        if (innerResponse == null) {
            innerResponse = new Response();
        }
        outerResponse.body = JsonLib.convertToJSON(innerResponse);
    }

    public static Request createNewRequest(HttpServletRequest httpServletReq) throws IOException {
        Request newRequest = new Request();
        newRequest.method = HttpUtilities.convert(httpServletReq.getMethod());
        newRequest.uri = httpServletReq.getRequestURI();
        newRequest.headers = ServletUtilities.processHeaders(httpServletReq);
        BufferedReader reader = httpServletReq.getReader();
        newRequest.body = ServletUtilities.processContent(httpServletReq.getContentLength(), reader);
        return newRequest;
    }

    private static EDictionary processHeaders(HttpServletRequest httpServletReq) throws IOException {
        EDictionary result = new EDictionary();
        Enumeration headerEnum = httpServletReq.getHeaderNames();
        while (headerEnum.hasMoreElements()) {
            String headername = (String)headerEnum.nextElement();
            result.put(headername, (Object)httpServletReq.getHeader(headername));
        }
        return result;
    }

    private static String processContent(int contentLength, BufferedReader reader) throws IOException {
        StringBuilder contentBuffer = new StringBuilder();
        if (contentLength > 0) {
            int i = 0;
            while (i < contentLength) {
                char nRead = (char)reader.read();
                contentBuffer.append(nRead);
                String str = Character.toString(nRead);
                byte[] bytes = str.getBytes("utf-8");
                i += bytes.length;
            }
        }
        return contentBuffer.toString();
    }
}

