/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.gen.deployment.util;

import com.ibm.icu.util.StringTokenizer;
import java.util.ArrayList;

public class PropertiesFileUtil {
    private static final String BUNDLE_SEPARATOR = "-";
    private String propertiesFileName;
    private String userMessageLocale;

    public PropertiesFileUtil(String propertiesFileName, String userMessageLocale) {
        this.propertiesFileName = propertiesFileName;
        this.userMessageLocale = userMessageLocale;
    }

    public PropertiesFileUtil(String includeStatement) {
        int sepIndex;
        String temp = includeStatement;
        int lastDot = temp.lastIndexOf(46);
        if (lastDot != -1) {
            temp = temp.substring(0, lastDot);
        }
        if ((sepIndex = temp.indexOf(BUNDLE_SEPARATOR)) != -1) {
            this.propertiesFileName = temp.substring(temp.lastIndexOf("/") + 1, sepIndex);
            this.userMessageLocale = temp.substring(sepIndex + 1, temp.length());
        } else {
            this.propertiesFileName = temp.substring(temp.lastIndexOf("/") + 1);
            this.userMessageLocale = "";
        }
    }

    public String getBundleName() {
        return this.propertiesFileName;
    }

    public String getUserMessageLocale() {
        return this.userMessageLocale;
    }

    public String generateIncludeStatement() {
        return String.valueOf(this.propertiesFileName) + BUNDLE_SEPARATOR + this.userMessageLocale + ".js";
    }

    public String[] generatePropertiesFileNames() {
        StringTokenizer st = new StringTokenizer(this.userMessageLocale, "_");
        int count = st.countTokens();
        String[] names = new String[count + 1];
        if (count > 0) {
            String prefix = String.valueOf(this.propertiesFileName) + BUNDLE_SEPARATOR + st.nextToken();
            names[count - 1] = String.valueOf(prefix) + ".properties";
            int i = count - 2;
            while (i >= 0) {
                prefix = String.valueOf(prefix) + '_' + st.nextToken();
                names[i] = String.valueOf(prefix) + ".properties";
                --i;
            }
        }
        names[count] = String.valueOf(this.propertiesFileName) + ".properties";
        return names;
    }

    public static String convertToProperitesFile(String includeStatement) {
        int lastDot = includeStatement.lastIndexOf(46);
        if (lastDot != -1) {
            includeStatement = includeStatement.substring(0, lastDot);
        }
        return String.valueOf(includeStatement) + ".properties";
    }

    public static String[] convertToProperitesFiles(String jsFileName) {
        ArrayList<String> names = new ArrayList<String>();
        int bundleIndex = jsFileName.lastIndexOf(BUNDLE_SEPARATOR);
        int lastIndex = jsFileName.lastIndexOf(46);
        jsFileName = jsFileName.substring(0, lastIndex);
        names.add(String.valueOf(jsFileName) + ".properties");
        if (bundleIndex != -1) {
            while (lastIndex > bundleIndex) {
                jsFileName = jsFileName.substring(0, lastIndex);
                names.add(String.valueOf(jsFileName) + ".properties");
                lastIndex = jsFileName.lastIndexOf(95);
            }
            names.add(String.valueOf(jsFileName.substring(0, bundleIndex)) + ".properties");
        }
        return names.toArray(new String[names.size()]);
    }
}

