/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.gen.deployment.javascript;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.Properties;
import org.eclipse.edt.javart.json.NameValuePairNode;
import org.eclipse.edt.javart.json.ObjectNode;
import org.eclipse.edt.javart.json.StringNode;
import org.eclipse.edt.javart.json.ValueNode;

public abstract class PropertiesFileGenerator {
    private String propertiesVariable;

    protected PropertiesFileGenerator(String propertiesVariable) {
        this.propertiesVariable = propertiesVariable;
    }

    public byte[] generatePropertiesFile(InputStream is, String bundleName) {
        byte[] result = null;
        byte[] propertiesFileBytes = this.loadPropertiesFile(is);
        if (propertiesFileBytes != null) {
            StringBuffer content = new StringBuffer();
            content.append("try{");
            content.append(String.valueOf(this.propertiesVariable) + "['" + bundleName + "'] = \n");
            content.append(this.convertPropertiesToJSON(propertiesFileBytes));
            content.append(";}catch(e){ }");
            try {
                result = content.toString().getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                result = content.toString().getBytes();
            }
        }
        return result;
    }

    protected String convertPropertiesToJSON(byte[] bytes) {
        String result;
        Properties properties = new Properties();
        try {
            properties.load(new InputStreamReader((InputStream)new ByteArrayInputStream(bytes), "UTF-8"));
            ObjectNode objectNode = new ObjectNode();
            for (String string : properties.keySet()) {
                StringNode keyNode = new StringNode(string, false);
                StringNode valueNode = new StringNode(((String)properties.get(string)).trim(), false);
                NameValuePairNode pairNode = new NameValuePairNode(keyNode, (ValueNode)valueNode);
                objectNode.addPair(pairNode);
            }
            result = objectNode.toJson();
        }
        catch (IOException iOException) {
            result = "";
        }
        return result;
    }

    protected byte[] loadPropertiesFile(InputStream is) {
        byte[] result = null;
        if (is != null) {
            try {
                DataInputStream dis = new DataInputStream(new BufferedInputStream(is));
                try {
                    result = new byte[dis.available()];
                    dis.readFully(result);
                    dis.close();
                }
                catch (IOException iOException) {
                    dis.close();
                }
            }
            catch (Exception exception) {
                result = null;
            }
        }
        return result;
    }
}

