/*******************************************************************************
 * Copyright © 2011, 2013 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM Corporation - initial API and implementation
 *
 *******************************************************************************/
package org.eclipse.edt.gen.deployment.javascript;

import org.eclipse.edt.compiler.internal.interfaces.IGenerationMessageRequestor;
import org.eclipse.edt.gen.AbstractGeneratorCommand;
import org.eclipse.edt.gen.GenerationException;
import org.eclipse.edt.gen.deployment.javascript.templates.JavaScriptTemplate;
import org.eclipse.edt.mof.egl.Part;

public class CompileErrorHTMLGenerator extends ErrorHTMLGenerator {
	private String message;
	public CompileErrorHTMLGenerator(AbstractGeneratorCommand processor, IGenerationMessageRequestor requestor, String message) {
		super(processor, null, message);
		this.message = message;
	}
	
	public void generate(Object part) throws GenerationException {
		this.generate((Part) part, JavaScriptTemplate.genCompileErrorHTML);
	}
	
	public String generate() {
		out.println("<html>");
		out.println("<body>");
		out.println(message);
		out.println("</body>");
		out.println("</html>");
		return out.getWriter().toString();
	}
}
