/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ebpm.messaging.core;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.activation.DataHandler;
import javax.security.auth.Subject;
import javax.xml.transform.Source;
import org.eclipse.ebpm.attachments.Attachment;
import org.eclipse.ebpm.attachments.AttachmentFacade;
import org.eclipse.ebpm.attachments.AttachmentUtils;
import org.eclipse.ebpm.messaging.api.Message;
import org.eclipse.ebpm.messaging.core.util.SourceTransformer;
import org.eclipse.ebpm.messaging.core.util.StringSource;

public class MessageImpl
implements Message {
    private static final long serialVersionUID = -8621182821298293687L;
    private Source body;
    private String contentType;
    private String contentEncoding;
    private Subject securitySubject;
    private Map<String, Object> headers;
    private Map<String, String> _internalAttachmentsReferences;

    public Source getBody() {
        return this.body;
    }

    public void setBody(Source body) {
        this.body = body;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String type) {
        this.contentType = type;
    }

    public String getContentEncoding() {
        return this.contentEncoding;
    }

    public void setContentEncoding(String encoding) {
        this.contentEncoding = encoding;
    }

    public Subject getSecuritySubject() {
        return this.securitySubject;
    }

    public void setSecuritySubject(Subject securitySubject) {
        this.securitySubject = securitySubject;
    }

    public Object getHeader(String name) {
        if (this.headers == null) {
            return null;
        }
        return this.headers.get(name);
    }

    public void checkHeaderType(Object object) {
        if (!(object instanceof String || object instanceof Date || object instanceof Integer || object instanceof Boolean || object instanceof Float || object instanceof Double || object instanceof Long)) {
            if (object instanceof Map) {
                try {
                    Map cfr_ignored_0 = (Map)object;
                }
                catch (Exception exception) {
                    throw new RuntimeException("Only Map<String,String>  are supported header types");
                }
            } else {
                throw new RuntimeException("Only Date, Integer, Float, Double, String, Boolean are supported header types");
            }
        }
    }

    public void setHeader(String name, Object value) {
        this.checkHeaderType(value);
        if (this.headers == null) {
            this.headers = new HashMap<String, Object>();
        }
        this.headers.put(name, value);
    }

    public Object removeHeader(String name) {
        if (this.headers == null) {
            return null;
        }
        return this.headers.remove(name);
    }

    public Map<String, Object> getHeaders() {
        if (this.headers == null) {
            this.headers = new HashMap<String, Object>();
        }
        return this.headers;
    }

    public void setHeaders(Map<String, Object> headers) {
        this.headers = headers;
    }

    public Object getAttachment(String id) {
        DataHandler dh = null;
        if (this._internalAttachmentsReferences != null) {
            String idInPersistentStore = this._internalAttachmentsReferences.get(id);
            Attachment att = AttachmentFacade.load((String)idInPersistentStore);
            dh = att.getDh();
        }
        return dh;
    }

    public void addAttachment(String id, Object value) {
        if (this._internalAttachmentsReferences == null) {
            this._internalAttachmentsReferences = new HashMap<String, String>();
        }
        String idInPersistenceStore = AttachmentFacade.store((String)id, (DataHandler)((DataHandler)value));
        this._internalAttachmentsReferences.put(id, idInPersistenceStore);
    }

    public void removeAttachment(String id) {
        if (this._internalAttachmentsReferences != null) {
            String idInPersistenceStore = this._internalAttachmentsReferences.get(id);
            AttachmentFacade.delete((String)idInPersistenceStore);
            this._internalAttachmentsReferences.remove(id);
        }
    }

    public void finalizeAttachments() {
        if (this._internalAttachmentsReferences != null) {
            for (String attachmentId : this._internalAttachmentsReferences.keySet()) {
                String idInPersistenceStore = this._internalAttachmentsReferences.get(attachmentId);
                AttachmentFacade.delete((String)idInPersistenceStore);
            }
            this._internalAttachmentsReferences.clear();
        }
    }

    public Map<String, Object> getAttachments() {
        if (this._internalAttachmentsReferences == null) {
            this._internalAttachmentsReferences = new HashMap<String, String>();
        }
        HashMap<String, Object> realAttachmentMap = new HashMap<String, Object>();
        for (String idAtt : this._internalAttachmentsReferences.keySet()) {
            realAttachmentMap.put(idAtt, this.getAttachment(idAtt));
        }
        return realAttachmentMap;
    }

    public void copyFrom(Message msg) {
        this.body = msg.getBody();
        if (!msg.getHeaders().isEmpty()) {
            this.headers = new HashMap<String, Object>();
            for (Map.Entry e : msg.getHeaders().entrySet()) {
                this.headers.put((String)e.getKey(), e.getValue());
            }
        } else {
            this.headers = null;
        }
        if (!msg.getAttachments().isEmpty()) {
            for (Map.Entry e : msg.getAttachments().entrySet()) {
                this.addAttachment((String)e.getKey(), e.getValue());
            }
        }
    }

    public Message copy() {
        MessageImpl copy = new MessageImpl();
        copy.copyFrom(this);
        return copy;
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
    }

    public String display(boolean displayContent) {
        return "Message []";
    }

    public String toString() {
        return this.display(false);
    }

    public String getBodyText() {
        try {
            return new SourceTransformer().toString(this.body);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void setBodyText(String xml) {
        this.setBody(new StringSource(xml));
    }

    public void setBody(String xml) {
        this.setBody(new StringSource(xml));
    }

    public String _encodeAttachments() {
        if (this._internalAttachmentsReferences == null || this._internalAttachmentsReferences.size() == 0) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        Iterator<String> it = this._internalAttachmentsReferences.keySet().iterator();
        while (it.hasNext()) {
            String id = it.next();
            sb.append(String.valueOf(id) + "," + this._internalAttachmentsReferences.get(id));
            if (!it.hasNext()) continue;
            sb.append(";");
        }
        return sb.toString();
    }

    public void _decodeAttachments(String encodedAttachments) {
        if (encodedAttachments == null) {
            return;
        }
        String[] attachmentTokens = AttachmentUtils.decodeAttachmentsIds((String)encodedAttachments);
        HashMap internalAttachments = AttachmentUtils.decodeAttachmentsIds((String[])attachmentTokens);
        if (this._internalAttachmentsReferences == null) {
            this._internalAttachmentsReferences = internalAttachments;
        } else {
            this._internalAttachmentsReferences.putAll(internalAttachments);
        }
    }
}

