/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ebpm.connectors.filesystem.adapters;

import java.io.BufferedWriter;
import java.io.InputStream;
import java.io.PrintWriter;
import org.dom4j.Document;
import org.dom4j.io.SAXReader;
import org.eclipse.ebpm.connectors.filesystem.adapters.IFileAdapter;
import org.eclipse.ebpm.messaging.api.Exchange;
import org.eclipse.ebpm.messaging.api.Message;

public class DefaultFileAdapter
implements IFileAdapter {
    @Override
    public String getOutputFileName(Exchange exchange, Message in) {
        String fileName = null;
        fileName = (String)in.getHeader("spagic.filename");
        if (fileName == null) {
            fileName = (String)exchange.getProperty("spagic.filename");
        }
        return fileName;
    }

    @Override
    public void writeMessage(Exchange exchange, Message in, BufferedWriter bw) throws Exception {
        String body = in.getBodyText();
        PrintWriter pw = new PrintWriter(bw);
        pw.write(body);
        pw.flush();
    }

    @Override
    public void readFile(Exchange exchange, Message in, InputStream is, String filePath) throws Exception {
        SAXReader reader = new SAXReader();
        Document doc = reader.read(is);
        in.setHeader("spagic.filepath", (Object)filePath);
        in.setBody(doc.getRootElement().asXML());
        exchange.setIn(in);
    }

    @Override
    public String getAdapterId() {
        return "DEFAULT";
    }
}

